/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPrimitiveTypeWrapperUsageInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    private static final Set<String> PRIMITIVE_TYPE_WRAPPERS = new THashSet(3);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPrimitiveTypeWrapperUsageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSPrimitiveTypeWrapperUsageInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSNewExpression(JSNewExpression node) {
                JSExpression expression = node.getMethodExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSQualifiedName qName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)expression));
                    if (qName == null || qName.getParent() != null) {
                        return;
                    }
                    String text = qName.getName();
                    if (PRIMITIVE_TYPE_WRAPPERS.contains(text)) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.primitive.type.wrapper.usage.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithPrimitiveCounterpartQuickFix(StringUtil.toLowerCase((String)text))});
                    } else if (this.canBeReplacedWithArrayOrObjectLiteral(node, text)) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.primitive.type.improper.instantiation.inspection", (Object[])new Object[]{text}), new LocalQuickFix[]{new ReplaceWithSimpleInstantiation(StringUtil.toLowerCase((String)text))});
                    }
                }
            }

            private boolean canBeReplacedWithArrayOrObjectLiteral(@NotNull JSNewExpression node, @NotNull String referenceName) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (referenceName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node instanceof TypeScriptNewExpression && ((TypeScriptNewExpression)node).getTypeArgumentList() != null) {
                    return false;
                }
                return "Array".equals(referenceName) && node.getArguments().length != 1 || "Object".equals(referenceName) && node.getArguments().length == 0 && !(node.getParent() instanceof JSFunctionExpression);
            }

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSExpression lExpr = node.getLOperand();
                if (lExpr == null) {
                    return;
                }
                if (lExpr instanceof JSDefinitionExpression) {
                    lExpr = ((JSDefinitionExpression)lExpr).getExpression();
                }
                if (lExpr == null) {
                    return;
                }
                if (lExpr instanceof JSReferenceExpression) {
                    JSExpression qualifier = ((JSReferenceExpression)lExpr).getQualifier();
                    boolean forbidNewProperties = false;
                    if (qualifier instanceof JSLiteralExpression) {
                        forbidNewProperties = true;
                    } else if (qualifier instanceof JSReferenceExpression) {
                        if ("prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                            return;
                        }
                        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
                        if (type instanceof JSPrimitiveType && ((JSPrimitiveType)type).isPrimitive() && type.isSourceStrict()) {
                            forbidNewProperties = true;
                        }
                    }
                    if (forbidNewProperties) {
                        holder.registerProblem((PsiElement)lExpr, JavaScriptBundle.message((String)"js.assigning.to.primitive.type.property", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referenceName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$1";
                objectArray[2] = "canBeReplacedWithArrayOrObjectLiteral";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static {
        PRIMITIVE_TYPE_WRAPPERS.add("Boolean");
        PRIMITIVE_TYPE_WRAPPERS.add("Number");
        PRIMITIVE_TYPE_WRAPPERS.add("String");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ReplaceWithSimpleInstantiation
    implements LocalQuickFix {
        private final String myLiteralName;

        ReplaceWithSimpleInstantiation(String literalName) {
            this.myLiteralName = literalName;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.literal", (Object[])new Object[]{this.myLiteralName});
            if (string == null) {
                ReplaceWithSimpleInstantiation.$$$reportNull$$$0(0);
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            String replacement;
            if (project == null) {
                ReplaceWithSimpleInstantiation.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithSimpleInstantiation.$$$reportNull$$$0(2);
            }
            JSNewExpression newExpression = (JSNewExpression)descriptor2.getPsiElement();
            PsiFile file2 = newExpression.getContainingFile();
            Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document2 == null) {
                return;
            }
            JSExpression expression = newExpression.getMethodExpression();
            if (expression == null) {
                return;
            }
            String text = expression.getText();
            if ("Array".equals(text)) {
                JSExpression[] arguments = newExpression.getArguments();
                if (arguments.length > 1) {
                    TextRange range = new TextRange(arguments[0].getTextRange().getStartOffset(), arguments[arguments.length - 1].getTextRange().getEndOffset());
                    replacement = "[" + document2.getText(range) + "]";
                } else {
                    if (arguments.length != 0) return;
                    replacement = "[]";
                }
            } else {
                replacement = "{}";
            }
            document2.replaceString(newExpression.getTextRange().getStartOffset(), newExpression.getTextRange().getEndOffset(), (CharSequence)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithSimpleInstantiation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithSimpleInstantiation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReplaceWithPrimitiveCounterpartQuickFix
    implements LocalQuickFix {
        private final String myPrimitiveName;

        ReplaceWithPrimitiveCounterpartQuickFix(String primitiveName) {
            this.myPrimitiveName = primitiveName;
        }

        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.type.cast.to.primitive", (Object[])new Object[]{this.myPrimitiveName});
            if (string == null) {
                ReplaceWithPrimitiveCounterpartQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.type.cast.to.primitive", (Object[])new Object[]{""});
            if (string == null) {
                ReplaceWithPrimitiveCounterpartQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ReplaceWithPrimitiveCounterpartQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceWithPrimitiveCounterpartQuickFix.$$$reportNull$$$0(3);
            }
            JSNewExpression newExpression = (JSNewExpression)descriptor2.getPsiElement();
            PsiFile file2 = newExpression.getContainingFile();
            Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document2 != null) {
                document2.deleteString(newExpression.getTextOffset(), newExpression.getMethodExpression().getTextOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

