/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsOptionDescriptor;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigFileAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JsonProperty) || !(element.getParent() instanceof JsonObject) || JscsConfigFileAnnotator.checkFile(element.getParent().getParent()) == null) {
            return;
        }
        ProblemSink problemSink = (elt, message) -> holder.newAnnotation(HighlightSeverity.WARNING, message).range(elt).needsUpdateOnTyping().create();
        THashSet visited = new THashSet();
        JscsConfigFileAnnotator.checkProperty(problemSink, new JscsOptionsChecker((Set)visited), (JsonProperty)element, (Set<? super JsonProperty>)visited);
    }

    static void annotate(@NotNull JsonFile file2, @NotNull ProblemSink problemSink) {
        JsonFile jsonFile;
        if (file2 == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(2);
        }
        if (problemSink == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(3);
        }
        if ((jsonFile = JscsConfigFileAnnotator.checkFile((PsiElement)file2)) != null) {
            JscsConfigFileAnnotator.annotateMe(jsonFile, problemSink, (Set<? super JsonProperty>)new THashSet());
        }
    }

    private static JsonFile checkFile(PsiElement element) {
        JsonFile file2 = (JsonFile)ObjectUtils.tryCast((Object)element, JsonFile.class);
        if (file2 != null) {
            VirtualFile vFile = file2.getViewProvider().getVirtualFile();
            if (FileTypeRegistry.getInstance().isFileOfType(vFile, (FileType)JscsConfigFileType.INSTANCE)) {
                return file2;
            }
        }
        return null;
    }

    private static void annotateMe(@NotNull JsonFile file2, @NotNull ProblemSink problemSink, @NotNull Set<? super JsonProperty> visited) {
        if (file2 == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(4);
        }
        if (problemSink == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(5);
        }
        if (visited == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(6);
        }
        for (PsiElement element : file2.getChildren()) {
            JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (objectLiteralExpression == null) continue;
            JscsConfigFileAnnotator.iterateOptions(objectLiteralExpression, problemSink, new JscsOptionsChecker(visited), visited);
            break;
        }
    }

    private static <T> void iterateOptions(@NotNull JsonObject jsonObject, @NotNull ProblemSink holder, @NotNull OptionChecker<T> checker, @NotNull Set<? super JsonProperty> visited) {
        if (jsonObject == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(8);
        }
        if (checker == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(9);
        }
        if (visited == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(10);
        }
        List properties = jsonObject.getPropertyList();
        for (JsonProperty property : properties) {
            JscsConfigFileAnnotator.checkProperty(holder, checker, property, visited);
        }
    }

    private static <T> void checkProperty(@NotNull ProblemSink holder, @NotNull OptionChecker<T> checker, @NotNull JsonProperty property, @NotNull Set<? super JsonProperty> visited) {
        if (holder == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(11);
        }
        if (checker == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(12);
        }
        if (property == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(13);
        }
        if (visited == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(14);
        }
        if (!visited.add((JsonProperty)property)) {
            return;
        }
        String name = property.getName();
        T parsedOption = checker.isValidName(name);
        if (parsedOption != null) {
            checker.processOption(property, parsedOption, holder);
        } else {
            JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)property.getNameElement(), "Unknown " + checker.getOptionClassName() + " option name");
        }
    }

    private static String getReplacementValuesMessage(@NotNull JscsOption option) {
        if (option == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(15);
        }
        if (option.getDescriptor().isWithKeywords()) {
            return "keywords (if, else, while, ...)";
        }
        if (option.getDescriptor().isWithBinaryOperators()) {
            return "binary operators (+,>,/, ...)";
        }
        if (option.getDescriptor().isWithOperators()) {
            return "operators (+,>,?, ...)";
        }
        return null;
    }

    private static boolean createExpectedTypesAnnotation(@NotNull List<? extends ValueType> types2, @NotNull ProblemSink holder, @NotNull JsonValue value) {
        if (types2 == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(17);
        }
        if (value == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(18);
        }
        new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types2).build();
        return true;
    }

    private static void createWarningAnnotation(@NotNull ProblemSink holder, @NotNull PsiElement elt, @NotNull String message) {
        if (holder == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(19);
        }
        if (elt == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(20);
        }
        if (message == null) {
            JscsConfigFileAnnotator.$$$reportNull$$$0(21);
        }
        holder.createProblem(elt, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMe";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateOptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProperty";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getReplacementValuesMessage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpectedTypesAnnotation";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createWarningAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AnnotationTextBuilder {
        @NotNull
        private final ProblemSink myHolder;
        @NotNull
        private final PsiElement myElt;
        private String myOptionsReplacement;
        private String[] myOptions;
        private boolean myWithOptions;
        private boolean myWithTypes;
        private List<? extends ValueType> myOtherTypes;

        AnnotationTextBuilder(@NotNull ProblemSink holder, @NotNull PsiElement elt) {
            if (holder == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(0);
            }
            if (elt == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(1);
            }
            this.myHolder = holder;
            this.myElt = elt;
        }

        @NotNull
        AnnotationTextBuilder withOptionsReplacement(String optionsReplacement) {
            this.myOptionsReplacement = optionsReplacement;
            this.myWithOptions = true;
            AnnotationTextBuilder annotationTextBuilder = this;
            if (annotationTextBuilder == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(2);
            }
            return annotationTextBuilder;
        }

        @NotNull
        AnnotationTextBuilder withOptions(String[] options) {
            if (options != null && options.length == 0) {
                AnnotationTextBuilder annotationTextBuilder = this;
                if (annotationTextBuilder == null) {
                    AnnotationTextBuilder.$$$reportNull$$$0(3);
                }
                return annotationTextBuilder;
            }
            this.myOptions = options;
            this.myOptionsReplacement = null;
            this.myWithOptions = true;
            AnnotationTextBuilder annotationTextBuilder = this;
            if (annotationTextBuilder == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(4);
            }
            return annotationTextBuilder;
        }

        @NotNull
        AnnotationTextBuilder withTypes(@NotNull List<? extends ValueType> otherTypes) {
            if (otherTypes == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(5);
            }
            this.myWithTypes = true;
            this.myOtherTypes = otherTypes;
            AnnotationTextBuilder annotationTextBuilder = this;
            if (annotationTextBuilder == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(6);
            }
            return annotationTextBuilder;
        }

        public void build() {
            String text = this.getText();
            if (text == null) {
                return;
            }
            JscsConfigFileAnnotator.createWarningAnnotation(this.myHolder, this.myElt, text);
        }

        @Nullable
        public String getText() {
            if (!this.myWithOptions && !this.myWithTypes) {
                return null;
            }
            StringBuilder sb = new StringBuilder("Expected");
            int cnt = 0;
            if (this.myWithOptions) {
                if (this.myOptions == null || this.myOptions.length > 1) {
                    sb.append(" values: ");
                } else {
                    sb.append(" value: ");
                }
                cnt = this.appendOptionsValues(sb, cnt);
            }
            if (this.myWithTypes) {
                if (!this.myWithOptions) {
                    sb.append(": ");
                }
                AnnotationTextBuilder.appendTypes(this.myOtherTypes, sb, cnt);
            }
            return sb.toString();
        }

        private static void appendTypes(@NotNull List<? extends ValueType> otherTypes, @NotNull StringBuilder sb, int cnt) {
            if (otherTypes == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(7);
            }
            if (sb == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(8);
            }
            for (ValueType valueType : otherTypes) {
                if (cnt > 0) {
                    sb.append(" or ");
                }
                sb.append(valueType.getNameOrFixedValue());
                ++cnt;
            }
        }

        private int appendOptionsValues(@NotNull StringBuilder sb, int cnt) {
            if (sb == null) {
                AnnotationTextBuilder.$$$reportNull$$$0(9);
            }
            if (this.myOptionsReplacement != null) {
                sb.append(this.myOptionsReplacement);
                ++cnt;
            } else if (this.myOptions != null) {
                for (String s : this.myOptions) {
                    if (cnt > 0) {
                        sb.append(", ");
                    }
                    if ("\t".equals(s)) {
                        sb.append("\"\\t\"");
                    } else if (s.length() == 1) {
                        sb.append(s);
                    } else {
                        sb.append("\"").append(s).append("\"");
                    }
                    ++cnt;
                }
            }
            return cnt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elt";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherTypes";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withOptionsReplacement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withOptions";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withTypes";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTypes";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOptionsValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JscsOptionsChecker
    implements OptionChecker<JscsOption> {
        private final Set<? super JsonProperty> visited;
        private static final Map<Class<? extends JsonValue>, ValueType> typesCombinations = new HashMap<Class<? extends JsonValue>, ValueType>();

        private JscsOptionsChecker(@NotNull Set<? super JsonProperty> visited) {
            if (visited == null) {
                JscsOptionsChecker.$$$reportNull$$$0(0);
            }
            this.visited = visited;
        }

        @Override
        public JscsOption isValidName(@NotNull String name) {
            if (name == null) {
                JscsOptionsChecker.$$$reportNull$$$0(1);
            }
            return JscsOption.safeValueOf(name);
        }

        @Override
        @NotNull
        public String getOptionClassName() {
            return "JSCS";
        }

        @Override
        public void processOption(@NotNull JsonProperty property, @NotNull JscsOption option, @NotNull ProblemSink holder) {
            JsonValue value;
            if (property == null) {
                JscsOptionsChecker.$$$reportNull$$$0(2);
            }
            if (option == null) {
                JscsOptionsChecker.$$$reportNull$$$0(3);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(4);
            }
            if ((value = property.getValue()) == null || ObjectUtils.tryCast((Object)value, JsonNullLiteral.class) != null) {
                return;
            }
            if (!(option.canBe(ValueType.bool) && JscsOptionsChecker.isBooleanLiteral(option.otherTypes(null), holder, value) || option.canBe(ValueType.true_or_false) && JscsOptionsChecker.isTrueOrFalse(value))) {
                Map<ValueType, JscsOptionDescriptor.ValueDescription> types2 = option.getDescriptor().getTypes();
                if (JscsOptionsChecker.customValidation(types2, option.otherTypes(null), value, holder)) {
                    return;
                }
                if (!(option.canBe(ValueType.obj) && JscsOptionsChecker.isObjectLiteral(types2, holder, value, option.name(), this.visited) || option.canBe(ValueType.str) && JscsOptionsChecker.isStringLiteral(types2, option.getTypesList(), holder, value) || option.canBe(ValueType.array) && JscsOptionsChecker.isArray(types2, holder, value, JscsConfigFileAnnotator.getReplacementValuesMessage(option)) || option.canBe(ValueType.num_int) && JscsOptionsChecker.isIntLiteral(option.otherTypes(null), holder, value))) {
                    JscsConfigFileAnnotator.createExpectedTypesAnnotation(option.otherTypes(null), holder, value);
                }
            }
        }

        private static boolean customValidation(@NotNull Map<ValueType, JscsOptionDescriptor.ValueDescription> types2, @NotNull List<? extends ValueType> typesList, @NotNull JsonValue value, @NotNull ProblemSink holder) {
            if (types2 == null) {
                JscsOptionsChecker.$$$reportNull$$$0(5);
            }
            if (typesList == null) {
                JscsOptionsChecker.$$$reportNull$$$0(6);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(7);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(8);
            }
            ValueType foundType = null;
            for (Map.Entry<Class<? extends JsonValue>, ValueType> entry : typesCombinations.entrySet()) {
                Class<? extends JsonValue> aClass = entry.getKey();
                if (!aClass.isAssignableFrom(value.getClass())) continue;
                if (!types2.containsKey((Object)entry.getValue())) {
                    return JscsConfigFileAnnotator.createExpectedTypesAnnotation(typesList, holder, value);
                }
                foundType = entry.getValue();
            }
            if (foundType == null) {
                return JscsConfigFileAnnotator.createExpectedTypesAnnotation(typesList, holder, value);
            }
            JscsOptionDescriptor.ValueDescription description = types2.get((Object)foundType);
            if (description instanceof JscsOptionDescriptor.CustomValidation) {
                String checkResult = ((JscsOptionDescriptor.CustomValidation)description).check(value);
                if (checkResult != null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, checkResult);
                }
                return true;
            }
            return false;
        }

        private static boolean isObjectLiteral(@NotNull Map<ValueType, JscsOptionDescriptor.ValueDescription> map, @NotNull ProblemSink holder, @NotNull JsonValue value, final @NotNull String parentName, final @NotNull Set<? super JsonProperty> visited) {
            JsonObject jsonObj;
            if (map == null) {
                JscsOptionsChecker.$$$reportNull$$$0(9);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(10);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(11);
            }
            if (parentName == null) {
                JscsOptionsChecker.$$$reportNull$$$0(12);
            }
            if (visited == null) {
                JscsOptionsChecker.$$$reportNull$$$0(13);
            }
            if ((jsonObj = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class)) == null) {
                return false;
            }
            JscsOptionDescriptor.ValueDescription valDescriptor = map.get((Object)ValueType.obj);
            if (valDescriptor.equals(JscsOptionDescriptor.ValueDescription.NO_VALIDATION)) {
                return true;
            }
            final JscsOptionDescriptor.ValuesObject descriptor2 = (JscsOptionDescriptor.ValuesObject)valDescriptor;
            String mandatory = descriptor2.getMandatory();
            if (mandatory != null && jsonObj.findProperty(mandatory) == null) {
                JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, "Required property '" + mandatory + "' should be defined");
            }
            if (descriptor2.isMustNotBeEmpty() && jsonObj.getPropertyList().isEmpty()) {
                JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, "At least one of the properties should be defined");
            }
            JscsConfigFileAnnotator.iterateOptions(jsonObj, holder, new OptionChecker<Object>(){

                @Override
                public Object isValidName(@NotNull String name) {
                    if (name == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return descriptor2.getFields().containsKey(name.trim()) ? Boolean.valueOf(true) : null;
                }

                @Override
                public void processOption(@NotNull JsonProperty property, @NotNull Object parsedOption, @NotNull ProblemSink holder) {
                    if (property == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (parsedOption == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (holder == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    String trim = property.getName().trim();
                    JscsOptionDescriptor field = descriptor2.getFields().get(trim);
                    if (field == null) {
                        return;
                    }
                    JsonValue value = property.getValue();
                    if (value == null) {
                        return;
                    }
                    ArrayList<ValueType> types2 = new ArrayList<ValueType>(field.getTypes().keySet());
                    if (field.canBe(ValueType.bool) && JscsOptionsChecker.isBooleanLiteral(types2, holder, value)) {
                        return;
                    }
                    if (field.canBe(ValueType.true_or_false) && JscsOptionsChecker.isTrueOrFalse(value)) {
                        return;
                    }
                    if (JscsOptionsChecker.customValidation(field.getTypes(), types2, value, holder)) {
                        return;
                    }
                    if (field.canBe(ValueType.num_int) && JscsOptionsChecker.isIntLiteral(types2, holder, value)) {
                        return;
                    }
                    if (field.canBe(ValueType.str) && JscsOptionsChecker.isStringLiteral(field.getTypes(), types2, holder, value)) {
                        return;
                    }
                    if (field.canBe(ValueType.array) && JscsOptionsChecker.isArray(field.getTypes(), holder, value, null)) {
                        return;
                    }
                    if (field.canBe(ValueType.obj) && JscsOptionsChecker.isObjectLiteral(field.getTypes(), holder, value, trim, visited)) {
                        return;
                    }
                    JscsConfigFileAnnotator.createExpectedTypesAnnotation(types2, holder, value);
                }

                @Override
                @NotNull
                public String getOptionClassName() {
                    String string = parentName;
                    if (string == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "property";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "parsedOption";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "holder";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$JscsOptionsChecker$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$JscsOptionsChecker$1";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOptionClassName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "isValidName";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "processOption";
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, visited);
            return true;
        }

        private static boolean isIntLiteral(@NotNull List<? extends ValueType> types2, @NotNull ProblemSink holder, @NotNull JsonValue value) {
            JsonNumberLiteral literal;
            if (types2 == null) {
                JscsOptionsChecker.$$$reportNull$$$0(14);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(15);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(16);
            }
            if ((literal = (JsonNumberLiteral)ObjectUtils.tryCast((Object)value, JsonNumberLiteral.class)) == null) {
                return false;
            }
            try {
                Integer.parseInt(StringUtil.unquoteString((String)literal.getText()));
            }
            catch (NumberFormatException e) {
                new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types2).build();
            }
            return true;
        }

        private static boolean isTrueOrFalse(@NotNull JsonValue value) {
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(17);
            }
            return value instanceof JsonBooleanLiteral;
        }

        private static boolean isBooleanLiteral(@NotNull List<? extends ValueType> types2, @NotNull ProblemSink holder, @NotNull JsonValue value) {
            JsonBooleanLiteral boolLiteral;
            if (types2 == null) {
                JscsOptionsChecker.$$$reportNull$$$0(18);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(19);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(20);
            }
            if ((boolLiteral = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)value, JsonBooleanLiteral.class)) == null) {
                return false;
            }
            if (!Boolean.TRUE.toString().equals(boolLiteral.getText())) {
                new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types2).build();
            }
            return true;
        }

        private static boolean isArray(@NotNull Map<ValueType, JscsOptionDescriptor.ValueDescription> map, @NotNull ProblemSink holder, @NotNull JsonValue value, @Nullable String replacementMessage) {
            JsonArray array;
            if (map == null) {
                JscsOptionsChecker.$$$reportNull$$$0(21);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(22);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(23);
            }
            if ((array = (JsonArray)ObjectUtils.tryCast((Object)value, JsonArray.class)) == null) {
                return false;
            }
            JscsOptionsChecker.checkForList(map, array, holder, replacementMessage);
            return true;
        }

        private static void checkForList(@NotNull Map<ValueType, JscsOptionDescriptor.ValueDescription> map, @NotNull JsonArray array, @NotNull ProblemSink holder, @Nullable String expectedMessage) {
            JscsOptionDescriptor.ValueDescription descriptor2;
            if (map == null) {
                JscsOptionsChecker.$$$reportNull$$$0(24);
            }
            if (array == null) {
                JscsOptionsChecker.$$$reportNull$$$0(25);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(26);
            }
            if (JscsOptionDescriptor.ValueDescription.NO_VALIDATION.equals(descriptor2 = map.get((Object)ValueType.array))) {
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<? super PsiElement, ? super JsonStringLiteral>)((PairConsumer)(element, literal) -> {}));
                return;
            }
            if (descriptor2 instanceof JscsOptionDescriptor.StringVerifier) {
                JscsOptionDescriptor.StringVerifier verifier = (JscsOptionDescriptor.StringVerifier)descriptor2;
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<? super PsiElement, ? super JsonStringLiteral>)((PairConsumer)(element, literal) -> {
                    String error = verifier.validate(literal.getValue());
                    if (error != null) {
                        JscsConfigFileAnnotator.createWarningAnnotation(holder, element, error);
                    }
                }));
                return;
            }
            if (descriptor2 instanceof JscsOptionDescriptor.ValuesCollection) {
                JscsOptionDescriptor.ValuesCollection valuesCollection = (JscsOptionDescriptor.ValuesCollection)descriptor2;
                String[] values = valuesCollection.getArrValues();
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<? super PsiElement, ? super JsonStringLiteral>)((PairConsumer)(element, stringLiteral) -> {
                    if (valuesCollection.isOtherValuesAllowed() || values.length == 0) {
                        return;
                    }
                    if (!valuesCollection.contains(StringUtil.unquoteString((String)stringLiteral.getText()))) {
                        new AnnotationTextBuilder(holder, (PsiElement)element).withOptions(values).withOptionsReplacement(expectedMessage).build();
                    }
                }));
            }
        }

        private static void validateArray(@NotNull JsonArray array, @NotNull ProblemSink holder, @NotNull PairConsumer<? super PsiElement, ? super JsonStringLiteral> consumer) {
            if (array == null) {
                JscsOptionsChecker.$$$reportNull$$$0(27);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(28);
            }
            if (consumer == null) {
                JscsOptionsChecker.$$$reportNull$$$0(29);
            }
            for (PsiElement element : array.getChildren()) {
                JsonStringLiteral stringLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)element, JsonStringLiteral.class);
                if (stringLiteral == null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, element, "string expected");
                    continue;
                }
                consumer.consume((Object)element, (Object)stringLiteral);
            }
        }

        private static boolean isStringLiteral(@NotNull Map<ValueType, JscsOptionDescriptor.ValueDescription> map, @NotNull List<? extends ValueType> types2, @NotNull ProblemSink holder, @NotNull JsonValue value) {
            JsonStringLiteral stringLiteral;
            if (map == null) {
                JscsOptionsChecker.$$$reportNull$$$0(30);
            }
            if (types2 == null) {
                JscsOptionsChecker.$$$reportNull$$$0(31);
            }
            if (holder == null) {
                JscsOptionsChecker.$$$reportNull$$$0(32);
            }
            if (value == null) {
                JscsOptionsChecker.$$$reportNull$$$0(33);
            }
            if ((stringLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)value, JsonStringLiteral.class)) == null) {
                return false;
            }
            JscsOptionDescriptor.ValueDescription descriptor2 = map.get((Object)ValueType.str);
            if (JscsOptionDescriptor.ValueDescription.NO_VALIDATION.equals(descriptor2)) {
                return true;
            }
            String strValue = StringUtil.unquoteString((String)stringLiteral.getValue());
            if (descriptor2 instanceof JscsOptionDescriptor.StringVerifier) {
                String error = ((JscsOptionDescriptor.StringVerifier)descriptor2).validate(strValue);
                if (error != null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, error);
                }
                return true;
            }
            if (descriptor2 instanceof JscsOptionDescriptor.ValuesCollection) {
                JscsOptionDescriptor.ValuesCollection valuesCollection = (JscsOptionDescriptor.ValuesCollection)descriptor2;
                String[] values = valuesCollection.getArrValues();
                if (valuesCollection.isOtherValuesAllowed() || values.length == 0) {
                    return true;
                }
                if (!valuesCollection.contains(strValue)) {
                    ArrayList<? extends ValueType> list2 = new ArrayList<ValueType>(types2);
                    list2.remove((Object)ValueType.str);
                    new AnnotationTextBuilder(holder, (PsiElement)value).withOptions(values).withTypes(list2).build();
                }
                return true;
            }
            return false;
        }

        static {
            typesCombinations.put(JsonStringLiteral.class, ValueType.str);
            typesCombinations.put(JsonNumberLiteral.class, ValueType.num_int);
            typesCombinations.put(JsonArray.class, ValueType.array);
            typesCombinations.put(JsonObject.class, ValueType.obj);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 4: 
                case 8: 
                case 10: 
                case 15: 
                case 19: 
                case 22: 
                case 26: 
                case 28: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 5: 
                case 14: 
                case 18: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typesList";
                    break;
                }
                case 7: 
                case 11: 
                case 16: 
                case 17: 
                case 20: 
                case 23: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 9: 
                case 21: 
                case 24: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentName";
                    break;
                }
                case 25: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$JscsOptionsChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processOption";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customValidation";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isObjectLiteral";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIntLiteral";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTrueOrFalse";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBooleanLiteral";
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isArray";
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForList";
                    break;
                }
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateArray";
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStringLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface OptionChecker<T> {
        public T isValidName(@NotNull String var1);

        public void processOption(@NotNull JsonProperty var1, @NotNull T var2, @NotNull ProblemSink var3);

        @NotNull
        public String getOptionClassName();
    }

    static interface ProblemSink {
        public void createProblem(@NotNull PsiElement var1, @NotNull String var2);
    }
}

