/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.jscs.config.Constants;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JscsOptionDescriptor {
    private final Map<ValueType, ValueDescription> myTypes = new HashMap<ValueType, ValueDescription>();
    private boolean myWithKeywords;
    private boolean myWithOperators;
    private boolean myWithBinaryOperators;
    private String myDescription;

    public JscsOptionDescriptor addType(@NotNull ValueType type, @NotNull ValueDescription description) {
        if (type == null) {
            JscsOptionDescriptor.$$$reportNull$$$0(0);
        }
        if (description == null) {
            JscsOptionDescriptor.$$$reportNull$$$0(1);
        }
        this.myTypes.put(type, description);
        return this;
    }

    public boolean canBe(@NotNull ValueType type) {
        if (type == null) {
            JscsOptionDescriptor.$$$reportNull$$$0(2);
        }
        return this.myTypes.containsKey((Object)type);
    }

    public Map<ValueType, ValueDescription> getTypes() {
        return this.myTypes;
    }

    public JscsOptionDescriptor canBool() {
        return this.addType(ValueType.bool, ValueDescription.NO_VALIDATION);
    }

    public JscsOptionDescriptor canTrueOrFalse() {
        return this.addType(ValueType.true_or_false, ValueDescription.NO_VALIDATION);
    }

    public JscsOptionDescriptor canInteger() {
        return this.addType(ValueType.num_int, ValueDescription.NO_VALIDATION);
    }

    public JscsOptionDescriptor canStringArray(String ... values) {
        return this.addType(ValueType.array, new ValuesCollection(values));
    }

    public JscsOptionDescriptor canExpandableStringArray(String ... values) {
        ValuesCollection collection = new ValuesCollection(values).otherValuesAllowed();
        return this.addType(ValueType.array, collection);
    }

    public JscsOptionDescriptor canKeywordsArray() {
        this.myWithKeywords = true;
        return this.addType(ValueType.array, new ValuesCollection(Constants.keywords));
    }

    public JscsOptionDescriptor canOperatorsArray() {
        this.myWithOperators = true;
        return this.addType(ValueType.array, new ValuesCollection(Constants.operators));
    }

    public JscsOptionDescriptor canBinaryOperatorsArray() {
        this.myWithBinaryOperators = true;
        return this.addType(ValueType.array, new ValuesCollection(Constants.binaryOperators));
    }

    public JscsOptionDescriptor canString(String ... str) {
        return this.addType(ValueType.str, new ValuesCollection(str));
    }

    public JscsOptionDescriptor withDescription(String description) {
        this.myDescription = description;
        return this;
    }

    public boolean isWithKeywords() {
        return this.myWithKeywords;
    }

    public boolean isWithOperators() {
        return this.myWithOperators;
    }

    public boolean isWithBinaryOperators() {
        return this.myWithBinaryOperators;
    }

    public String getDescription() {
        return this.myDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsOptionDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StringVerifier
    implements ValueDescription {
        private final Function<? super String, String> myValidator;

        public StringVerifier(Function<? super String, String> validator) {
            this.myValidator = validator;
        }

        String validate(String value) {
            return (String)this.myValidator.fun((Object)value);
        }
    }

    public static class ValuesObject
    implements ValueDescription {
        private final Map<String, JscsOptionDescriptor> myFields = new HashMap<String, JscsOptionDescriptor>(4);
        private String myMandatory;
        private boolean myMustNotBeEmpty;

        public ValuesObject(Consumer<? super ValuesObject> init) {
            init.consume((Object)this);
        }

        public ValuesObject addBoolFields(String ... names) {
            for (String name : names) {
                this.addField(name).addType(ValueType.bool, NO_VALIDATION);
            }
            return this;
        }

        public JscsOptionDescriptor addField(String name) {
            JscsOptionDescriptor field = new JscsOptionDescriptor();
            this.myFields.put(name, field);
            return field;
        }

        public Map<String, JscsOptionDescriptor> getFields() {
            return this.myFields;
        }

        public ValuesObject mandatory(@NotNull String name) {
            if (name == null) {
                ValuesObject.$$$reportNull$$$0(0);
            }
            this.myMandatory = name;
            return this;
        }

        public String getMandatory() {
            return this.myMandatory;
        }

        public void mustNotBeEmpty() {
            this.myMustNotBeEmpty = true;
        }

        public boolean isMustNotBeEmpty() {
            return this.myMustNotBeEmpty;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/config/JscsOptionDescriptor$ValuesObject", "mandatory"));
        }
    }

    public static class ValuesCollection
    implements ValueDescription {
        private final Set<String> myValues;
        private final String[] myArrValues;
        private boolean myIsOtherValuesAllowed;
        private boolean myNoTrimValue;

        public ValuesCollection(String ... values) {
            this.myArrValues = values;
            this.myValues = ContainerUtil.set((Object[])values);
        }

        public ValuesCollection doNotTrimValues() {
            this.myNoTrimValue = true;
            return this;
        }

        public String[] getArrValues() {
            return this.myArrValues;
        }

        public ValuesCollection otherValuesAllowed() {
            this.myIsOtherValuesAllowed = true;
            return this;
        }

        public boolean contains(@NotNull String value) {
            if (value == null) {
                ValuesCollection.$$$reportNull$$$0(0);
            }
            return this.myIsOtherValuesAllowed || (this.myNoTrimValue ? this.myValues.contains(value) : this.myValues.contains(value.trim()));
        }

        public boolean isOtherValuesAllowed() {
            return this.myIsOtherValuesAllowed;
        }

        public boolean isNoTrimValue() {
            return this.myNoTrimValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jscs/config/JscsOptionDescriptor$ValuesCollection", "contains"));
        }
    }

    public static class CustomValidation
    implements ValueDescription {
        private final Function<? super JsonValue, String> myValidator;

        public CustomValidation(Function<? super JsonValue, String> validator) {
            this.myValidator = validator;
        }

        String check(JsonValue value) {
            return (String)this.myValidator.fun((Object)value);
        }
    }

    public static interface ValueDescription {
        public static final ValueDescription NO_VALIDATION = new ValueDescription(){};
    }
}

