/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JSHintDocumentation {
    private static final Logger LOG = Logger.getInstance(JSHintDocumentation.class);
    private final List<JSHintOptionGroup> myGroups;
    private final Map<JSHintOption, String> myNonGroupOptions;
    private final ImmutableMap<JSHintOption, String> myDescriptionByOption;

    private JSHintDocumentation(@NotNull List<JSHintOptionGroup> groups) {
        if (groups == null) {
            JSHintDocumentation.$$$reportNull$$$0(0);
        }
        this.myGroups = groups;
        this.myNonGroupOptions = new HashMap<JSHintOption, String>();
        this.myNonGroupOptions.put(JSHintOption.PREDEF, "Specifies global variables and their assignable status:<pre>DISQUS:true, jQuery:false</pre><p/>Here JSHint will allow you to override DISQUS, but complain if you try to override jQuery.");
        HashMap builder = Maps.newHashMap();
        for (JSHintOptionGroup group : groups) {
            for (JSHintOption option : group.getOptions()) {
                builder.put(option, group.getHtmlDescriptionByOption(option));
            }
        }
        builder.putAll(this.myNonGroupOptions);
        this.myDescriptionByOption = ImmutableMap.copyOf((Map)builder);
    }

    @NotNull
    public List<JSHintOptionGroup> getGroups() {
        List<JSHintOptionGroup> list2 = this.myGroups;
        if (list2 == null) {
            JSHintDocumentation.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public String getHtmlDescriptionForNonGroupOption(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintDocumentation.$$$reportNull$$$0(2);
        }
        return this.myNonGroupOptions.get(option);
    }

    @Nullable
    public String getHtmlDescriptionByOption(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintDocumentation.$$$reportNull$$$0(3);
        }
        return (String)this.myDescriptionByOption.get((Object)option);
    }

    @NotNull
    public static JSHintDocumentation getInstance() {
        JSHintDocumentation jSHintDocumentation = Holder.INSTANCE;
        if (jSHintDocumentation == null) {
            JSHintDocumentation.$$$reportNull$$$0(4);
        }
        return jSHintDocumentation;
    }

    @NotNull
    private static JSHintDocumentation parseFromXml() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String content = JSHintDocumentation.loadXmlContent();
            InputSource source = new InputSource(new StringReader(content));
            Document document2 = db.parse(source);
            return JSHintDocumentation.fromDocument(document2);
        }
        catch (Exception e) {
            LOG.error("Can't parse jshint documentation :(", (Throwable)e);
            return new JSHintDocumentation(Collections.emptyList());
        }
    }

    @NotNull
    private static JSHintDocumentation fromDocument(@NotNull Document document2) {
        if (document2 == null) {
            JSHintDocumentation.$$$reportNull$$$0(5);
        }
        ArrayList<JSHintOptionGroup> groups = new ArrayList<JSHintOptionGroup>();
        Element groupsElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(document2, "groups");
        List<Element> groupChildren = JSHintDocumentation.getChildElementsByTagName(groupsElement, "group");
        for (Element groupElement : groupChildren) {
            groups.add(JSHintDocumentation.createGroup(groupElement));
        }
        return new JSHintDocumentation(groups);
    }

    @NotNull
    private static Element getTheOnlyChildElementWithTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        List<Element> children;
        if (parentNode == null) {
            JSHintDocumentation.$$$reportNull$$$0(6);
        }
        if (childTagName == null) {
            JSHintDocumentation.$$$reportNull$$$0(7);
        }
        if ((children = JSHintDocumentation.getChildElementsByTagName(parentNode, childTagName)).size() != 1) {
            throw new RuntimeException("The only child is expected, but found: " + children.size());
        }
        Element element = children.get(0);
        if (element == null) {
            JSHintDocumentation.$$$reportNull$$$0(8);
        }
        return element;
    }

    @NotNull
    private static List<Element> getChildElementsByTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            JSHintDocumentation.$$$reportNull$$$0(9);
        }
        if (childTagName == null) {
            JSHintDocumentation.$$$reportNull$$$0(10);
        }
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement = (Element)ObjectUtils.tryCast((Object)nodeList.item(i), Element.class);
            if (childElement == null || !childTagName.equals(childElement.getTagName())) continue;
            children.add(childElement);
        }
        ArrayList<Element> arrayList = children;
        if (arrayList == null) {
            JSHintDocumentation.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static JSHintOptionGroup createGroup(@NotNull Element groupElement) {
        if (groupElement == null) {
            JSHintDocumentation.$$$reportNull$$$0(12);
        }
        String title = JSHintDocumentation.getMandatoryAttribute(groupElement, "title");
        Element descriptionElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(groupElement, "description");
        String description = descriptionElement.getTextContent();
        Element optionsElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(groupElement, "options");
        List<Element> optionElements = JSHintDocumentation.getChildElementsByTagName(optionsElement, "option");
        JSHintOptionGroup group = new JSHintOptionGroup(title, description);
        for (Element optionElement : optionElements) {
            String optionKey = JSHintDocumentation.getMandatoryAttribute(optionElement, "key");
            Element optionDescriptionElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(optionElement, "description");
            String optionDescription = optionDescriptionElement.getTextContent();
            JSHintOption option = JSHintOption.findByName(optionKey);
            if (option == null) {
                throw new RuntimeException("Option not found: " + optionKey);
            }
            group.add(option, optionDescription);
        }
        JSHintOptionGroup jSHintOptionGroup = group;
        if (jSHintOptionGroup == null) {
            JSHintDocumentation.$$$reportNull$$$0(13);
        }
        return jSHintOptionGroup;
    }

    private static String getMandatoryAttribute(@NotNull Element element, @NotNull String attrName) {
        String value;
        if (element == null) {
            JSHintDocumentation.$$$reportNull$$$0(14);
        }
        if (attrName == null) {
            JSHintDocumentation.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)(value = element.getAttribute(attrName)))) {
            throw new RuntimeException("No '" + attrName + "' attribute!");
        }
        return value;
    }

    @NotNull
    private static String loadXmlContent() throws IOException {
        InputStream in = JSHintDocumentation.class.getResourceAsStream("jshint-documentation.xml");
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            JSHintDocumentation.$$$reportNull$$$0(16);
        }
        return string;
    }

    public String toString() {
        return this.myGroups.toString();
    }

    static /* synthetic */ JSHintDocumentation access$100() {
        return JSHintDocumentation.parseFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTagName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyChildElementWithTagName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElementsByTagName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadXmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlDescriptionForNonGroupOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlDescriptionByOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromDocument";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyChildElementWithTagName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildElementsByTagName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMandatoryAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final JSHintDocumentation INSTANCE = JSHintDocumentation.access$100();

        private Holder() {
        }
    }
}

