/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null || DialectDetector.isActionScript(sourceElement)) {
            return null;
        }
        PsiElement[] amdModules = JSGotoDeclarationHandler.findAmdModulesFromParameter(sourceElement);
        if (amdModules != null) {
            return amdModules;
        }
        PsiElement[] elements = JSGotoDeclarationHandler.getGotoDeclarationTargetsImpl(sourceElement);
        if (elements == null) {
            elements = JSGotoDeclarationHandler.resolveQualifiedNameFromJSLiteral(sourceElement, offset);
        }
        if (elements != null && elements.length > 0) {
            return (PsiElement[])Arrays.stream(elements).map(el -> JSTargetElementEvaluator.adjustTargetElement(el, sourceElement)).toArray(PsiElement[]::new);
        }
        return elements;
    }

    @Nullable
    public static PsiElement[] getGotoDeclarationTargetsImpl(@NotNull PsiElement sourceElement) {
        PsiElement resolved;
        List<JSFunctionWithSubstitutor> result2;
        ASTNode node;
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        if ((node = sourceElement.getNode()) == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements = importedBinding.findReferencedElements();
            if (elements.size() > 0) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        if ((result2 = TypeScriptSignatureChooser.resolveConstructorOrCallSignature(parent)).size() > 0) {
            return JSGotoDeclarationHandler.getConstructorElements(parent, result2);
        }
        JSReferenceExpression referenceExpression = parent instanceof JSReferenceExpression ? (JSReferenceExpression)parent : null;
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property && ((ES6Property)grandParent).isShorthanded() && (resolved = referenceExpression.resolve()) != null) {
            return new PsiElement[]{resolved};
        }
        if (parent instanceof JSFieldVariable && JSGotoDeclarationHandler.useVariableAsDeclaration((JSFieldVariable)parent, sourceElement) || parent instanceof TypeScriptFunction && JSGotoDeclarationHandler.useFunctionAsDeclaration((TypeScriptFunction)parent, sourceElement)) {
            return new PsiElement[]{parent};
        }
        return null;
    }

    @NotNull
    private static PsiElement[] getConstructorElements(@NotNull PsiElement parent, @NotNull Collection<JSFunctionWithSubstitutor> result2) {
        PsiElement resolve;
        PsiElement parentOfParent;
        if (parent == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        if (parent instanceof JSReferenceExpression && (parentOfParent = parent.getParent()) instanceof JSNewExpression && (resolve = ((JSReferenceExpression)parent).resolve()) instanceof JSClass && ((JSClass)resolve).getConstructor() == null) {
            PsiElement[] psiElementArray = new PsiElement[]{resolve};
            if (psiElementArray == null) {
                JSGotoDeclarationHandler.$$$reportNull$$$0(3);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = (PsiElement[])result2.stream().map(el -> el.myFunctionItem).toArray(PsiElement[]::new);
        if (psiElementArray == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    private static boolean useVariableAsDeclaration(@NotNull JSFieldVariable variable, @NotNull PsiElement sourceElement) {
        if (variable == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(6);
        }
        if (!JSGotoDeclarationHandler.isIdentifier(sourceElement, variable.getNameIdentifier())) {
            return false;
        }
        if (variable instanceof JSParameter && variable.getReferences().length != 0) {
            return false;
        }
        PsiElement parent = variable.getParent();
        if (!JSDestructuringUtil.isDestructuring(parent)) {
            return true;
        }
        return !(parent instanceof JSDestructuringShorthandedProperty);
    }

    private static boolean useFunctionAsDeclaration(@NotNull TypeScriptFunction function2, @NotNull PsiElement sourceElement) {
        if (function2 == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(7);
        }
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(8);
        }
        return JSGotoDeclarationHandler.isIdentifier(sourceElement, function2.getNameIdentifier()) && function2.getBlock() != null;
    }

    private static boolean isIdentifier(@NotNull PsiElement sourceElement, @Nullable PsiElement name) {
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(9);
        }
        return sourceElement.isEquivalentTo(name);
    }

    private static PsiElement @Nullable [] resolveQualifiedNameFromJSLiteral(@Nullable PsiElement sourceElement, int offset) {
        if (!(sourceElement instanceof LeafPsiElement) || ((LeafPsiElement)sourceElement).getElementType() != JSTokenTypes.STRING_LITERAL || !sourceElement.textContains('.')) {
            return null;
        }
        PsiElement literal = sourceElement.getParent();
        if (!(literal instanceof JSLiteralExpression)) {
            return null;
        }
        int offsetInLiteral = offset - literal.getTextRange().getStartOffset();
        PsiReference reference = literal.findReferenceAt(offsetInLiteral);
        if (reference instanceof JSLiteralTextReference) {
            ResolveResult[] results;
            List<PsiElement> elements;
            TextRange rangeInLiteral = reference.getRangeInElement();
            String referenceText = rangeInLiteral.substring(literal.getText());
            int offsetInReferenceText = offsetInLiteral - rangeInLiteral.getStartOffset();
            Object qualifiedName = null;
            int componentStart = 0;
            while (componentStart < referenceText.length()) {
                String component;
                int nextDotOffset = referenceText.indexOf(46, componentStart);
                if (nextDotOffset == -1) {
                    nextDotOffset = referenceText.length();
                }
                if (!BasicJavascriptNamesValidator.isIdentifierName(component = referenceText.substring(componentStart, nextDotOffset))) {
                    return null;
                }
                if (componentStart <= offsetInReferenceText) {
                    qualifiedName = JSQualifiedNameImpl.create(component, (JSQualifiedName)qualifiedName);
                }
                componentStart = nextDotOffset + 1;
            }
            if (qualifiedName != null && !qualifiedName.equals(((JSTextReference)reference).getQualifiedName()) && !(elements = JSResolveResult.toElements(results = ((JSTextReference)reference).doResolveQualifiedName((JSQualifiedName)qualifiedName))).isEmpty()) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return null;
    }

    private static PsiElement @Nullable [] findAmdModulesFromParameter(@Nullable PsiElement sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        ASTNode node = sourceElement.getNode();
        if (node == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (!(parent instanceof JSParameter)) {
            return null;
        }
        JSLiteralExpression parameterInitialization = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)parent);
        if (parameterInitialization == null) {
            return null;
        }
        Collection<PsiElement> elements = JSFileReferencesUtil.resolveModuleReferences((PsiElement)parameterInitialization);
        return elements.isEmpty() ? null : elements.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTargetsImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorElements";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "useVariableAsDeclaration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useFunctionAsDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

