/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptParser<E extends ExpressionParser, S extends StatementParser, F extends FunctionParser, T extends JSPsiTypeParser> {
    private final JSLanguageDialect myDialect;
    protected final PsiBuilder builder;
    protected E myExpressionParser;
    protected S myStatementParser;
    protected F myFunctionParser;
    protected T myTypeParser;
    protected JSXmlParser myXmlParser;

    public JavaScriptParser(JSLanguageDialect dialect, PsiBuilder builder) {
        this.builder = builder;
        this.myDialect = dialect;
        this.myExpressionParser = new ExpressionParser<JavaScriptParser>(this);
        this.myStatementParser = new StatementParser<JavaScriptParser>(this);
        this.myFunctionParser = new FunctionParser<JavaScriptParser>(this);
        this.myTypeParser = new JSPsiTypeParser<JavaScriptParser>(this);
        this.myXmlParser = dialect != null && !dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X) ? JSXmlParser.DUMMY : new JSXmlTokensParser(this.builder);
    }

    public void parseJS(IElementType root) {
        PsiBuilder.Marker rootMarker = this.builder.mark();
        this.builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)this.myDialect);
        JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
        if (forceContext != null) {
            if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else {
                if (forceContext == JavaScriptParserBase.ForceContext.TypeAllowEmpty && this.builder.eof()) {
                    rootMarker.done(root);
                    return;
                }
                ((JSPsiTypeParser)this.myTypeParser).parseType();
            }
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseStatement();
            }
        } else {
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseSourceElement();
            }
        }
        rootMarker.done(root);
    }

    public E getExpressionParser() {
        return this.myExpressionParser;
    }

    public S getStatementParser() {
        return this.myStatementParser;
    }

    public F getFunctionParser() {
        return this.myFunctionParser;
    }

    public T getTypeParser() {
        return this.myTypeParser;
    }

    public JSXmlParser getXmlParser() {
        return this.myXmlParser;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        return JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public boolean isIdentifierName(IElementType firstToken) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken);
    }

    @Nullable
    public JSLanguageDialect getDialect() {
        return this.myDialect;
    }

    public void buildTokenElement(@NotNull IElementType type) {
        if (type == null) {
            JavaScriptParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        marker.done(type);
    }

    public boolean parseModifiers(@NotNull JSModifiersStructure structure, boolean dropIfEmpty, @NotNull Predicate<PsiBuilder> isPossibleStateAfterModifiers) {
        boolean lexerAdvanced;
        if (structure == null) {
            JavaScriptParser.$$$reportNull$$$0(1);
        }
        if (isPossibleStateAfterModifiers == null) {
            JavaScriptParser.$$$reportNull$$$0(2);
        }
        int offsetBefore = this.builder.getCurrentOffset();
        PsiBuilder.Marker attrList = this.builder.mark();
        ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
        this.builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.FALSE);
        ((FunctionParser)this.myFunctionParser).setIsGenerator(false);
        boolean parsedSomething = structure.parseOptimistically(this.builder);
        if (parsedSomething && !isPossibleStateAfterModifiers.test(this.builder)) {
            attrList.rollbackTo();
            structure.resetContexts(this.builder);
            this.builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.FALSE);
            ((FunctionParser)this.myFunctionParser).setIsGenerator(false);
            attrList = this.builder.mark();
            ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
            structure.parse(this.builder, isPossibleStateAfterModifiers);
        }
        boolean bl = lexerAdvanced = this.builder.getCurrentOffset() > offsetBefore;
        if (dropIfEmpty && !lexerAdvanced) {
            attrList.drop();
        } else {
            attrList.done(((FunctionParser)this.myFunctionParser).getAttributeListElementType());
        }
        return lexerAdvanced;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPossibleStateAfterModifiers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/parsing/JavaScriptParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTokenElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseModifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

