/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSEvaluationResultContext {
    public static final JSEvaluationResultContext EMPTY = new JSEvaluationResultContextImpl(Collections.emptyList(), true, null, null);

    @Nullable
    public JSApplyContextElement peekJSElementToApply();

    public boolean isJSElementsToApplyEmpty();

    public boolean isStrict();

    public Collection<JSApplyContextElement> getJSElementsToApply();

    public boolean isEquivalentTo(JSEvaluationResultContext var1);

    @Nullable
    public PsiElement getSource();

    @Nullable
    public JSReferenceExpression getProcessedExpression();

    public static class JSEvaluationResultContextImpl
    implements JSEvaluationResultContext {
        private final List<JSApplyContextElement> myJSElementsToApply;
        private final boolean myStrict;
        private final PsiElement mySource;
        private final JSReferenceExpression myProcessedExpression;

        private JSEvaluationResultContextImpl(Collection<JSApplyContextElement> jsElementsToApply, boolean strict, @Nullable PsiElement source, @Nullable JSReferenceExpression processedExpression) {
            this.myJSElementsToApply = ContainerUtil.immutableList((Object[])jsElementsToApply.toArray(new JSApplyContextElement[0]));
            this.myStrict = strict;
            this.mySource = source;
            this.myProcessedExpression = processedExpression;
        }

        @NotNull
        public static JSEvaluationResultContext copyFrom(@Nullable JSEvaluationResultContext other) {
            if (other == null || other.isEquivalentTo(EMPTY)) {
                JSEvaluationResultContext jSEvaluationResultContext = EMPTY;
                if (jSEvaluationResultContext == null) {
                    JSEvaluationResultContextImpl.$$$reportNull$$$0(0);
                }
                return jSEvaluationResultContext;
            }
            return new JSEvaluationResultContextImpl(other.getJSElementsToApply(), other.isStrict(), other.getSource(), other.getProcessedExpression());
        }

        @Override
        @Nullable
        public JSApplyContextElement peekJSElementToApply() {
            return this.myJSElementsToApply.isEmpty() ? null : this.myJSElementsToApply.get(this.myJSElementsToApply.size() - 1);
        }

        @Override
        public boolean isJSElementsToApplyEmpty() {
            return this.myJSElementsToApply.isEmpty();
        }

        @Override
        public boolean isStrict() {
            return this.myStrict;
        }

        @Override
        public Collection<JSApplyContextElement> getJSElementsToApply() {
            return this.myJSElementsToApply;
        }

        @Override
        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }

        @Override
        @Nullable
        public JSReferenceExpression getProcessedExpression() {
            return this.myProcessedExpression;
        }

        @Override
        public boolean isEquivalentTo(@NotNull JSEvaluationResultContext other) {
            if (other == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(1);
            }
            return JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
        }

        public static boolean areEvaluationContextsEquivalent(@NotNull JSEvaluationResultContext obj1, @NotNull JSEvaluationResultContext obj2) {
            if (obj1 == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(2);
            }
            if (obj2 == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(3);
            }
            return obj1.isStrict() == obj2.isStrict() && obj1.getJSElementsToApply().equals(obj2.getJSElementsToApply()) && Objects.equals(obj1.getProcessedExpression(), obj2.getProcessedExpression()) && Objects.equals(obj1.getSource(), obj2.getSource());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyFrom";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentTo";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areEvaluationContextsEquivalent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

