/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericParameterImpl
extends JSTypeBaseImpl
implements JSTypeWithIncompleteSubstitution,
JSGenericParameterType {
    @NotNull
    private final JSTypeSubstitutor.JSTypeGenericId myId;
    @Nullable
    protected final JSType myConstraintType;
    private final boolean myApplying;

    public JSGenericParameterImpl(@NotNull String name, @NotNull JSTypeSource source, @Nullable JSType constraintType) {
        if (name == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(1);
        }
        this((JSTypeSubstitutor.JSTypeGenericId)new JSTypeSubstitutor.StringGenericId(name), source, false, constraintType);
    }

    public JSGenericParameterImpl(@NotNull JSTypeSubstitutor.JSTypeGenericId id, @NotNull JSTypeSource source, boolean isGenericApplying, @Nullable JSType constraintType) {
        if (id == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myId = id;
        this.myApplying = isGenericApplying;
        this.myConstraintType = constraintType;
    }

    protected JSGenericParameterImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(4);
        }
        if (inputStream == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(5);
        }
        super(source);
        this.myId = new JSTypeSubstitutor.StringGenericId(JSTypeSerializer.readString(inputStream));
        this.myConstraintType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myApplying = false;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myId.getName(), outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myConstraintType, outputStream);
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(7);
        }
        visitor.visitJSGenericParameter((JSType)this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(8);
        }
        if (this.myConstraintType != null) {
            this.myConstraintType.accept(visitor);
        }
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(10);
        }
        String name = this.myId.getName();
        if (format == JSType.TypeTextFormat.SIMPLE) {
            name = this.myApplying ? " 'Applying'" + name : name;
            JSType constraintType = this.getConstraintType();
            if (constraintType != null) {
                builder.append(name + "(extends " + constraintType.getTypeText(JSType.TypeTextFormat.SIMPLE) + ")");
                return;
            }
        }
        builder.append(name);
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.myId, this.myApplying, JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getConstraintType()));
    }

    @Override
    protected final boolean checkAlwaysAssignableType(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean result2;
        if (elementType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(11);
        }
        if (!(result2 = super.checkAlwaysAssignableType(elementType, processingContext)) || !this.isApplying() || processingContext == null) {
            return result2;
        }
        this.isDirectlyAssignableTypeImpl(elementType, processingContext);
        return true;
    }

    @Override
    protected final boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSGenericMappings context;
        if (elementType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(13);
        }
        if ((context = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey)) != null && this.isApplying()) {
            return this.isDirectAssignableInApplying(elementType, processingContext, context);
        }
        return this.isDirectlyAssignableTypeWithoutApplying(elementType, processingContext);
    }

    protected final boolean isDirectAssignableInApplying(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, @NotNull JSGenericMappings context) {
        if (elementType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(14);
        }
        if (processingContext == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(16);
        }
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArgumentsMap = context.getMapping();
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> deepGenericArgumentsMap = context.getDeepMapping();
        JSTypeSubstitutor.JSTypeGenericId ownId = this.getGenericId();
        if (elementType instanceof JSGenericParameterType && genericArgumentsMap.containsKey((Object)ownId)) {
            deepGenericArgumentsMap.put((Object)((JSGenericParameterType)elementType).getGenericId(), genericArgumentsMap.get((Object)ownId));
        } else {
            genericArgumentsMap.putValue((Object)ownId, (Object)elementType);
        }
        if (this.isContravariant()) {
            processingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)true);
        }
        return true;
    }

    protected boolean isDirectlyAssignableTypeWithoutApplying(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(18);
        }
        return true;
    }

    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType;
    }

    @Nullable
    protected JSType getRawConstraintType() {
        return this.getConstraintType();
    }

    @NotNull
    public final JSType substituteCompletely() {
        JSType rawConstraintType = this.getRawConstraintType();
        JSGenericParameterImpl jSGenericParameterImpl = rawConstraintType != null ? this.getNonRecursiveConstraintType(rawConstraintType) : this;
        if (jSGenericParameterImpl == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(19);
        }
        return jSGenericParameterImpl;
    }

    @NotNull
    private JSType getNonRecursiveConstraintType(@NotNull JSType rawConstraintType) {
        if (rawConstraintType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(20);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        substitutor.put(this.getGenericId(), (JSType)JSAnyType.get(this.getSource()));
        JSType jSType = JSTypeUtils.applyGenericArguments(rawConstraintType, substitutor);
        if (jSType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    public static boolean isCallEnvironment(@Nullable ProcessingContext processingContext) {
        return processingContext != null && Boolean.TRUE.equals(processingContext.get(CALL_ENV_KEY));
    }

    @NotNull
    public final String getName() {
        String string = this.myId.getName();
        if (string == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        JSType rConstraintType;
        if (type == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(23);
        }
        if (!this.myId.equals((Object)((JSGenericParameterImpl)type).getGenericId()) || ((JSGenericParameterImpl)type).myApplying != this.myApplying) {
            return false;
        }
        JSGenericParameterImpl rType = (JSGenericParameterImpl)type;
        JSType constraintType = this.getConstraintType();
        if (constraintType == (rConstraintType = rType.getConstraintType())) {
            return true;
        }
        if (constraintType == null) {
            return false;
        }
        return constraintType.isEquivalentTo(rConstraintType, processingContext, allowResolve);
    }

    @Override
    @NotNull
    protected final JSGenericParameterImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(24);
        }
        JSGenericParameterImpl jSGenericParameterImpl = this.copyWithSourceAndApplying(source, this.myApplying);
        if (jSGenericParameterImpl == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(25);
        }
        return jSGenericParameterImpl;
    }

    @NotNull
    public JSGenericParameterImpl copyWithSourceAndApplying(@NotNull JSTypeSource source, boolean applying) {
        if (source == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(26);
        }
        return new JSGenericParameterImpl(this.myId, source, applying, this.myConstraintType);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(27);
        }
        if (this.getConstraintType() == null) {
            JSGenericParameterImpl jSGenericParameterImpl = this;
            if (jSGenericParameterImpl == null) {
                JSGenericParameterImpl.$$$reportNull$$$0(28);
            }
            return jSGenericParameterImpl;
        }
        JSType transformedConstraint = this.getConstraintType().transformTypeHierarchy(childTransform);
        if (transformedConstraint == this.getConstraintType()) {
            JSGenericParameterImpl jSGenericParameterImpl = this;
            if (jSGenericParameterImpl == null) {
                JSGenericParameterImpl.$$$reportNull$$$0(29);
            }
            return jSGenericParameterImpl;
        }
        if (transformedConstraint instanceof JSGenericParameterImpl) {
            JSGenericParameterImpl constraintParameter = (JSGenericParameterImpl)transformedConstraint;
            if (this.getGenericId().equals((Object)constraintParameter.getGenericId())) {
                return new JSGenericParameterImpl(this.getGenericId(), this.getSource(), false, constraintParameter.getConstraintType());
            }
        }
        return new JSGenericParameterImpl(this.getGenericId(), this.getSource(), false, transformedConstraint);
    }

    protected boolean isContravariant() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (!(sourceElement instanceof TypeScriptType)) {
            return true;
        }
        TypeScriptFunctionType type = (TypeScriptFunctionType)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptFunctionType.class});
        return type != null && !PsiTreeUtil.isContextAncestor((PsiElement)type.getReturnTypeElement(), (PsiElement)sourceElement, (boolean)false);
    }

    @NotNull
    public final JSTypeSubstitutor.JSTypeGenericId getGenericId() {
        JSTypeSubstitutor.JSTypeGenericId jSTypeGenericId = this.myId;
        if (jSTypeGenericId == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(30);
        }
        return jSTypeGenericId;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.getRawConstraintType() != null ? super.asRecordTypeNoCache() : this.emptyRecordType();
        if (jSRecordType == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(31);
        }
        return jSRecordType;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        JSType constraintType;
        if (processingContext == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(32);
        }
        if ((constraintType = this.getRawConstraintType()) != null) {
            Stream stream = this.getNonRecursiveConstraintType(constraintType).getFunctionTypes(processingContext, newCallSignatures);
            if (stream == null) {
                JSGenericParameterImpl.$$$reportNull$$$0(33);
            }
            return stream;
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSGenericParameterImpl.$$$reportNull$$$0(34);
        }
        return stream;
    }

    public boolean isApplying() {
        return this.myApplying;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawConstraintType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonRecursiveConstraintType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericId";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAlwaysAssignableType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableInApplying";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeWithoutApplying";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNonRecursiveConstraintType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyWithSourceAndApplying";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

