/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectType
extends JSTypeBaseImpl {
    public JsonObjectType(@NotNull JsonObject element) {
        if (element == null) {
            JsonObjectType.$$$reportNull$$$0(0);
        }
        super(JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
    }

    protected JsonObjectType(@NotNull JSTypeSource source) {
        if (source == null) {
            JsonObjectType.$$$reportNull$$$0(1);
        }
        super(source);
        assert (source.getSourceElement() instanceof JsonObject);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JsonObjectType.$$$reportNull$$$0(2);
        }
        JsonObjectType jsonObjectType = this;
        if (jsonObjectType == null) {
            JsonObjectType.$$$reportNull$$$0(3);
        }
        return jsonObjectType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JsonObjectType.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            JsonObjectType.$$$reportNull$$$0(5);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            PsiElement element = this.getSourceElement();
            builder.append("json(" + (element != null ? element.getText() : "") + ")");
            return;
        }
        JSRecordType type = this.asRecordType();
        builder.append((JSType)type, format);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JsonObjectType.$$$reportNull$$$0(6);
        }
        return new JsonObjectType(source);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JsonObjectType.$$$reportNull$$$0(7);
        }
        return Objects.equals(this.getSourceElement(), type.getSourceElement());
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return this.getSourceHashCode();
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        PsiElement element = this.getSourceElement();
        if (element instanceof JsonFile) {
            element = ((JsonFile)element).getTopLevelValue();
        }
        if (element instanceof JsonObject) {
            List list2 = ((JsonObject)element).getPropertyList();
            SmartList properties = new SmartList();
            for (JsonProperty property : list2) {
                JsonValue value = property.getValue();
                JSType type = value == null ? null : JsonObjectType.createJsonObjectType((JsonElement)value, null);
                properties.add(new JSRecordTypeImpl.PropertySignatureImpl(property.getName(), type, false, false, (PsiElement)property));
            }
            return new JSRecordTypeImpl(this.getSource(), (List<? extends JSRecordType.TypeMember>)properties);
        }
        JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JsonObjectType.$$$reportNull$$$0(8);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSType createJsonObjectType(@NotNull JsonElement element, @Nullable PsiElement context) {
        if (element == null) {
            JsonObjectType.$$$reportNull$$$0(9);
        }
        if (context == null) {
            context = element;
        }
        if (element instanceof JsonFile) {
            JsonElement finalElement = element;
            element = (JsonElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)((JsonFile)finalElement), () -> ((JsonFile)finalElement).getTopLevelValue());
        } else if (element instanceof JsonProperty) {
            element = ((JsonProperty)element).getValue();
        }
        if (element instanceof JsonValue) {
            if (element instanceof JsonObject) {
                return new JsonObjectType((JsonObject)element);
            }
            String name = null;
            if (element instanceof JsonBooleanLiteral) {
                name = "boolean";
            }
            if (element instanceof JsonStringLiteral) {
                name = "string";
            }
            if (element instanceof JsonNumberLiteral) {
                name = "number";
            }
            if (name != null) {
                JSType jSType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSTypeContext.INSTANCE);
                if (jSType == null) {
                    JsonObjectType.$$$reportNull$$$0(10);
                }
                return jSType;
            }
        }
        JSAnyType jSAnyType = JSAnyType.get(context, true);
        if (jSAnyType == null) {
            JsonObjectType.$$$reportNull$$$0(11);
        }
        return jSAnyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JsonObjectType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JsonObjectType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonObjectType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createJsonObjectType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

