/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCallInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSInstructionWithReachability;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSLoopJunctionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCompositeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDeclaredTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDecoratorsOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSEmptyOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSMergeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByArrayMutationOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByEqualityOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByInstanceOfOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeBySwitchDiscriminantOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeBySwitchOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTruthinessOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypeofOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypeofSwitchOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSUnionOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByAssignmentOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByConstructorOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByDiscriminantEqualityOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByDiscriminantTruthinessOperation;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSControlFlowTypeGuard {
    private static final Logger LOGGER = Logger.getInstance(JSControlFlowTypeGuard.class);
    private static final int CF_DEPTH_LIMIT = 100;
    private final boolean myResetDecoratorsOnAnyCall;
    private final AtomicInteger myDepth;
    private final ArrayDeque<Instruction> myLoopStack;
    @Nullable
    private final JSElement myStartControlFlowScope;
    @Nullable
    private final PsiElement myTopLeftResolvedElement;
    @NotNull
    private final List<PsiElement> myAllTopLeftResolvedElements;
    @NotNull
    protected final JSExpression myReference;
    @NotNull
    private final JSExpression myTopLeftReference;
    private final boolean myIsTypeScript;
    private final boolean myPossibleAutoType;
    private final Map<Instruction, JSTypeOperation> myCalculatedTypes;

    protected JSControlFlowTypeGuard(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(0);
        }
        this.myDepth = new AtomicInteger();
        this.myLoopStack = new ArrayDeque();
        this.myCalculatedTypes = new HashMap<Instruction, JSTypeOperation>();
        this.myReference = reference;
        this.myIsTypeScript = DialectDetector.isTypeScript((PsiElement)reference);
        this.myStartControlFlowScope = JSControlFlowTypeGuard.getStartControlFlowScope((PsiElement)reference);
        this.myTopLeftReference = JSControlFlowTypeGuard.getTopLeftExpression(reference);
        this.myAllTopLeftResolvedElements = JSControlFlowTypeGuard.resolveReferenceExpressionLocallyMerged((PsiElement)this.myTopLeftReference);
        this.myTopLeftResolvedElement = (PsiElement)ContainerUtil.getLastItem(this.myAllTopLeftResolvedElements);
        this.myResetDecoratorsOnAnyCall = JSControlFlowTypeGuard.shouldResetDecoratorsOnAssignments(this.myTopLeftResolvedElement, (PsiElement)this.myStartControlFlowScope, reference, JSControlFlowTypeGuard.getFirstQualifierName(reference));
        this.myPossibleAutoType = this.myTopLeftReference == this.myReference && this.myIsTypeScript && JSControlFlowTypeGuard.possibleAutoType(this.myTopLeftResolvedElement);
    }

    private static boolean possibleAutoType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        Pair<Boolean, Boolean> states = JSTypeGuardUtil.getAutoTypeStates(element);
        return states != null && ((Boolean)states.first != false || (Boolean)states.second != false);
    }

    private static List<PsiElement> resolveReferenceExpressionLocallyMerged(@Nullable PsiElement expression) {
        if (!(expression instanceof JSReferenceExpression)) {
            return Collections.emptyList();
        }
        String name = ((JSReferenceExpression)expression).getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return Collections.emptyList();
        }
        return JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, expression, false);
    }

    @Nullable
    private static PsiElement resolveReferenceExpressionLocally(@Nullable PsiElement expression) {
        return (PsiElement)ContainerUtil.getLastItem(JSControlFlowTypeGuard.resolveReferenceExpressionLocallyMerged(expression));
    }

    @NotNull
    private static JSExpression getTopLeftExpression(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(1);
        }
        JSExpression qualifier = expression.getQualifier();
        JSReferenceExpression result2 = expression;
        while (qualifier instanceof JSQualifiedExpression) {
            result2 = (JSQualifiedExpression)qualifier;
            qualifier = result2.getQualifier();
        }
        JSReferenceExpression jSReferenceExpression = result2;
        if (jSReferenceExpression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(2);
        }
        return jSReferenceExpression;
    }

    private static boolean shouldResetDecoratorsOnAssignments(@Nullable PsiElement resolveResult, @Nullable PsiElement startControlFlowScope, @NotNull JSReferenceExpression reference, @NotNull String topName) {
        ASTNode node;
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(3);
        }
        if (topName == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(4);
        }
        if (!(resolveResult instanceof JSVariable)) {
            return true;
        }
        if (((JSVariable)resolveResult).isConst() && !(resolveResult instanceof JSField)) {
            return false;
        }
        if (reference.getQualifier() != null || !JSControlFlowTypeGuard.isLocalSymbol((JSVariable)resolveResult)) {
            return true;
        }
        ASTNode aSTNode = node = startControlFlowScope == null ? null : startControlFlowScope.getNode();
        if (!(node instanceof CompositeElement)) {
            return true;
        }
        JSElement variableDefaultScope = JSControlFlowTypeGuard.getStartControlFlowScope(resolveResult);
        if (variableDefaultScope != startControlFlowScope) {
            return true;
        }
        return JSTreeUtil.hasDeclarationOrAssignmentInNestedScopes((CompositeElement)node, topName);
    }

    private static boolean isLocalSymbol(@NotNull JSVariable resolveResult) {
        JSFile file2;
        JSFile.ModuleStatus status;
        PsiElement declarationScope;
        if (resolveResult == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(5);
        }
        if (!((declarationScope = resolveResult.getDeclarationScope()) instanceof PsiFile)) {
            return true;
        }
        PsiFile containingFile = (PsiFile)declarationScope;
        return containingFile instanceof JSFile && ((status = (file2 = (JSFile)containingFile).getModuleStatus()) == JSFile.ModuleStatus.ES6 || status == JSFile.ModuleStatus.COMMONJS);
    }

    public static boolean isEvolvingArrayOperationTarget(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(6);
        }
        if ((parent = expression.getParent()) instanceof JSIndexedPropertyAccessExpression && parent instanceof JSDefinitionExpression) {
            return true;
        }
        if (expression instanceof JSReferenceExpression && parent instanceof JSReferenceExpression) {
            JSReferenceExpression parentExpression = (JSReferenceExpression)parent;
            if (parentExpression.getParent() instanceof JSReferenceExpression) {
                return false;
            }
            String name = parentExpression.getName();
            return JSControlFlowTypeGuard.isPushOrUnshiftName(name) || "length".equals(name);
        }
        return false;
    }

    public static boolean isPushOrUnshiftName(@Nullable String name) {
        return "push".equals(name) || "unshift".equals(name);
    }

    public static boolean checkUseAutoTypeFromConfig(@NotNull JSReferenceExpression reference, @NotNull PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(7);
        }
        if (resolveResult == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(8);
        }
        return config2 != null && config2.noImplicitAny() && reference.getContainingFile().equals(resolveResult.getContainingFile());
    }

    @NotNull
    public final JSTypeOperation getNarrowedTypeOperations() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSControlFlowService.JSControlFlow flow = this.getStartControlFlow();
        if (flow == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(9);
            }
            return jSDeclaredTypeOperation;
        }
        Instruction instruction = this.getControlFlowInstruction(flow, (PsiElement)this.myReference);
        if (instruction == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(10);
            }
            return jSDeclaredTypeOperation;
        }
        return this.getTypeAtFlowNode(flow, instruction);
    }

    @Nullable
    public Instruction getControlFlowInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull PsiElement context) {
        Instruction[] instructions;
        int indexOfElement;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(12);
        }
        if ((indexOfElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = flow.getInstructions()), (PsiElement)context)) == -1) {
            Document document2 = PsiDocumentManager.getInstance((Project)context.getProject()).getDocument(context.getContainingFile());
            int number = document2 == null ? -1 : document2.getLineNumber(context.getNode().getStartOffset());
            LOGGER.debug("Control flow must contain all semantic elements for correct type inference, line " + number + ", class " + context.getClass());
            return null;
        }
        return instructions[indexOfElement];
    }

    @Nullable
    private JSControlFlowService.JSControlFlow getStartControlFlow() {
        return this.getControlFlowScope(this.myStartControlFlowScope);
    }

    @Nullable
    private static JSElement getStartControlFlowScope(@NotNull PsiElement context) {
        PsiElement result2;
        if (context == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(13);
        }
        return (result2 = PsiTreeUtil.findFirstContext((PsiElement)context, (boolean)true, element -> {
            if (element instanceof JSClass) {
                return true;
            }
            if (element instanceof JSEmbeddedContent) {
                return ES6PsiUtil.isEmbeddedBlock(element);
            }
            return element instanceof JSExecutionScope;
        })) instanceof JSClass || !(result2 instanceof JSElement) ? null : (JSElement)result2;
    }

    @Nullable
    public JSControlFlowService.JSControlFlow getControlFlowScope(@Nullable JSElement executionScope) {
        if (executionScope == null || executionScope instanceof JSClass) {
            return null;
        }
        return JSControlFlowService.getService(this.myReference.getProject()).getControlFlow(executionScope);
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowNode(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(14);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        if (currentInstruction instanceof JSLoopJunctionInstruction) {
            return this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
        }
        JSTypeOperation type = this.myCalculatedTypes.get(currentInstruction);
        if (type != null) {
            JSTypeOperation jSTypeOperation = type;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(16);
            }
            return jSTypeOperation;
        }
        type = this.getTypeAtFlowNodeImpl(flow, currentInstruction);
        this.myCalculatedTypes.put(currentInstruction, type);
        JSTypeOperation jSTypeOperation = type;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(17);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowNodeImpl(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(18);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(19);
        }
        HashSet<Instruction> visitedInstructions = new HashSet<Instruction>();
        while (currentInstruction != null) {
            Collection prevInstructions;
            int size;
            JSTypeOperation result2;
            JSTypeOperation assignmentType;
            if (!visitedInstructions.add(currentInstruction)) {
                JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
                if (jSDeclaredTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(20);
                }
                return jSDeclaredTypeOperation;
            }
            if (currentInstruction instanceof JSEntryPointInstruction) {
                boolean isReferenceExpression;
                JSElement scope = ((JSEntryPointInstruction)currentInstruction).getScope();
                if (this.isFinalScope((PsiElement)scope) || (!(isReferenceExpression = this.myReference instanceof JSReferenceExpression) || ((JSReferenceExpression)this.myReference).getQualifier() != null) && (isReferenceExpression || this.myReference instanceof JSThisExpression)) break;
                JSTypeOperation jSTypeOperation = JSDecoratorsOperation.create(this.getTypeAtParentScope((PsiElement)scope), Collections.emptySet());
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(21);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSReadWriteInstruction && (assignmentType = this.getTypeAtFlowReadWrite(flow, (JSReadWriteInstruction)currentInstruction)) != null) {
                JSTypeOperation jSTypeOperation = assignmentType;
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(22);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSModificationInstruction && (result2 = this.getTypeAtFlowArrayMutation(flow, (JSModificationInstruction)currentInstruction)) != null) {
                JSTypeOperation jSTypeOperation = result2;
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(23);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSCaseBlockInstruction) {
                return this.getTypeAtCaseBlock(flow, (JSCaseBlockInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                return this.getTypeAtFlowCondition(flow, (JSConditionInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSLoopJunctionInstruction) {
                return this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSCallInstruction) {
                PsiElement element = currentInstruction.getElement();
                if (element instanceof JSCallExpression && JSControlFlowTypeGuard.isSuitableCallForAssertion((JSCallExpression)element)) {
                    JSTypeOperation assertion = this.getTypeAtCallAssertion(flow, (JSCallInstruction)currentInstruction, (JSCallExpression)element);
                    JSTypeOperation jSTypeOperation = this.myResetDecoratorsOnAnyCall ? JSDecoratorsOperation.create(assertion, Collections.emptySet()) : assertion;
                    if (jSTypeOperation == null) {
                        JSControlFlowTypeGuard.$$$reportNull$$$0(24);
                    }
                    return jSTypeOperation;
                }
                if (this.myResetDecoratorsOnAnyCall) {
                    JSTypeOperation jSTypeOperation = JSDecoratorsOperation.create(this.getPrevFlowType(flow, currentInstruction), Collections.emptySet());
                    if (jSTypeOperation == null) {
                        JSControlFlowTypeGuard.$$$reportNull$$$0(25);
                    }
                    return jSTypeOperation;
                }
            }
            if ((size = (prevInstructions = currentInstruction.allPred()).size()) == 0) break;
            if (size > 1) {
                return this.getPrevFlowType(flow, currentInstruction);
            }
            currentInstruction = (Instruction)ContainerUtil.getFirstItem((Collection)prevInstructions);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(26);
        }
        return jSDeclaredTypeOperation;
    }

    private boolean isFinalScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(27);
        }
        return scope instanceof JSFile || scope instanceof TypeScriptModule || ES6PsiUtil.isEmbeddedModule(scope) || scope instanceof JSFunction && this.isFinalFunctionScope((JSFunction)scope);
    }

    private boolean isFinalFunctionScope(@NotNull JSFunction scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(28);
        }
        if (!(scope instanceof JSFunctionExpression) && !JSControlFlowTypeGuard.isObjectLiteralOrClassExpressionMethod(scope)) {
            return true;
        }
        if (JSPsiImplUtils.isIIFE(scope)) {
            return false;
        }
        if (this.myTopLeftResolvedElement instanceof JSConstStatusOwner && ((JSConstStatusOwner)this.myTopLeftResolvedElement).isConst()) {
            return false;
        }
        if (this.myTopLeftResolvedElement instanceof JSParameter) {
            JSTreeUtil.JSScopeDeclarationsAndAssignments assignmentsInScope;
            ASTNode node;
            String name = ((JSParameter)this.myTopLeftResolvedElement).getName();
            JSFunction function2 = ((JSParameter)this.myTopLeftResolvedElement).getDeclaringFunction();
            ASTNode aSTNode = node = function2 != null ? function2.getNode() : null;
            if (node instanceof CompositeElement && name != null && !(assignmentsInScope = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)node)).hasAssignments()) {
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    private static boolean isObjectLiteralOrClassExpressionMethod(@NotNull JSFunction scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(29);
        }
        return scope instanceof ES6FunctionProperty;
    }

    @NotNull
    private JSTypeOperation getTypeAtLoop(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSLoopJunctionInstruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(30);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(31);
        }
        JSTypeOperation currentValue = this.myCalculatedTypes.get((Object)instruction);
        if (this.myLoopStack.contains((Object)instruction) || currentValue != null) {
            JSTypeOperation jSTypeOperation = currentValue == null ? JSEmptyOperation.NO_OPERATION : currentValue;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(32);
            }
            return jSTypeOperation;
        }
        this.myLoopStack.push((Instruction)instruction);
        JSTypeOperation resultType = this.getRegularPredTypes(flow, instruction.getRegularPred());
        if (!this.isDeclareOperationNoAutoType(resultType)) {
            this.myCalculatedTypes.put((Instruction)instruction, resultType);
            Collection<Instruction> jumps = instruction.getJumpPred();
            if (!jumps.isEmpty()) {
                resultType = JSUnionOperation.create(resultType, this.getPrevFlowTypeForInstructions(flow, jumps), true);
            }
        }
        this.myLoopStack.pop();
        this.myCalculatedTypes.put((Instruction)instruction, resultType);
        JSTypeOperation jSTypeOperation = resultType;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(33);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getRegularPredTypes(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> regularPreds) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(34);
        }
        if (regularPreds == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(35);
        }
        if (regularPreds.size() > 0) {
            return this.getPrevFlowTypeForInstructions(flow, regularPreds);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(36);
        }
        return jSDeclaredTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowReadWrite(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction) {
        ReadWriteAccessDetector.Access access;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(37);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(38);
        }
        if ((access = currentInstruction.getAccess()) == ReadWriteAccessDetector.Access.Read) {
            return this.getTypeAtFlowRead(flow, currentInstruction);
        }
        return this.getTypeAtFlowAssignment(flow, currentInstruction, access);
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowRead(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction) {
        PsiElement element;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(39);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(40);
        }
        if ((element = currentInstruction.getElement()) != this.myReference && element instanceof JSReferenceExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof TypeScriptNotNullExpression) {
                parent = ((TypeScriptNotNullExpression)parent).getExpression();
            }
            if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != element) {
                return null;
            }
            if (this.isMatchingReference((PsiElement)this.myReference, element) && !((JSReferenceExpression)parent).isElvis()) {
                JSTypeOperation prev = this.getPrevFlowType(flow, (Instruction)currentInstruction);
                return JSDecoratorsOperation.create(prev, JSTypeGuardChecker.NOTNULL_NOTUNDEFINED);
            }
        }
        return null;
    }

    @NotNull
    protected JSTypeOperation narrowTypeByEquality(@NotNull JSTypeOperation prev, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(41);
        }
        if (sign == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(42);
        }
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(43);
        }
        return PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)this.myReference, (boolean)false) ? prev : new JSNarrowTypeByEqualityOperation(prev, sign, expression, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue);
    }

    @NotNull
    private JSTypeOperation narrowTypeByAnd(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(44);
        }
        if (expr == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(45);
        }
        if (assumeTrue) {
            return this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), true), expr.getROperand(), true);
        }
        JSTypeOperation type1 = this.narrowTypeOperation(prevOperation, expr.getLOperand(), false);
        if (this.isDeclareOperationNoAutoType(type1)) {
            JSTypeOperation jSTypeOperation = type1;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(46);
            }
            return jSTypeOperation;
        }
        JSTypeOperation type2 = this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), true), expr.getROperand(), false);
        JSTypeOperation jSTypeOperation = JSUnionOperation.create(type1, type2, false);
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(47);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation narrowTypeByOr(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(48);
        }
        if (expr == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(49);
        }
        if (assumeTrue) {
            JSTypeOperation left = this.narrowTypeOperation(prevOperation, expr.getLOperand(), true);
            if (this.isDeclareOperationNoAutoType(left)) {
                JSTypeOperation jSTypeOperation = left;
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(50);
                }
                return jSTypeOperation;
            }
            JSTypeOperation right = this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), false), expr.getROperand(), true);
            JSTypeOperation jSTypeOperation = JSUnionOperation.create(left, right, false);
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(51);
            }
            return jSTypeOperation;
        }
        return this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), false), expr.getROperand(), false);
    }

    private boolean isDeclareOperationNoAutoType(JSTypeOperation left) {
        return left == JSDeclaredTypeOperation.DECLARED_TYPE && !this.myPossibleAutoType;
    }

    protected boolean isMatchingReferenceDiscriminantByEqualityCandidate(@Nullable PsiElement expression, boolean assumeTrue, @NotNull IElementType sign) {
        if (sign == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(52);
        }
        return this.isMatchingReferenceDiscriminantCandidate(expression);
    }

    @NotNull
    private JSTypeOperation narrowTypeByInstanceof(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        JSExpression left;
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(53);
        }
        if (expr == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(54);
        }
        if ((left = JSTypeGuardUtil.getReferenceCandidate(expr.getLOperand())) == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(55);
            }
            return jSTypeOperation;
        }
        JSExpression rOperand = expr.getROperand();
        if (rOperand == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(56);
            }
            return jSTypeOperation;
        }
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
            return this.createElvisNarrowingIfNeeded(this.containsMatchingReference((PsiElement)this.myReference, (PsiElement)left) ? JSDeclaredTypeOperation.DECLARED_TYPE : prevOperation, JSTokenTypes.INSTANCEOF_KEYWORD, rOperand, assumeTrue, left);
        }
        return new JSNarrowTypeByInstanceOfOperation(prevOperation, rOperand, assumeTrue);
    }

    @NotNull
    protected final JSTypeOperation getTypeAtSwitchClause(@NotNull JSTypeOperation prevOperation, @NotNull JSSwitchStatement statement, int start, int end) {
        JSCaseClause[] clauses;
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(57);
        }
        if (statement == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(58);
        }
        if ((clauses = statement.getCaseClauses()).length == 0 || clauses.length < end) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(59);
            }
            return jSTypeOperation;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)expression)) {
            return new JSNarrowTypeBySwitchDiscriminantOperation(prevOperation, statement, start, end);
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminantCandidate((PsiElement)expression)) {
            return new JSNarrowTypeBySwitchOperation(prevOperation, statement, (JSReferenceExpression)expression, start, end);
        }
        if (expression instanceof JSPrefixExpression) {
            JSPrefixExpression prefix = (JSPrefixExpression)expression;
            JSExpression prefixExpression = prefix.getExpression();
            if (prefix.getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD && this.isMatchingReference((PsiElement)this.myReference, (PsiElement)prefixExpression)) {
                JSTypeOperation jSTypeOperation = JSNarrowTypeByTypeofSwitchOperation.create(prevOperation, statement, start, end);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(60);
                }
                return jSTypeOperation;
            }
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(61);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected JSTypeOperation narrowByCallExpression(@NotNull JSTypeOperation prev, @NotNull JSCallExpression expr, boolean assumeTrue, boolean isAssertion) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(62);
        }
        if (expr == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(63);
        }
        JSTypeOperation jSTypeOperation = this.createNarrowByCallExpressionOperation(prev, expr, assumeTrue, isAssertion);
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(64);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected final JSTypeOperation narrowTypeOperation(@NotNull JSTypeOperation prevOperation, @Nullable JSExpression expression, boolean assumeTrue) {
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(65);
        }
        ProgressManager.checkCanceled();
        if (prevOperation == JSEmptyOperation.NO_OPERATION) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(66);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSSuperExpression || expression instanceof JSThisExpression || expression instanceof JSReferenceExpression) {
            return this.narrowTypeByTruthiness(prevOperation, expression, assumeTrue);
        }
        if (expression instanceof JSCallExpression) {
            JSTypeOperation jSTypeOperation = this.narrowByCallExpression(prevOperation, (JSCallExpression)expression, assumeTrue, false);
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(67);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSParenthesizedExpression) {
            return this.narrowTypeOperation(prevOperation, ((JSParenthesizedExpression)expression).getInnerExpression(), assumeTrue);
        }
        if (expression instanceof JSBinaryExpression) {
            return this.narrowTypeByBinaryExpression(prevOperation, (JSBinaryExpression)expression, assumeTrue);
        }
        if (expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL) {
            return this.narrowTypeOperation(prevOperation, ((JSPrefixExpression)expression).getExpression(), !assumeTrue);
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(68);
        }
        return jSTypeOperation;
    }

    protected JSTypeOperation createNarrowTypeByTruthinessOperation(@NotNull JSTypeOperation prev, boolean assumeTrue) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(69);
        }
        return new JSNarrowTypeByTruthinessOperation(prev, assumeTrue);
    }

    @NotNull
    protected JSTypeOperation createNarrowTypeByDiscriminantTruthinessOperation(@NotNull JSTypeOperation prev, @NotNull JSReferenceExpression expression, boolean assumeTrue) {
        String name;
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(70);
        }
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(71);
        }
        if ((name = expression.getReferenceName()) == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(72);
            }
            return jSTypeOperation;
        }
        return new TypeScriptNarrowTypeByDiscriminantTruthinessOperation(prev, name, assumeTrue, JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)expression));
    }

    @NotNull
    protected abstract JSTypeOperation createNarrowByCallExpressionOperation(@NotNull JSTypeOperation var1, @NotNull JSCallExpression var2, boolean var3, boolean var4);

    @NotNull
    private JSTypeOperation narrowTypeByTruthiness(@NotNull JSTypeOperation prev, @Nullable JSExpression expression, boolean assumeTrue) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(73);
        }
        if (expression == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(74);
            }
            return jSTypeOperation;
        }
        if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)expression)) {
            JSTypeOperation jSTypeOperation = this.createNarrowTypeByTruthinessOperation(prev, assumeTrue);
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(75);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminantByTruthinessCandidate((PsiElement)expression)) {
            JSTypeOperation jSTypeOperation = this.createNarrowTypeByDiscriminantTruthinessOperation(prev, (JSReferenceExpression)expression, assumeTrue);
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(76);
            }
            return jSTypeOperation;
        }
        JSTypeOperation jSTypeOperation = prev;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(77);
        }
        return jSTypeOperation;
    }

    protected boolean isMatchingReferenceDiscriminantByTruthinessCandidate(@Nullable PsiElement expression) {
        return this.isMatchingReferenceDiscriminantCandidate(expression);
    }

    protected boolean isMatchingReferenceDiscriminantCandidate(@Nullable PsiElement expression) {
        if (!(expression instanceof JSElvisOwner)) {
            return false;
        }
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getReferenceName() == null) {
            return false;
        }
        JSExpression qualifier = JSControlFlowTypeGuard.getElvisQualifierForNarrowing(expression);
        if (qualifier == null) {
            return false;
        }
        if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier)) {
            return true;
        }
        boolean hasMatching = false;
        boolean hasElvis = false;
        while (qualifier != null) {
            if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier)) {
                hasMatching = true;
            }
            if (hasElvis) break;
            if (qualifier instanceof JSElvisOwner && ((JSElvisOwner)qualifier).isElvis()) {
                hasElvis = true;
            }
            qualifier = JSControlFlowTypeGuard.getElvisQualifierForNarrowing((PsiElement)qualifier);
        }
        return hasMatching && hasElvis;
    }

    @Nullable
    private static JSExpression getElvisQualifierForNarrowing(@NotNull PsiElement expression) {
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(78);
        }
        JSExpression qualifier = null;
        if (expression instanceof JSQualifiedExpression) {
            qualifier = ((JSQualifiedExpression)expression).getQualifier();
        } else if (expression instanceof JSCallExpression && (qualifier = ((JSCallExpression)expression).getMethodExpression()) instanceof JSQualifiedExpression) {
            qualifier = ((JSQualifiedExpression)qualifier).getQualifier();
        }
        return qualifier;
    }

    @Contract(value="_,null -> false")
    protected final boolean containsMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        while (JSControlFlowTypeGuard.isPropertyAccessExpression(source)) {
            if (!this.isMatchingReference(source = ((JSReferenceExpression)source).getQualifier(), target)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (target == null || source == null) {
            return false;
        }
        if (target == source) {
            return true;
        }
        if (target instanceof JSAssignmentExpression) {
            target = ((JSAssignmentExpression)target).getDefinitionExpression();
        }
        if (target instanceof JSDefinitionExpression) {
            target = ((JSDefinitionExpression)target).getExpression();
        }
        if (source instanceof JSReferenceExpression && target instanceof JSReferenceExpression) {
            String sourceName;
            String targetName = ((JSReferenceExpression)target).getReferenceName();
            if (!StringUtil.equals((CharSequence)targetName, (CharSequence)(sourceName = ((JSReferenceExpression)source).getReferenceName())) || targetName == null || sourceName == null) {
                return false;
            }
            JSExpression targetQualifier = ((JSReferenceExpression)target).getQualifier();
            JSExpression sourceQualifier = ((JSReferenceExpression)source).getQualifier();
            if (targetQualifier == null) {
                PsiElement targetElement;
                if (sourceQualifier != null) {
                    return false;
                }
                PsiElement sourceElement = this.myTopLeftReference == source ? this.myTopLeftResolvedElement : JSControlFlowTypeGuard.resolveReferenceExpressionLocally(source);
                PsiElement psiElement = targetElement = this.myTopLeftReference == target ? this.myTopLeftResolvedElement : JSControlFlowTypeGuard.resolveReferenceExpressionLocally(target);
                if (sourceElement != targetElement) {
                    return false;
                }
                if (sourceElement == null) {
                    return Objects.equals(source.getContainingFile(), target.getContainingFile());
                }
                return true;
            }
            return this.isMatchingReference((PsiElement)targetQualifier, (PsiElement)sourceQualifier);
        }
        if (source instanceof JSVariable && target instanceof JSReferenceExpression) {
            return this.isMatchingReferenceForVariable((JSFieldVariable)source, (JSReferenceExpression)target);
        }
        if (source instanceof JSReferenceExpression && target instanceof JSVariable) {
            return this.isMatchingReferenceForVariable((JSFieldVariable)target, (JSReferenceExpression)source);
        }
        if (source instanceof JSThisExpression && target instanceof JSThisExpression) {
            return true;
        }
        if (source instanceof JSSuperExpression && target instanceof JSSuperExpression) {
            return true;
        }
        if (source instanceof TypeScriptNotNullExpression && target instanceof TypeScriptNotNullExpression) {
            return this.isMatchingReference((PsiElement)((TypeScriptNotNullExpression)source).getExpression(), (PsiElement)((TypeScriptNotNullExpression)target).getExpression());
        }
        return false;
    }

    private boolean isMatchingReferenceForVariable(@NotNull JSFieldVariable variable, @NotNull JSReferenceExpression expression) {
        String varName;
        JSExpression qualifier;
        if (variable == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(79);
        }
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(80);
        }
        if ((qualifier = expression.getQualifier()) != null) {
            return false;
        }
        String name = expression.getReferenceName();
        if (!StringUtil.equals((CharSequence)name, (CharSequence)(varName = variable.getName()))) {
            return false;
        }
        if (expression == this.myTopLeftReference) {
            return this.myAllTopLeftResolvedElements.contains(variable);
        }
        return variable.equals(JSControlFlowTypeGuard.resolveReferenceExpressionLocally((PsiElement)expression));
    }

    private static boolean isPropertyAccessExpression(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null;
    }

    @NotNull
    protected final JSTypeOperation narrowTypeByBinaryExpression(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expression, boolean assumeTrue) {
        IElementType sign;
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(81);
        }
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(82);
        }
        if ((sign = expression.getOperationSign()) == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(83);
            }
            return jSTypeOperation;
        }
        if (sign == JSTokenTypes.ANDAND) {
            return this.narrowTypeByAnd(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.OROR) {
            return this.narrowTypeByOr(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.EQ) {
            return this.narrowTypeByTruthiness(prevOperation, expression.getLOperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
            return this.narrowTypeByInstanceof(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.COMMA) {
            return this.narrowTypeOperation(prevOperation, expression.getROperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.IN_KEYWORD) {
            JSExpression lOperand = expression.getLOperand();
            JSExpression candidate = JSTypeGuardUtil.getReferenceCandidate(expression.getROperand());
            if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isStringLiteral() && this.isMatchingReference((PsiElement)this.myReference, (PsiElement)candidate)) {
                String value = ((JSLiteralExpression)lOperand).getStringValue();
                if (!StringUtil.isEmptyOrSpaces((String)value)) {
                    JSTypeOperation jSTypeOperation = this.createNarrowTypeByInKeywordOperation(prevOperation, (PsiElement)lOperand, value, assumeTrue);
                    if (jSTypeOperation == null) {
                        JSControlFlowTypeGuard.$$$reportNull$$$0(84);
                    }
                    return jSTypeOperation;
                }
                JSTypeOperation jSTypeOperation = prevOperation;
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(85);
                }
                return jSTypeOperation;
            }
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(86);
            }
            return jSTypeOperation;
        }
        if (sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ) {
            JSExpression left = JSTypeGuardUtil.getReferenceCandidate(expression.getLOperand());
            JSExpression right = JSTypeGuardUtil.getReferenceCandidate(expression.getROperand());
            if (left == null || right == null) {
                JSTypeOperation jSTypeOperation = prevOperation;
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(87);
                }
                return jSTypeOperation;
            }
            JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
            if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByTypeof(prevOperation, leftTypeOf, sign, (JSLiteralExpression)right, assumeTrue);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(88);
                }
                return jSTypeOperation;
            }
            JSPrefixExpression rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right);
            if (rightTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByTypeof(prevOperation, rightTypeOf, sign, (JSLiteralExpression)left, assumeTrue);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(89);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByEquality(prevOperation, sign, right, assumeTrue);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(90);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByEquality(prevOperation, sign, left, assumeTrue);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(91);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReferenceDiscriminantByEqualityCandidate((PsiElement)left, assumeTrue, sign)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByDiscriminantEquality(prevOperation, assumeTrue, sign, right, left);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(92);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReferenceDiscriminantByEqualityCandidate((PsiElement)right, assumeTrue, sign)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByDiscriminantEquality(prevOperation, assumeTrue, sign, left, right);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(93);
                }
                return jSTypeOperation;
            }
            if (JSControlFlowTypeGuard.shouldNarrowIndexerByConstructor(left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByConstructor(prevOperation, assumeTrue, sign, right, left);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(94);
                }
                return jSTypeOperation;
            }
            if (JSControlFlowTypeGuard.shouldNarrowIndexerByConstructor(right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByConstructor(prevOperation, assumeTrue, sign, left, right);
                if (jSTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(95);
                }
                return jSTypeOperation;
            }
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(96);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected abstract JSTypeOperation createNarrowTypeByInKeywordOperation(@NotNull JSTypeOperation var1, @NotNull PsiElement var2, @NotNull String var3, boolean var4);

    @NotNull
    protected JSTypeOperation narrowTypeByDiscriminantEquality(@NotNull JSTypeOperation prev, boolean assumeTrue, IElementType sign, JSExpression toCheck, JSExpression expression) {
        String propertyName;
        JSTypeOperation byConstructor;
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(97);
        }
        if ((byConstructor = this.narrowTypeByConstructor(prev, assumeTrue, sign, toCheck, expression)) != prev) {
            JSTypeOperation jSTypeOperation = byConstructor;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(98);
            }
            return jSTypeOperation;
        }
        if (toCheck == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(99);
            }
            return jSTypeOperation;
        }
        String string = expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceName() : (propertyName = expression instanceof JSElvisOwner ? "_$_$ELVIS$_$_" : null);
        if (StringUtil.isEmpty((String)propertyName)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(100);
            }
            return jSTypeOperation;
        }
        return new TypeScriptNarrowTypeByDiscriminantEqualityOperation(prev, sign, toCheck, propertyName, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue, JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)expression));
    }

    @NotNull
    protected JSTypeOperation narrowTypeByConstructor(@NotNull JSTypeOperation prev, boolean assumeTrue, IElementType sign, JSExpression toCheck, JSExpression expression) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(101);
        }
        if (toCheck == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(102);
            }
            return jSTypeOperation;
        }
        boolean isNegativeSign = JSTypeGuardChecker.isNegativeSign(sign);
        if (!isNegativeSign && assumeTrue && JSControlFlowTypeGuard.shouldNarrowIndexerByConstructor(expression)) {
            return new TypeScriptNarrowTypeByConstructorOperation(prev, toCheck, true);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(103);
            }
            return jSTypeOperation;
        }
        String propertyName = ((JSReferenceExpression)expression).getReferenceName();
        if (StringUtil.isEmpty((String)propertyName)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(104);
            }
            return jSTypeOperation;
        }
        if ("constructor".equals(propertyName) && !isNegativeSign && assumeTrue) {
            return new TypeScriptNarrowTypeByConstructorOperation(prev, toCheck, true);
        }
        JSTypeOperation jSTypeOperation = prev;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(105);
        }
        return jSTypeOperation;
    }

    private static boolean shouldNarrowIndexerByConstructor(JSExpression expression) {
        JSExpression indexExpression;
        return expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral() && "constructor".equals(((JSLiteralExpression)indexExpression).getStringValue());
    }

    @NotNull
    protected JSTypeOperation narrowTypeByTypeof(@NotNull JSTypeOperation prevOperation, @NotNull JSPrefixExpression typeOfExpr, @NotNull IElementType sign, @NotNull JSLiteralExpression literal, boolean assumeTrue) {
        JSExpression target;
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(106);
        }
        if (typeOfExpr == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(107);
        }
        if (sign == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(108);
        }
        if (literal == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(109);
        }
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)(target = JSTypeGuardUtil.getReferenceCandidate(typeOfExpr.getExpression())))) {
            return this.createElvisNarrowingIfNeeded(prevOperation, sign, (JSExpression)literal, assumeTrue, target);
        }
        String value = literal.getStringValue();
        if (StringUtil.isEmpty((String)value)) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(110);
            }
            return jSTypeOperation;
        }
        return new JSNarrowTypeByTypeofOperation(prevOperation, value, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue);
    }

    @NotNull
    private JSTypeOperation createElvisNarrowingIfNeeded(@NotNull JSTypeOperation prevOperation, @NotNull IElementType sign, @NotNull JSExpression source, boolean assumeTrue, @Nullable JSExpression target) {
        JSExpression qualifier;
        if (prevOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(111);
        }
        if (sign == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(112);
        }
        if (source == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(113);
        }
        JSTypeOperation result2 = prevOperation;
        if (assumeTrue && target instanceof JSElvisOwner && JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)target) && (qualifier = JSControlFlowTypeGuard.getElvisQualifierForNarrowing((PsiElement)target)) != null && this.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier)) {
            result2 = new TypeScriptNarrowTypeByDiscriminantEqualityOperation(prevOperation, sign, source, "_$_$ELVIS$_$_", true, true);
        }
        JSTypeOperation jSTypeOperation = result2;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(114);
        }
        return jSTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowAssignment(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction, @NotNull ReadWriteAccessDetector.Access access) {
        PsiElement element;
        JSElement referenceExpressionCandidate;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(115);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(116);
        }
        if (access == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(117);
        }
        if ((referenceExpressionCandidate = JSControlFlowTypeGuard.getAssignTarget(element = currentInstruction.getElement())) == null) {
            return null;
        }
        if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)referenceExpressionCandidate)) {
            JSVarStatement statement;
            PsiElement parent;
            boolean isDeclarationPlace = element instanceof JSFieldVariable;
            JSExpression initializer = JSTypeGuardUtil.getInitializerExpression(element);
            if (initializer == null && isDeclarationPlace && (parent = JSResolveUtil.findParent(element)) instanceof JSForInStatement && (statement = ((JSForInStatement)parent).getVarDeclaration()) == element.getParent()) {
                return JSDeclaredTypeOperation.DECLARED_TYPE;
            }
            boolean allowsReDeclaration = !(element instanceof JSField) && element instanceof JSVariable && !((JSVariable)element).hasBlockScope();
            JSTypeOperation prevType = this.getPrevInAssignment(flow, currentInstruction, (PsiElement)initializer, isDeclarationPlace, allowsReDeclaration);
            return prevType == JSEmptyOperation.NO_OPERATION || element instanceof JSVariable && JSDestructuringUtil.isDestructuring(element.getParent()) && ((JSVariable)element).getInitializer() == initializer ? prevType : this.createNarrowTypeByAssigmentOperation(prevType, element, access, initializer, isDeclarationPlace);
        }
        if (this.containsMatchingReference((PsiElement)this.myReference, element)) {
            return JSDeclaredTypeOperation.DECLARED_TYPE;
        }
        return null;
    }

    @NotNull
    private JSTypeOperation getPrevInAssignment(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction, @Nullable PsiElement initializer, boolean isDeclarationPlace, boolean allowsReDeclaration) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(118);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(119);
        }
        if (currentInstruction.getAccess() == ReadWriteAccessDetector.Access.ReadWrite) {
            return this.getPrevFlowType(flow, (Instruction)currentInstruction);
        }
        if (isDeclarationPlace && !allowsReDeclaration || initializer != null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(120);
            }
            return jSDeclaredTypeOperation;
        }
        return this.getPrevFlowType(flow, (Instruction)currentInstruction);
    }

    @NotNull
    protected JSTypeOperation createNarrowTypeByAssigmentOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement element, @NotNull ReadWriteAccessDetector.Access access, @Nullable JSExpression initializer, boolean isDeclarationPlace) {
        if (prev == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(121);
        }
        if (element == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(122);
        }
        if (access == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(123);
        }
        return new TypeScriptNarrowTypeByAssignmentOperation(prev, element, access, initializer, isDeclarationPlace);
    }

    @NotNull
    protected JSTypeOperation getTypeAtParentScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(124);
        }
        ArrayList<PsiElement> candidateParents = new ArrayList<PsiElement>();
        JSElement cfScope = null;
        for (PsiElement parent = scope.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JSClass) {
                JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
                if (jSDeclaredTypeOperation == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(125);
                }
                return jSDeclaredTypeOperation;
            }
            if (parent instanceof JSElement && JSControlFlowService.isControlFlowScope(parent)) {
                cfScope = (JSElement)parent;
                break;
            }
            candidateParents.add(parent);
        }
        if (cfScope == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(126);
            }
            return jSDeclaredTypeOperation;
        }
        JSControlFlowService.JSControlFlow flowScope = this.getControlFlowScope(cfScope);
        if (flowScope == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(127);
            }
            return jSDeclaredTypeOperation;
        }
        Instruction[] instructions = flowScope.getInstructions();
        for (PsiElement candidateScope : candidateParents) {
            int numberByElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)candidateScope);
            if (numberByElement == -1) continue;
            return this.getTypeAtFlowNode(flowScope, instructions[numberByElement]);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(128);
        }
        return jSDeclaredTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowArrayMutation(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSModificationInstruction instruction) {
        JSDefinitionExpression definitionExpression;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(129);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(130);
        }
        if (!this.myIsTypeScript || !this.myPossibleAutoType) {
            return null;
        }
        JSExpression expression = instruction.getExpression();
        JSExpression toProcess = JSControlFlowTypeGuard.getExpressionForArrayMutation(expression);
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)JSTypeGuardUtil.getReferenceCandidate(toProcess))) {
            return null;
        }
        JSTypeOperation prevType = this.getPrevFlowType(flow, instruction);
        PsiElement element = instruction.getElement();
        if (element == null) {
            return prevType;
        }
        if (element instanceof JSCallExpression) {
            return new JSNarrowTypeByArrayMutationOperation(prevType, (JSCallExpression)element, null, null);
        }
        if (element instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression()) != null) {
            JSExpression indexExpression;
            JSExpression elExpression = definitionExpression.getExpression();
            JSExpression initializer = definitionExpression.getInitializer();
            if (elExpression instanceof JSIndexedPropertyAccessExpression && initializer != null && (indexExpression = ((JSIndexedPropertyAccessExpression)elExpression).getIndexExpression()) != null) {
                return new JSNarrowTypeByArrayMutationOperation(prevType, null, indexExpression, initializer);
            }
        }
        return prevType;
    }

    @Nullable
    private static JSExpression getExpressionForArrayMutation(@NotNull JSExpression expression) {
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(131);
        }
        if (expression instanceof JSReferenceExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof JSIndexedPropertyAccessExpression) {
                return expression;
            }
            return ((JSReferenceExpression)expression).getQualifier();
        }
        return null;
    }

    @NotNull
    private JSTypeOperation getTypeAtCaseBlock(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSCaseBlockInstruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(132);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(133);
        }
        JSTypeOperation prevType = this.getPrevFlowType(flow, (Instruction)instruction);
        JSCaseBlockInstruction startBlock = instruction.getStartBlock();
        JSSwitchStatement statement = instruction.getSwitchStatement();
        if (statement == null) {
            JSTypeOperation jSTypeOperation = prevType;
            if (jSTypeOperation == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(134);
            }
            return jSTypeOperation;
        }
        return this.getTypeAtSwitchClause(prevType, statement, startBlock.getIndex(), instruction.getIndex());
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowCondition(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSConditionInstruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(135);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(136);
        }
        JSTypeOperation prevType = this.getPrevFlowType(flow, (Instruction)instruction);
        boolean assumeTrue = instruction.getValue();
        PsiElement element = instruction.getElement();
        if (element instanceof JSExpression) {
            return this.narrowTypeOperation(prevType, (JSExpression)element, assumeTrue);
        }
        JSTypeOperation jSTypeOperation = prevType;
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(137);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getTypeAtCallAssertion(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSCallInstruction instruction, @NotNull JSCallExpression expression) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(138);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(139);
        }
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(140);
        }
        JSTypeOperation jSTypeOperation = this.narrowByCallExpression(this.getPrevFlowType(flow, (Instruction)instruction), expression, true, true);
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(141);
        }
        return jSTypeOperation;
    }

    private static boolean isSuitableCallForAssertion(@NotNull JSCallExpression element) {
        PsiElement parent;
        if (element == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(142);
        }
        if (!((parent = element.getParent()) instanceof JSExpressionStatement) || ((JSExpressionStatement)parent).getExpression() != element) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getMethodExpression(), JSReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        while (referenceExpression != null) {
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            referenceExpression = (JSReferenceExpression)qualifier;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private JSTypeOperation getPrevFlowType(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(143);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(144);
        }
        int depth = this.myDepth.incrementAndGet();
        if (depth > 100) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            JSDeclaredTypeOperation jSDeclaredTypeOperation2 = jSDeclaredTypeOperation;
            if (jSDeclaredTypeOperation2 == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(145);
            }
            return jSDeclaredTypeOperation2;
        }
        Collection instructions = instruction.allPred();
        int size = instructions.size();
        if (size == 1) {
            JSTypeOperation jSTypeOperation = this.getTypeAtFlowNode(flow, (Instruction)instructions.iterator().next());
            JSTypeOperation jSTypeOperation2 = jSTypeOperation;
            if (jSTypeOperation2 == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(146);
            }
            return jSTypeOperation2;
        }
        JSTypeOperation jSTypeOperation = this.getPrevFlowTypeForInstructions(flow, instructions);
        JSTypeOperation jSTypeOperation3 = jSTypeOperation;
        if (jSTypeOperation3 == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(147);
        }
        return jSTypeOperation3;
        finally {
            this.myDepth.decrementAndGet();
        }
    }

    @NotNull
    private JSTypeOperation getPrevFlowTypeForInstructions(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> instructions) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(148);
        }
        if (instructions == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(149);
        }
        LinkedHashSet<JSTypeOperation> result2 = new LinkedHashSet<JSTypeOperation>();
        boolean hasNoOperation = false;
        for (Instruction prevInstructions : instructions) {
            boolean isUnreachable = JSControlFlowTypeGuard.isUnreachableInstruction(flow, prevInstructions);
            if (isUnreachable) continue;
            JSTypeOperation currentOperation = this.getTypeAtFlowNode(flow, prevInstructions);
            JSCompositeOperation.addFlat(result2, currentOperation, JSMergeOperation.class);
            hasNoOperation |= currentOperation == JSEmptyOperation.NO_OPERATION;
        }
        JSTypeOperation jSTypeOperation = JSMergeOperation.create(result2, hasNoOperation ? JSEmptyOperation.NO_OPERATION : JSDeclaredTypeOperation.DECLARED_TYPE);
        if (jSTypeOperation == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(150);
        }
        return jSTypeOperation;
    }

    private static boolean isUnreachableInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction prevInstructions) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(151);
        }
        if (prevInstructions == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(152);
        }
        return flow.isCFUnreachable(prevInstructions) || prevInstructions instanceof JSInstructionWithReachability && !((JSInstructionWithReachability)prevInstructions).isReachable();
    }

    @Contract(value="null -> null")
    private static JSElement getAssignTarget(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getExpression();
        }
        if (element instanceof JSParameter) {
            return null;
        }
        if (element instanceof JSVariable) {
            return (JSVariable)element;
        }
        if (element instanceof JSForInStatement) {
            return JSUtils.unparenthesize(((JSForInStatement)element).getVariableExpression());
        }
        if (element instanceof JSReferenceExpression && JSDestructuringUtil.hasDestructuringAssignment(element)) {
            return (JSElement)element;
        }
        return null;
    }

    @NotNull
    static String getFirstQualifierName(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(153);
        }
        JSExpression qualifier = expression.getQualifier();
        while (qualifier instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier;
            qualifier = expression.getQualifier();
        }
        return qualifier == null ? StringUtil.notNullize((String)expression.getReferenceName()) : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 110: 
            case 114: 
            case 120: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 137: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 150: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 110: 
            case 114: 
            case 120: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 137: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 150: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 6: 
            case 43: 
            case 71: 
            case 78: 
            case 80: 
            case 82: 
            case 131: 
            case 140: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 110: 
            case 114: 
            case 120: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 137: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 115: 
            case 118: 
            case 129: 
            case 132: 
            case 135: 
            case 138: 
            case 143: 
            case 148: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 19: 
            case 38: 
            case 40: 
            case 116: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 130: 
            case 133: 
            case 136: 
            case 139: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularPreds";
                break;
            }
            case 41: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 97: 
            case 101: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 42: 
            case 52: 
            case 108: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 44: 
            case 48: 
            case 53: 
            case 57: 
            case 65: 
            case 81: 
            case 106: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevOperation";
                break;
            }
            case 45: 
            case 49: 
            case 54: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfExpr";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 117: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 122: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLeftExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedTypeOperations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNode";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtLoop";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPredTypes";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByAnd";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByOr";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByInstanceof";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtSwitchClause";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowByCallExpression";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeOperation";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createNarrowTypeByDiscriminantTruthinessOperation";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTruthiness";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByBinaryExpression";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByConstructor";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTypeof";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createElvisNarrowingIfNeeded";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevInAssignment";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtParentScope";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCaseBlock";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowCondition";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCallAssertion";
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowType";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowTypeForInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTopLeftExpression";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 110: 
            case 114: 
            case 120: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 137: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 150: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetDecoratorsOnAssignments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayOperationTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkUseAutoTypeFromConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowInstruction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStartControlFlowScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFinalScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFinalFunctionScope";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralOrClassExpressionMethod";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtLoop";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRegularPredTypes";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowReadWrite";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowRead";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByEquality";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByAnd";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByOr";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceDiscriminantByEqualityCandidate";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByInstanceof";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtSwitchClause";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "narrowByCallExpression";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeOperation";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByTruthinessOperation";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByDiscriminantTruthinessOperation";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTruthiness";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getElvisQualifierForNarrowing";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceForVariable";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByBinaryExpression";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByConstructor";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypeof";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createElvisNarrowingIfNeeded";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowAssignment";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getPrevInAssignment";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByAssigmentOperation";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtParentScope";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowArrayMutation";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionForArrayMutation";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCaseBlock";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowCondition";
                break;
            }
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCallAssertion";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableCallForAssertion";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowType";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowTypeForInstructions";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInstruction";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 110: 
            case 114: 
            case 120: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 137: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 150: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

