/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6RedundantNestingInTemplateLiteralInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.inline.InjectionQuoteHandler;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSFunctionInliner
extends JSInlineHandler.Inliner {
    @NotNull
    private final JSFunction myFunction;
    private final Set<String> myNonfinalParameters;
    private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfoForCall;

    JSFunctionInliner(@NotNull PsiElement declaration, @NotNull JSFunction function2) {
        if (declaration == null) {
            JSFunctionInliner.$$$reportNull$$$0(0);
        }
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(1);
        }
        super(declaration);
        this.myFunction = function2;
        JSElement body = JSPsiImplUtils.getFunctionBody(function2);
        this.myNonfinalParameters = JSFunctionInliner.getNonFinalParameters(function2);
        this.myReferenceExpressionsInfoForCall = body != null ? ES6ReferenceExpressionsInfo.getInfo((PsiElement)body) : ES6ReferenceExpressionsInfo.EMPTY;
    }

    @Override
    @Nullable
    PsiElement doInlineUsage(@NotNull JSReferenceExpression referenceExpression) {
        JSExpression expression;
        JSCallExpression callExpression;
        boolean shouldReplaceWithFunctionExpression;
        if (referenceExpression == null) {
            JSFunctionInliner.$$$reportNull$$$0(2);
        }
        boolean bl = shouldReplaceWithFunctionExpression = (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)referenceExpression.getParent(), JSCallExpression.class)) == null || this.myFunction.isAsync() && !ES6PsiUtil.isAsyncFunction((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSFunction.class));
        if (shouldReplaceWithFunctionExpression) {
            JSExpression thisExpression = this.myFunction.isArrowFunction() ? referenceExpression.getQualifier() : null;
            JSFunction replacement = JSFunctionInliner.buildReplacementFunction(this.myFunction, (JSExpression)referenceExpression, Collections.emptyMap(), ContainerUtil.emptyList(), thisExpression, false);
            if (replacement == null) {
                return null;
            }
            JSExpression replacementFunctionExpression = this.modifyIfAccessor(replacement instanceof JSFunctionExpression ? (JSFunctionExpression)replacement.copy() : JSFunctionsRefactoringUtil.createAnonymousFunctionExpression(replacement));
            if (referenceExpression.getParent() instanceof ES6Property && ((ES6Property)referenceExpression.getParent()).isShorthanded()) {
                String propertyValueText = replacementFunctionExpression.getText();
                return ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)((ES6Property)referenceExpression.getParent()), propertyValueText);
            }
            return JSChangeUtil.replaceExpression((JSExpression)referenceExpression, replacementFunctionExpression);
        }
        JSElement[] replacement = this.calculateReplacementForCall(this.myFunction, callExpression);
        PsiElement usageParent = callExpression.getParent();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSStatement.class);
        assert (statement != null);
        if (usageParent instanceof JSFunctionExpression && ((JSFunctionExpression)usageParent).isShorthandArrowFunction() && this.shouldExpandTargetBody() && (expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)usageParent)) == callExpression) {
            JSRefactoringUtil.addBracesToShorthandArrowFunction((JSFunctionExpression)usageParent);
            statement = (JSStatement)((JSFunctionExpression)usageParent).getBlock().getStatementListItems()[0];
            usageParent = statement;
            if (statement instanceof JSExpressionStatement) {
                callExpression = (JSCallExpression)((JSExpressionStatement)statement).getExpression();
            } else if (statement instanceof JSReturnStatement) {
                callExpression = (JSCallExpression)((JSReturnStatement)statement).getExpression();
            }
            assert (callExpression != null) : "call expression is null for " + statement.getClass().getName();
        }
        if (!(usageParent instanceof JSExpressionStatement) && replacement.length > 0 && (expression = JSFunctionInliner.tryGetSingleExpression(replacement[replacement.length - 1])) != null) {
            if (replacement.length > 1) {
                JSFunctionInliner.addStatementRangeWithComments(statement, replacement, replacement.length - 2);
            }
            return JSFunctionInliner.performExpressionReplacement((JSExpression)callExpression, expression);
        }
        if (replacement.length > 0) {
            PsiElement result2 = JSFunctionInliner.addStatementRangeWithComments(statement, replacement, replacement.length - 1);
            statement.delete();
            return result2;
        }
        JSInlineHandler.deleteElementWithReformat((PsiElement)statement);
        return null;
    }

    private boolean shouldExpandTargetBody() {
        if (this.myFunction.isShorthandArrowFunction()) {
            return false;
        }
        JSBlockStatement block = this.myFunction.getBlock();
        return block == null || block.getStatementListItems().length != 1;
    }

    private JSExpression modifyIfAccessor(JSFunctionExpression replacementFunctionExpression) {
        JSExpression expression;
        JSSourceElement[] items;
        if (!this.myFunction.isGetProperty()) {
            return replacementFunctionExpression;
        }
        JSBlockStatement block = replacementFunctionExpression.getBlock();
        if (block != null && (items = block.getStatementListItems()).length == 1 && items[0] instanceof JSReturnStatement && (expression = ((JSReturnStatement)items[0]).getExpression()) != null) {
            return expression;
        }
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)replacementFunctionExpression);
        if (returnExpression != null) {
            return returnExpression;
        }
        if (DialectDetector.hasFeature((PsiElement)this.myFunction, JSLanguageFeature.ARROW_FUNCTIONS)) {
            return JSPsiElementFactory.createJSExpression("(" + replacementFunctionExpression.getParameterList().getText() + " => " + JSPsiImplUtils.getFunctionBody((JSFunction)replacementFunctionExpression).getText() + ")()", (PsiElement)this.myFunction);
        }
        return JSPsiElementFactory.createJSExpression("(" + replacementFunctionExpression.getText() + ")()", (PsiElement)this.myFunction);
    }

    @Nullable
    private static PsiElement addStatementRangeWithComments(@NotNull JSStatement anchorBefore, JSElement @NotNull [] replacement, int endIndex) {
        if (anchorBefore == null) {
            JSFunctionInliner.$$$reportNull$$$0(3);
        }
        if (replacement == null) {
            JSFunctionInliner.$$$reportNull$$$0(4);
        }
        PsiElement first = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)replacement[0], PsiComment.class), (Object)replacement[0]);
        PsiElement last = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)replacement[endIndex], PsiComment.class), (Object)replacement[endIndex]);
        return SharedImplUtil.addRange((PsiElement)anchorBefore.getParent(), (PsiElement)first, (PsiElement)last, (ASTNode)anchorBefore.getNode(), (Boolean)Boolean.TRUE);
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        ASTNode prev;
        PsiElement whitespace;
        if (element == null) {
            JSFunctionInliner.$$$reportNull$$$0(5);
        }
        if (element instanceof JSFunction && element.getParent() instanceof JSClass && (whitespace = (prev = element.getNode().getTreePrev()).getPsi()) instanceof PsiWhiteSpace) {
            whitespace.delete();
        }
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> result2 = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element);
            result2.add((TypeScriptFunction)element);
            List toRemove = result2.stream().sorted(Comparator.comparing(function2 -> function2.getTextRange().getStartOffset())).map(function2 -> {
                PsiElement parent = function2.getParent();
                return parent instanceof ES6ExportDefaultAssignment ? (ES6ExportDefaultAssignment)parent : function2;
            }).collect(Collectors.toList());
            JSInlineHandler.deleteSourceElementRange((JSSourceElement)toRemove.get(0), (JSSourceElement)toRemove.get(toRemove.size() - 1));
        } else if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            JSInlineHandler.deleteElementWithReformat(element.getParent());
        } else {
            JSInlineHandler.deleteElementWithReformat(element);
        }
    }

    private JSElement @NotNull [] calculateReplacementForCall(@NotNull JSFunction referenced, @NotNull JSCallExpression callExpr) {
        JSSourceElement[] statements;
        if (referenced == null) {
            JSFunctionInliner.$$$reportNull$$$0(6);
        }
        if (callExpr == null) {
            JSFunctionInliner.$$$reportNull$$$0(7);
        }
        JSExpression[] expressions = callExpr.getArguments();
        int currentActualIndex = 0;
        Collection<String> namesInScope = JSFunctionInliner.collectNamesInScope((PsiElement)callExpr);
        THashMap parametersToActual = new THashMap();
        ArrayList<String> initializers = new ArrayList<String>();
        for (JSParameterListElement p : referenced.getParameters()) {
            JSExpression actual = (JSExpression)ObjectUtils.coalesce((Object)(currentActualIndex < expressions.length ? expressions[currentActualIndex] : null), (Object)p.getInitializer());
            Map<String, Object> map = JSFunctionInliner.tryMatchParametersToActual(p, actual);
            if (map != null && ContainerUtil.all(map.keySet(), s -> !this.myNonfinalParameters.contains(s))) {
                parametersToActual.putAll(map);
            } else {
                JSParameterListElement declaration = JSFunctionInliner.ensureUniqueNamesForDeclaration(p, namesInScope, (Map<String, Object>)parametersToActual);
                initializers.add(JSFunctionInliner.getVarStatementText((PsiElement)callExpr, declaration, actual));
            }
            ++currentActualIndex;
        }
        PsiElement usageParent = callExpr.getParent();
        boolean isExpressionStatement = usageParent instanceof JSExpressionStatement;
        JSExpression thisExpression = ((JSReferenceExpression)callExpr.getMethodExpression()).getQualifier();
        JSFunction replacementFun = JSFunctionInliner.buildReplacementFunction(referenced, (JSExpression)callExpr, (Map<String, Object>)parametersToActual, namesInScope, thisExpression, isExpressionStatement);
        if (replacementFun == null) {
            if (JSElement.EMPTY_ARRAY == null) {
                JSFunctionInliner.$$$reportNull$$$0(8);
            }
            return JSElement.EMPTY_ARRAY;
        }
        JSExpression arrowReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(replacementFun);
        if (arrowReturnExpression != null) {
            JSElement[] jSElementArray = new JSElement[]{arrowReturnExpression};
            if (jSElementArray == null) {
                JSFunctionInliner.$$$reportNull$$$0(9);
            }
            return jSElementArray;
        }
        JSBlockStatement body = replacementFun.getBlock();
        JSSourceElement[] jSSourceElementArray = statements = body != null ? body.getStatementListItems() : JSSourceElement.EMPTY_ARRAY;
        if (body == null || statements.length == 0) {
            if (JSElement.EMPTY_ARRAY == null) {
                JSFunctionInliner.$$$reportNull$$$0(10);
            }
            return JSElement.EMPTY_ARRAY;
        }
        JSSourceElement anchor = statements[0];
        boolean addBefore = true;
        for (String statement : initializers) {
            JSVarStatement varStatement = JSPsiElementFactory.createJSStatement(statement, (PsiElement)callExpr, JSVarStatement.class);
            anchor = addBefore ? JSChangeUtil.doAddBefore(anchor.getParent(), (PsiElement)varStatement, (PsiElement)anchor) : JSChangeUtil.doAddAfter(anchor.getParent(), (PsiElement)varStatement, (PsiElement)anchor);
            addBefore = false;
        }
        JSSourceElement[] jSSourceElementArray2 = body.getStatementListItems();
        if (jSSourceElementArray2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(11);
        }
        return jSSourceElementArray2;
    }

    @Nullable
    private static JSExpression tryGetSingleExpression(@NotNull JSElement statement) {
        if (statement == null) {
            JSFunctionInliner.$$$reportNull$$$0(12);
        }
        if (statement instanceof JSExpression) {
            return (JSExpression)statement;
        }
        if (statement instanceof JSExpressionStatement) {
            return ((JSExpressionStatement)statement).getExpression();
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)statement).getExpression();
        }
        return null;
    }

    @NotNull
    private static JSParameterListElement ensureUniqueNamesForDeclaration(@NotNull JSParameterListElement parameterListElement, @NotNull Collection<String> namesInScope, @NotNull Map<String, Object> parametersToActualMap) {
        if (parameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(13);
        }
        if (namesInScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(14);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(15);
        }
        JSParameterListElement copy = (JSParameterListElement)parameterListElement.copy();
        PsiTreeUtil.processElements((PsiElement)copy, element -> {
            String newName;
            JSParameter parameter;
            String parameterName;
            if (element instanceof JSParameter && (parameterName = (parameter = (JSParameter)element).getName()) != null && !StringUtil.equals((CharSequence)parameterName, (CharSequence)(newName = JSNameSuggestionsUtil.ensureUniqueVariableName(parameterName, null, namesInScope, true)))) {
                if (parameter.getParent() instanceof JSDestructuringShorthandedProperty) {
                    JSDestructuringShorthandedProperty property = (JSDestructuringShorthandedProperty)parameter.getParent();
                    property.replace((PsiElement)ES6ChangeUtil.expandDestructuringPropertyWithVariableName(property, newName));
                } else {
                    parameter.setName(newName);
                }
                parametersToActualMap.put(parameterName, newName);
            }
            return true;
        });
        JSParameterListElement jSParameterListElement = copy;
        if (jSParameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(16);
        }
        return jSParameterListElement;
    }

    @Nullable
    private static JSFunction buildReplacementFunction(@NotNull JSFunction referenced, @NotNull JSExpression context, @NotNull Map<String, Object> parametersToActualMap, @NotNull Collection<String> namesInCallScope, @Nullable JSExpression thisExpression, boolean replaceReturnStatements) {
        if (referenced == null) {
            JSFunctionInliner.$$$reportNull$$$0(17);
        }
        if (context == null) {
            JSFunctionInliner.$$$reportNull$$$0(18);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(19);
        }
        if (namesInCallScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(20);
        }
        String replacementText = JSFunctionInliner.buildReplacement((JSNamedElement)referenced, (PsiElement)referenced, context, parametersToActualMap, namesInCallScope, thisExpression, replaceReturnStatements);
        if (JSUtils.getMemberContainingClass((PsiElement)referenced) != null) {
            return JSChangeUtil.createClassMemberPsiFromTextWithContext(replacementText, (PsiElement)referenced, JSFunction.class);
        }
        if (referenced instanceof JSFunctionProperty) {
            return (JSFunction)JSChangeUtil.createObjectLiteralPropertyFromText(replacementText, (PsiElement)referenced);
        }
        ASTNode functionNode = JSChangeUtil.createJSTreeFromTextWithContext(replacementText, (PsiElement)referenced);
        if (functionNode != null && functionNode.getPsi() instanceof JSExpressionStatement) {
            return (JSFunctionExpression)((JSExpressionStatement)functionNode.getPsi()).getExpression();
        }
        return (JSFunction)functionNode.getPsi();
    }

    static String buildReplacement(final @NotNull JSNamedElement referencedDeclaration, @NotNull PsiElement elementToUpdate, @NotNull JSExpression usageContext, @NotNull Map<String, Object> parametersToActualMap, final @NotNull Collection<String> namesInCallScope, @Nullable JSExpression thisExpression, boolean replaceReturnStatements) {
        if (referencedDeclaration == null) {
            JSFunctionInliner.$$$reportNull$$$0(21);
        }
        if (elementToUpdate == null) {
            JSFunctionInliner.$$$reportNull$$$0(22);
        }
        if (usageContext == null) {
            JSFunctionInliner.$$$reportNull$$$0(23);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(24);
        }
        if (namesInCallScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(25);
        }
        final String thisValue = thisExpression != null ? thisExpression.getText() : null;
        int funOffset = -elementToUpdate.getTextRange().getStartOffset();
        DocumentImpl document2 = new DocumentImpl(elementToUpdate.getText());
        THashMap parameterRefs = new THashMap();
        THashMap markersToParametersMap = new THashMap();
        final HashMap simpleReplacements = new HashMap();
        InjectionQuoteHandler injectionQuoteHandler = new InjectionQuoteHandler((PsiElement)usageContext);
        final THashMap declarationsToRename = new THashMap();
        elementToUpdate.accept((PsiElementVisitor)new JSRecursiveElementVisitor((Map)markersToParametersMap, (Map)parameterRefs, replaceReturnStatements, (Document)document2, funOffset){
            final /* synthetic */ Map val$markersToParametersMap;
            final /* synthetic */ Map val$parameterRefs;
            final /* synthetic */ boolean val$replaceReturnStatements;
            final /* synthetic */ Document val$document;
            final /* synthetic */ int val$funOffset;
            {
                this.val$markersToParametersMap = map2;
                this.val$parameterRefs = map3;
                this.val$replaceReturnStatements = bl;
                this.val$document = document2;
                this.val$funOffset = n;
            }

            public void visitJSElement(JSElement node) {
                super.visitJSElement(node);
                if ((node instanceof JSVariable || node instanceof JSClass || node instanceof JSFunction) && node != referencedDeclaration && JSUseScopeProvider.getLexicalScope((PsiElement)node) == referencedDeclaration) {
                    String name = ((JSNamedElement)node).getName();
                    PsiElement identifier = ((JSQualifiedNamedElement)node).getNameIdentifier();
                    if (StringUtil.isNotEmpty((String)name) && identifier != null && namesInCallScope.contains(name)) {
                        String newName = JSNameSuggestionsUtil.ensureUniqueVariableName(name, null, namesInCallScope, true);
                        declarationsToRename.put((Object)node, (Object)newName);
                        simpleReplacements.put(this.createRangeMarkerToReplace(identifier), newName);
                    }
                }
            }

            public void visitJSThisExpression(JSThisExpression node) {
                super.visitJSThisExpression(node);
                if ((this.isFunctionToInline((JSElement)node) || node.resolve() == JSUtils.getMemberContainingClass((PsiElement)referencedDeclaration)) && thisValue != null) {
                    simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), thisValue);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSExpression qualifier = node.getQualifier();
                if (qualifier == null) {
                    PsiElement nodeTarget = node.resolve();
                    if (nodeTarget instanceof JSParameter) {
                        JSParameter parameter = (JSParameter)nodeTarget;
                        if (parameter.getName() != null && parameter.getDeclaringFunction() == referencedDeclaration) {
                            RangeMarker rangeMarker = this.createRangeMarkerToReplace((PsiElement)node);
                            this.val$markersToParametersMap.put(rangeMarker, parameter.getName());
                            this.val$parameterRefs.put(node, rangeMarker);
                        }
                    } else if (node.getParent() != nodeTarget && nodeTarget != null) {
                        JSClass containingClass = JSUtils.getMemberContainingClass(nodeTarget);
                        if ((nodeTarget instanceof JSFunction || nodeTarget instanceof JSVariable) && containingClass != null && !JSResolveUtil.isConstructorFunction(nodeTarget)) {
                            boolean isStatic = JSPsiImplUtils.hasModifier((JSAttributeListOwner)nodeTarget, JSAttributeList.ModifierType.STATIC);
                            if (isStatic) {
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), containingClass.getName() + "." + node.getText());
                            } else if (thisValue != null) {
                                String value = thisValue + "." + node.getText();
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), value);
                            }
                        } else {
                            String newName = (String)declarationsToRename.get((Object)nodeTarget);
                            if (newName != null) {
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), newName);
                            }
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                if (this.isFunctionToInline((JSElement)node) && this.val$replaceReturnStatements) {
                    JSExpression expression = node.getExpression();
                    if (expression != null && SideEffectChecker.mayHaveSideEffects(expression)) {
                        TextRange range = new TextRange(node.getTextRange().getStartOffset(), expression.getTextRange().getStartOffset());
                        simpleReplacements.put(this.createRangeMarkerToReplace(range), "");
                    } else {
                        simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), "");
                    }
                }
                super.visitJSReturnStatement(node);
            }

            private boolean isFunctionToInline(JSElement node) {
                return PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class) == referencedDeclaration;
            }

            private RangeMarker createRangeMarkerToReplace(@NotNull PsiElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.createRangeMarkerToReplace(node.getTextRange());
            }

            private RangeMarker createRangeMarkerToReplace(@NotNull TextRange textRange) {
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.val$document.createRangeMarker(textRange.shiftRight(this.val$funOffset));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRange";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner$1";
                objectArray[2] = "createRangeMarkerToReplace";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        injectionQuoteHandler.fixQuotes(elementToUpdate, funOffset, (Document)document2);
        for (Map.Entry pair : parameterRefs.entrySet()) {
            JSReferenceExpression parameterUsage = (JSReferenceExpression)pair.getKey();
            RangeMarker rangeMarker = (RangeMarker)pair.getValue();
            String parameter = (String)markersToParametersMap.get(rangeMarker);
            Object actual = parametersToActualMap.get(parameter);
            if (actual == null) continue;
            String expressionText = actual instanceof JSExpression ? ((JSExpression)actual).getText() : actual.toString();
            String introducedString = actual instanceof JSExpression && JSParenthesesUtils.needsParenthesis((JSExpression)parameterUsage, (JSExpression)actual) ? "(" + expressionText + ")" : expressionText;
            ES6Property property = (ES6Property)ObjectUtils.tryCast((Object)parameterUsage.getParent(), ES6Property.class);
            introducedString = property != null && property.isShorthanded() && !StringUtil.equals((CharSequence)property.getName(), (CharSequence)introducedString) ? String.format("%s: %s", property.getName(), introducedString) : introducedString;
            document2.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)introducedString);
        }
        for (Map.Entry entry : simpleReplacements.entrySet()) {
            RangeMarker marker = (RangeMarker)entry.getKey();
            document2.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)entry.getValue());
        }
        return document2.getText();
    }

    @Nullable
    public static JSInlineHandler.Settings handleFunction(@NotNull JSFunction fun, @Nullable Editor editor, boolean invokedOnReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages) {
        JSBlockStatement bodyBlock;
        if (fun == null) {
            JSFunctionInliner.$$$reportNull$$$0(26);
        }
        Project project = fun.getProject();
        if (JSProjectUtil.isInLibrary(fun.getContainingFile())) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.function.defined.in.library", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.isReferencesArguments()) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.arguments", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.ambient.function", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.getParent() instanceof JSClass && ((JSClass)fun.getParent()).isInterface()) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.interface.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        for (JSParameter p : fun.getParameterVariables()) {
            if (!p.isRest()) continue;
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.rest.parameter", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (JSInheritanceUtil.participatesInHierarchy(fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.overrided.or.overridden.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (JSFunctionInliner.isRecursive(fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.recursive.function", (Object[])new Object[0]), editor, project);
            return null;
        }
        List<JSReturnStatement> returnStatements = JSFunctionInliner.collectOwnReturns(fun);
        if (ContainerUtil.or(returnStatements, arg_0 -> JSFunctionInliner.lambda$handleFunction$4(bodyBlock = fun.getBlock(), arg_0)) && ContainerUtil.or((Iterable)((Iterable)deferredUsages.getValue()), ref -> JSFunctionInliner.isNonLastStatementInBlock(ref.getElement()))) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.function.with.multiple.returns", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (bodyBlock != null && bodyBlock.getStatementListItems().length > 1 && ContainerUtil.or(returnStatements, statement -> statement.getExpression() != null) && ContainerUtil.or((Iterable)((Iterable)deferredUsages.getValue()), ref -> {
            PsiElement parentElement = ref.getElement().getParent();
            return parentElement instanceof JSCallExpression && !(parentElement.getParent() instanceof JSExpressionStatement);
        })) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.complex.expression.evaluation", (Object[])new Object[0]), editor, project);
            return null;
        }
        for (PsiReference ref2 : (Collection)deferredUsages.getValue()) {
            PsiElement elt = ref2.getElement();
            PsiElement parent = elt.getParent();
            if (!(parent instanceof JSNewExpression)) continue;
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]), editor, project);
            return null;
        }
        return new JSInlineHandler.Settings(deferredUsages, invokedOnReference);
    }

    @Override
    @NotNull
    protected ES6ReferenceExpressionsInfo getReferenceExpressionsInfo(@NotNull PsiElement referenceElement) {
        if (referenceElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(27);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = referenceElement.getParent() instanceof JSCallExpression ? this.myReferenceExpressionsInfoForCall : super.getReferenceExpressionsInfo(referenceElement);
        if (eS6ReferenceExpressionsInfo == null) {
            JSFunctionInliner.$$$reportNull$$$0(28);
        }
        return eS6ReferenceExpressionsInfo;
    }

    static void inlineFunctionProblem(String key, @Nullable Editor editor, Project project) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)key, (String)JavaScriptBundle.message((String)"javascript.refactoring.inline.function.title", (Object[])new Object[0]), null);
    }

    @Nullable
    private static Map<String, Object> tryMatchParametersToActual(@NotNull JSParameterListElement param, @Nullable JSExpression expression) {
        LinkedHashMap<String, Object> result2;
        if (param == null) {
            JSFunctionInliner.$$$reportNull$$$0(29);
        }
        return JSFunctionInliner.tryMatchInitializerOwner((JSInitializerOwner)param, expression, result2 = new LinkedHashMap<String, Object>()) ? result2 : null;
    }

    private static boolean tryMatchDestructuringPattern(@Nullable JSDestructuringContainer target, @Nullable JSExpression expression, @NotNull Map<String, Object> result2) {
        if (result2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(30);
        }
        if (expression == null) {
            return true;
        }
        if (target instanceof JSDestructuringObject && expression instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression object = (JSObjectLiteralExpression)expression;
            for (JSDestructuringProperty property : ((JSDestructuringObject)target).getProperties()) {
                JSExpression value;
                JSInitializerOwner propertyTarget = property.getDestructuringElement();
                if (propertyTarget == null || property.isRest()) {
                    return false;
                }
                JSProperty objectProperty = object.findProperty(property.getName());
                JSExpression jSExpression = value = objectProperty != null && objectProperty.getValue() != null ? objectProperty.getValue() : null;
                if (JSFunctionInliner.tryMatchInitializerOwner(propertyTarget, value, result2)) continue;
                return false;
            }
            return true;
        }
        if (target instanceof JSDestructuringArray && expression instanceof JSArrayLiteralExpression) {
            if (((JSDestructuringArray)target).getRestElement() != null) {
                return false;
            }
            JSInitializerOwner[] destructuringElements = ((JSDestructuringArray)target).getElements();
            JSExpression[] expressions = ((JSArrayLiteralExpression)expression).getExpressions();
            for (int i = 0; i < destructuringElements.length; ++i) {
                JSExpression value;
                JSExpression jSExpression = value = i < expressions.length ? expressions[i] : null;
                if (JSFunctionInliner.tryMatchInitializerOwner(destructuringElements[i], value, result2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean tryMatchInitializerOwner(@NotNull JSInitializerOwner initializerOwner, @Nullable JSExpression actual, @NotNull Map<String, Object> result2) {
        if (initializerOwner == null) {
            JSFunctionInliner.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(32);
        }
        actual = (JSExpression)ObjectUtils.coalesce((Object)actual, (Object)initializerOwner.getInitializer());
        if (initializerOwner instanceof JSParameter) {
            ContainerUtil.putIfNotNull((Object)initializerOwner.getName(), (Object)ObjectUtils.coalesce((Object)actual, (Object)"undefined"), result2);
            return true;
        }
        if (initializerOwner instanceof JSDestructuringElement) {
            return JSFunctionInliner.tryMatchDestructuringPattern(((JSDestructuringElement)initializerOwner).getTarget(), actual, result2);
        }
        return false;
    }

    @NotNull
    private static String getVarStatementText(@NotNull PsiElement context, @NotNull JSParameterListElement parameterListElement, @Nullable JSExpression initializer) {
        if (context == null) {
            JSFunctionInliner.$$$reportNull$$$0(33);
        }
        if (parameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(34);
        }
        StringBuilder builder = new StringBuilder(JSChangeUtil.getVariablePrefix(context));
        builder.append(" ");
        builder.append(parameterListElement.getDeclarationElement().getText());
        PsiElement typeElement = parameterListElement.getTypeElement();
        if (typeElement != null) {
            builder.append(": ");
            builder.append(typeElement.getText());
        }
        if (initializer != null) {
            builder.append(" = ");
            builder.append(initializer.getText());
        }
        builder.append(JSCodeStyleSettings.getSemicolon(context)).append("\n");
        String string = builder.toString();
        if (string == null) {
            JSFunctionInliner.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static Collection<String> collectNamesInScope(@NotNull PsiElement context) {
        if (context == null) {
            JSFunctionInliner.$$$reportNull$$$0(36);
        }
        SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink(null, null));
        JSResolveUtil.treeWalkUp(processor, context, null, context);
        Set set = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.notNullize(processor.getResults()), element -> element instanceof JSNamedElement ? ((JSNamedElement)element).getName() : null);
        if (set == null) {
            JSFunctionInliner.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    private static Set<String> getNonFinalParameters(@NotNull JSFunction function2) {
        JSParameter[] variables;
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(38);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (JSParameter parameter : variables = function2.getParameterVariables()) {
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)function2)).forEach(reference -> {
                if (JSReadWriteAccessDetector.ourInstance.getReferenceAccess((PsiElement)parameter, (PsiReference)reference) != ReadWriteAccessDetector.Access.Read) {
                    String name = parameter.getName();
                    if (name != null) {
                        result2.add(name);
                    }
                    return false;
                }
                return true;
            });
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            JSFunctionInliner.$$$reportNull$$$0(39);
        }
        return linkedHashSet;
    }

    private static boolean isNonLastStatementInBlock(@NotNull PsiElement elt) {
        PsiElement parent;
        if (elt == null) {
            JSFunctionInliner.$$$reportNull$$$0(40);
        }
        if ((parent = elt.getParent()) instanceof JSCallExpression) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof JSStatement)) {
                return true;
            }
            PsiElement grandGrandParent = grandParent.getParent();
            return !(grandGrandParent instanceof JSStatement) || !ControlFlowUtils.statementCompletesWithStatement((JSStatement)grandGrandParent, (JSStatement)grandParent);
        }
        return false;
    }

    private static boolean isRecursive(@NotNull JSFunction fun) {
        if (fun == null) {
            JSFunctionInliner.$$$reportNull$$$0(41);
        }
        return !PsiTreeUtil.processElements((PsiElement)fun, element -> !(element instanceof JSReferenceExpression) || JSResolveUtil.isSelfReference((PsiElement)fun) || ((JSReferenceExpression)element).resolve() != fun);
    }

    @NotNull
    private static List<JSReturnStatement> collectOwnReturns(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(42);
        }
        final ArrayList<JSReturnStatement> returnStatements = new ArrayList<JSReturnStatement>();
        function2.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                returnStatements.add(node);
            }
        });
        ArrayList<JSReturnStatement> arrayList = returnStatements;
        if (arrayList == null) {
            JSFunctionInliner.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @Nullable
    static PsiElement performExpressionReplacement(@NotNull JSExpression source, @NotNull JSExpression replacement) {
        PsiElement parent;
        JSLiteralExpression literalExpression;
        JSExpression result2;
        if (source == null) {
            JSFunctionInliner.$$$reportNull$$$0(44);
        }
        if (replacement == null) {
            JSFunctionInliner.$$$reportNull$$$0(45);
        }
        if ((result2 = JSChangeUtil.replaceExpression(source, replacement = JSFunctionInliner.removeRedundantAwaitExpressions(replacement, source))) instanceof JSLiteralExpression && ES6RedundantNestingInTemplateLiteralInspection.canInline(literalExpression = (JSLiteralExpression)result2, parent = result2.getParent())) {
            return ES6RedundantNestingInTemplateLiteralInspection.inlineArgument(literalExpression, (JSStringTemplateExpression)parent);
        }
        return result2;
    }

    @NotNull
    private static JSExpression removeRedundantAwaitExpressions(@NotNull JSExpression toInsert, @NotNull JSExpression original) {
        PsiElement insertionParent;
        if (toInsert == null) {
            JSFunctionInliner.$$$reportNull$$$0(46);
        }
        if (original == null) {
            JSFunctionInliner.$$$reportNull$$$0(47);
        }
        if (ES6PsiUtil.isAwaitExpression(insertionParent = original.getParent())) {
            while (ES6PsiUtil.isAwaitExpression((PsiElement)toInsert)) {
                JSExpression inner = ((JSPrefixExpression)toInsert).getExpression();
                if (inner == null) {
                    JSExpression jSExpression = toInsert;
                    if (jSExpression == null) {
                        JSFunctionInliner.$$$reportNull$$$0(48);
                    }
                    return jSExpression;
                }
                toInsert = inner;
            }
        }
        JSExpression jSExpression = toInsert;
        if (jSExpression == null) {
            JSFunctionInliner.$$$reportNull$$$0(49);
        }
        return jSExpression;
    }

    private static /* synthetic */ boolean lambda$handleFunction$4(JSBlockStatement bodyBlock, JSReturnStatement statement) {
        return statement.getParent() != bodyBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 4: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesInScope";
                break;
            }
            case 15: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToActualMap";
                break;
            }
            case 18: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesInCallScope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedDeclaration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToUpdate";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageContext";
                break;
            }
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacementForCall";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUniqueNamesForDeclaration";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceExpressionsInfo";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarStatementText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamesInScope";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFinalParameters";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOwnReturns";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRedundantAwaitExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInlineUsage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addStatementRangeWithComments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementForCall";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 49: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSingleExpression";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureUniqueNamesForDeclaration";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacementFunction";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleFunction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionsInfo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchParametersToActual";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchDestructuringPattern";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchInitializerOwner";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVarStatementText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectNamesInScope";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNonFinalParameters";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isNonLastStatementInBlock";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectOwnReturns";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "performExpressionReplacement";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantAwaitExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

