/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDestructuringPropertyRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptDestructuringPropertyRenamerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof JSDestructuringProperty && DialectDetector.isTypeScript(element);
    }

    @Nls
    @Nullable
    public String getOptionName() {
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new DestructuringPropertyAutomaticRenamer(element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/rename/TypeScriptDestructuringPropertyRenamerFactory", "isApplicable"));
    }

    private static class DestructuringPropertyAutomaticRenamer
    extends AutomaticRenamer {
        DestructuringPropertyAutomaticRenamer(PsiElement element, String name) {
            JSDestructuringPropertyReference reference = (JSDestructuringPropertyReference)((Object)ContainerUtil.findInstance((Object[])element.getReferences(), JSDestructuringPropertyReference.class));
            if (reference == null) {
                return;
            }
            for (PsiElement psiElement : JSResolveResult.toElements(reference.multiResolve(false))) {
                if (!(psiElement instanceof PsiNamedElement) || psiElement == element) continue;
                this.myElements.add((PsiNamedElement)psiElement);
            }
            this.suggestAllNames("", name);
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            return newClassName;
        }

        @Nls
        public String getDialogTitle() {
            return JavaScriptBundle.message((String)"rename.destructuring.property.title", (Object[])new Object[0]);
        }

        @Nls
        public String getDialogDescription() {
            return JavaScriptBundle.message((String)"rename.destructuring.property.description", (Object[])new Object[0]);
        }

        public String entityName() {
            return StringUtil.capitalize((String)JavaScriptBundle.message((String)"javascript.language.term.property", (Object[])new Object[0]));
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public boolean allowChangeSuggestedName() {
            return false;
        }
    }
}

