/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptDelegatingMethodsUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionSignatureChecker
extends JSElementVisitor {
    protected final JSTypeChecker myTypeChecker;

    public JSFunctionSignatureChecker(@NotNull JSTypeChecker typeChecker) {
        if (typeChecker == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        this.myTypeChecker = typeChecker;
    }

    protected abstract void registerProblem(JSCallExpression var1, @Nls String var2, LocalQuickFix ... var3);

    public final void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(2);
        }
        this.checkFunction(node, element, JSTypeSubstitutor.EMPTY);
    }

    public final void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element, @NotNull JSTypeSubstitutor substitutor) {
        PsiElement targetElement;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(5);
        }
        if (JSClassUtils.canHaveClasses(element) && (targetElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element)) instanceof JSClass) {
            this.checkConstructorCall(node, (JSClass)targetElement);
            return;
        }
        this.checkFunctionInternal(node, element, substitutor, LocalQuickFix.EMPTY_ARRAY);
    }

    protected final void checkFunctionInternal(@NotNull JSCallExpression node, @NotNull PsiElement element, @NotNull JSTypeSubstitutor substitutor, LocalQuickFix @NotNull [] quickFixes) {
        JSFunctionItem functionItem;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(8);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(9);
        }
        if ((functionItem = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node, false)) != null) {
            JSType returnType = functionItem.getReturnType();
            if (returnType == null || !functionItem.isGetProperty() || !this.isCallableType(node instanceof JSNewExpression, returnType, (PsiElement)node)) {
                if (substitutor.isEmpty()) {
                    this.checkCallParameters(node, (PsiElement)functionItem, quickFixes);
                } else {
                    JSType functionType = JSTypeUtils.applyGenericArguments((JSType)TypeScriptTypeParser.buildFunctionType(functionItem), substitutor);
                    this.canBeCalledWithArguments(functionType, node, quickFixes);
                }
            }
        } else {
            JSExpression methodExpression;
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            if (element instanceof JSFieldVariable && (methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
                jsType = JSTypeEvaluator.getTypeFromTypeGuard(element, (JSReferenceExpression)methodExpression, jsType, element);
            }
            jsType = JSTypeUtils.applyGenericArguments(jsType, substitutor);
            this.canBeCalledWithArguments(jsType, node, quickFixes);
        }
    }

    protected void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(10);
        }
        if (target == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(11);
        }
        if (!(node instanceof JSNewExpression) && !(node.getMethodExpression() instanceof JSSuperExpression)) {
            return;
        }
        ResolveResult[] results = JSClassUtils.resolveES6Constructor(target, node.getMethodExpression());
        PsiElement resolveResultElement = JSResolveResult.resolveAny(results);
        LocalQuickFix createConstructorFix = JSFixFactory.getInstance().createConstructorFix(node, target);
        if (resolveResultElement instanceof JSFunction) {
            LocalQuickFix[] localQuickFixArray;
            if (JSResolveUtil.getClassOfContext(resolveResultElement) != target) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = createConstructorFix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] quickFixes = localQuickFixArray;
            this.checkFunctionInternal(node, resolveResultElement, JSTypeSubstitutor.EMPTY, quickFixes);
            return;
        }
        if (node.getArguments().length > 0) {
            this.registerProblem(node, JavaScriptBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{0}), createConstructorFix);
        }
    }

    public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int count, String n) {
        if (node.getArguments().length != count) {
            this.registerProblem(node, JavaScriptBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{n}), new LocalQuickFix[0]);
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type, PsiElement context) {
        if (type == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(12);
        }
        return JSTypeUtils.hasFunctionType(type, inNewExpression, context);
    }

    protected void canBeCalledWithArguments(@Nullable JSType type, @NotNull JSCallExpression node, LocalQuickFix @NotNull [] quickFixes) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(13);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(14);
        }
        if ((type = JSTypeUtils.getValuableType(type)) == null) {
            return;
        }
        if (!type.isTypeScript()) {
            this.canBeCalledWithArgumentsSingle(type, node, quickFixes);
            return;
        }
        List<Object> candidates = JSTypeUtils.getFunctionType(type, node instanceof JSNewExpression, (PsiElement)node).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            if (DialectDetector.isTypeScript((PsiElement)node)) {
                this.registerProblem(node, JavaScriptBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
            return;
        }
        if (candidates.size() > 1) {
            candidates = JSTypeUtils.chooseOverloadFunctionTypes(candidates, (JSCallItem)node, false);
        }
        if (candidates.size() == 1) {
            this.canBeCalledWithArgumentsSingle((JSType)candidates.get(0), node, quickFixes);
            return;
        }
        if (!JSTypeCastUtil.isAlwaysAssignableType(type, (PsiElement)node)) {
            this.registerProblem(node, JavaScriptBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    protected final void canBeCalledWithArgumentsSingle(@Nullable JSType type, @NotNull JSCallExpression node, LocalQuickFix @NotNull [] quickFixes) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(15);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(16);
        }
        if (!((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionType)) {
            return;
        }
        List decorators = ((JSFunctionType)type).getParameters();
        JSParameterItem[] parameters = decorators.toArray(JSParameterItem.EMPTY_ARRAY);
        JSFunctionItem functionItem = ((JSFunctionType)type).getSourceFunctionItem();
        this.checkCallParameters(node, functionItem, quickFixes, parameters);
    }

    protected void checkCallParameters(@NotNull JSCallExpression node, @Nullable PsiElement element, LocalQuickFix @NotNull [] existingFixes) {
        JSFunctionItem function2;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(17);
        }
        if (existingFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(18);
        }
        JSFunctionItem jSFunctionItem = function2 = element != null ? JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node.getMethodExpression(), false) : null;
        if (function2 == null) {
            return;
        }
        JSParameterItem[] parameters = function2.getParameters();
        this.checkCallParameters(node, function2, existingFixes, parameters);
    }

    private void checkCallParameters(@NotNull JSCallExpression node, @Nullable JSFunctionItem functionItem, LocalQuickFix @NotNull [] existingFixes, JSParameterItem @NotNull [] parameters) {
        boolean matchFound;
        Trinity<Integer, Integer, Boolean> minMaxParameters;
        JSArgumentList argumentList;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(19);
        }
        if (existingFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(20);
        }
        if (parameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(21);
        }
        if (PsiTreeUtil.getChildrenOfType((PsiElement)(argumentList = node.getArgumentList()), OuterLanguageElement.class) != null) {
            return;
        }
        JSExpression[] expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
        DefaultReporter reporter = this.createReporter((JSExpression)node);
        JSGenericTypeEvaluationFunction genericEvaluationFunction = functionItem == null ? JSGenericTypeEvaluationFunction.SELF : JSGenericTypesEvaluator.getEvaluator((PsiElement)node).getEvaluationFunction((JSCallLikeExpression)node, (PsiElement)functionItem, new JSGenericTypesEvaluator.GenericEvaluationContext(reporter));
        ArrayList fixes = ContainerUtil.newArrayList((Object[])existingFixes);
        if (!(functionItem != null && (functionItem.isReferencesArguments() || JSFunctionSignatureChecker.isEmptyImplicitFunction(functionItem, parameters)) || this.checkParameterLength(node, functionItem, expressions, fixes, minMaxParameters = ValidateTypesUtil.getMinMaxParameters(parameters), parameters.length))) {
            return;
        }
        int[] initialMatchedParams = new int[expressions.length];
        if (!JSFunctionSignatureChecker.tryMakeInitialMatch(initialMatchedParams, 0, 0, parameters)) {
            int paramWithMissedArgument;
            int arg = 0;
            boolean isMissedVoid = false;
            for (paramWithMissedArgument = 0; paramWithMissedArgument < parameters.length; ++paramWithMissedArgument) {
                if (parameters[paramWithMissedArgument].isOptional() || parameters[paramWithMissedArgument].getSimpleType() == null) continue;
                isMissedVoid = parameters[paramWithMissedArgument].getInferredType() instanceof JSVoidType;
                if (arg >= expressions.length) break;
                ++arg;
            }
            if (paramWithMissedArgument < parameters.length && !isMissedVoid) {
                this.registerProblem(node, JavaScriptBundle.message((String)"javascript.missed.argument.for.parameter", (Object[])new Object[]{parameters[paramWithMissedArgument].getName()}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
            return;
        }
        int[] matchedParams = new int[initialMatchedParams.length];
        System.arraycopy(initialMatchedParams, 0, matchedParams, 0, matchedParams.length);
        boolean first = true;
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCallEnvironment((PsiElement)node);
        block1: do {
            if (first) {
                int[] _matchedParams = new int[matchedParams.length];
                System.arraycopy(matchedParams, 0, _matchedParams, 0, matchedParams.length);
                if (!this.obtainNextMatchedParams(_matchedParams, parameters) || JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)functionItem)) {
                    matchFound = false;
                    break;
                }
                first = false;
            }
            matchFound = true;
            for (int argIndex = 0; argIndex < expressions.length; ++argIndex) {
                JSParameterItem p = parameters[matchedParams[argIndex]];
                JSType parameterType = p.getInferredType();
                JSType modifiedType = this.modifyParameterTypeFromCall(parameterType, genericEvaluationFunction, node, p.isRest(), argIndex, parameters.length);
                if (JSResolveUtil.isAssignableJSType(modifiedType, JSResolveUtil.getExpressionJSType(expressions[argIndex]), context)) continue;
                matchFound = false;
                continue block1;
            }
        } while (!matchFound && this.obtainNextMatchedParams(matchedParams, parameters));
        if (matchFound) {
            return;
        }
        if (!this.checkArgumentsWithOffset(node, JSFunctionSignatureChecker.mapAsInitials(parameters, initialMatchedParams), expressions, genericEvaluationFunction, context, parameters.length)) {
            reporter.reportGenericErrorIfExist();
        }
    }

    private static JSParameterItem[] mapAsInitials(JSParameterItem @NotNull [] parameters, int @NotNull [] initialMatchedParams) {
        int initialSize;
        if (parameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(22);
        }
        if (initialMatchedParams == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(23);
        }
        if ((initialSize = initialMatchedParams.length) == parameters.length) {
            return parameters;
        }
        JSParameterItem[] result2 = new JSParameterItem[initialSize];
        for (int i = 0; i < initialSize; ++i) {
            result2[i] = parameters[initialMatchedParams[i]];
        }
        return result2;
    }

    private boolean checkArgumentsWithOffset(@NotNull JSCallExpression node, JSParameterItem @NotNull [] parameters, JSExpression @NotNull [] expressions, @NotNull JSGenericTypeEvaluationFunction genericEvaluationFunction, @NotNull ProcessingContext context, int functionParameterLength) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(24);
        }
        if (genericEvaluationFunction == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(26);
        }
        if (parameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(27);
        }
        if (expressions == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(28);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        int paramIndex = -1;
        boolean errorReported = false;
        for (int argIndex = 0; argIndex < expressions.length && ++paramIndex < parameters.length; ++argIndex) {
            JSParameterItem curParameter = parameters[paramIndex];
            JSExpression expression = expressions[argIndex];
            if (curParameter.isRest()) {
                if (dialect == DialectOptionHolder.ECMA_4) break;
                JSType type = curParameter.getInferredType();
                if (expression instanceof JSSpreadExpression) {
                    paramIndex = this.validateSpread(node, type, paramIndex, (JSSpreadExpression)expression, genericEvaluationFunction, context, functionParameterLength);
                    continue;
                }
                JSType modified = this.modifyParameterTypeFromCall(type, genericEvaluationFunction, node, true, argIndex, functionParameterLength);
                errorReported |= !this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError(expression, modified, null, "javascript.argument.type.mismatch", context, false);
                continue;
            }
            errorReported |= !this.checkCallArgumentType(curParameter, expression, node, context, genericEvaluationFunction);
        }
        return errorReported;
    }

    private static boolean isEmptyImplicitFunction(@NotNull JSFunctionItem function2, JSParameterItem @NotNull [] parameters) {
        if (function2 == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(29);
        }
        if (parameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(30);
        }
        return function2 instanceof JSImplicitElement && parameters.length == 0 && function2.getReturnType() == null;
    }

    protected boolean checkParameterLength(@NotNull JSCallExpression node, @Nullable JSFunctionItem function2, JSExpression @NotNull [] expressions, @NotNull List<LocalQuickFix> fixes, @NotNull Trinity<Integer, Integer, Boolean> minMaxParameters, int actualParameterLength) {
        String s;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(31);
        }
        if (fixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(32);
        }
        if (minMaxParameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(33);
        }
        if (expressions == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(34);
        }
        Integer min = (Integer)minMaxParameters.first;
        Integer max = (Integer)minMaxParameters.second;
        JSArgumentList argumentList = node.getArgumentList();
        if (expressions.length >= min && expressions.length <= max) {
            return true;
        }
        String string = (Boolean)minMaxParameters.third != false && !min.equals(max) ? min + " or more" : (s = min + (!min.equals(max) ? ".." + max : ""));
        if (function2 instanceof JSFunction) {
            fixes.add(JSFixFactory.getInstance().changeSignatureFix((JSFunction)function2, argumentList));
            if (expressions.length == 0) {
                fixes.add(JSFixFactory.getInstance().createArgumentStubsFix(node));
            }
            TypeScriptDelegatingMethodsUtil.processDelegationCandidates(node, (methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList) -> {
                Ref invertedOrder = Ref.create((Object)false);
                JSFunction from = TypeScriptDelegatingMethodsUtil.getMethodToTakeParametersFrom(methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList, (Ref<? super Boolean>)invertedOrder, true);
                if (from != null) {
                    fixes.add(JSFixFactory.getInstance().changeSignatureWithDelegationUpdateFix(container, from, node));
                }
            }, true);
        }
        if (expressions.length == 1 && "window".equalsIgnoreCase(expressions[0].getText()) && actualParameterLength == 2) {
            return false;
        }
        if (argumentList != null && argumentList.hasSpreadElement() && expressions.length < min) {
            return false;
        }
        this.registerProblem(node, JavaScriptBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{s}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        return false;
    }

    private int validateSpread(@NotNull JSCallExpression node, JSType type, int paramIndex, @NotNull JSSpreadExpression expression, JSGenericTypeEvaluationFunction genericEvaluationFunction, @NotNull ProcessingContext context, int parameterLength) {
        JSType expressionType;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(35);
        }
        if (expression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(36);
        }
        if (context == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(37);
        }
        if ((expressionType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(expression.getExpression()))) instanceof JSTupleType) {
            JSTupleType tupleType = (JSTupleType)expressionType;
            if (tupleType.getMaxLength() != Integer.MAX_VALUE) {
                for (int i = 0; i < tupleType.getMaxLength(); ++i) {
                    this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, genericEvaluationFunction, node, true, paramIndex, parameterLength), null, "javascript.argument.type.mismatch", context, tupleType.getTypeByIndex(i));
                    ++paramIndex;
                }
            } else {
                List types2 = tupleType.getTypes();
                JSType item = (JSType)ContainerUtil.getLastItem((List)types2);
                assert (item instanceof JSSpreadType);
                for (int i = 0; i < types2.size() - 1; ++i) {
                    this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, genericEvaluationFunction, node, true, paramIndex, parameterLength), null, "javascript.argument.type.mismatch", context, tupleType.getTypeByIndex(i));
                    ++paramIndex;
                }
                this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, genericEvaluationFunction, node, true, paramIndex, parameterLength), null, "javascript.argument.type.mismatch", context, ((JSSpreadType)item).getComponentType());
            }
        } else if (expressionType != null) {
            this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, genericEvaluationFunction, node, true, paramIndex, parameterLength), null, "javascript.argument.type.mismatch", context, JSTypeUtils.getIndexableComponentType(expressionType));
        }
        return paramIndex;
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        for (int argIndexToShift = matchedParams.length - 1; argIndexToShift >= 0; --argIndexToShift) {
            int paramOffset;
            int oldParamIndex;
            if (matchedParams[argIndexToShift] >= parameters.length - 1 || !parameters[oldParamIndex = matchedParams[argIndexToShift]].isOptional() && !parameters[oldParamIndex].getTypeDecorator().isRest()) continue;
            int newParamIndex = oldParamIndex + 1;
            int n = paramOffset = newParamIndex < parameters.length && parameters[newParamIndex].getTypeDecorator().isRest() ? newParamIndex : newParamIndex + 1;
            if (!JSFunctionSignatureChecker.tryMakeInitialMatch(matchedParams, argIndexToShift + 1, paramOffset, parameters)) continue;
            int n2 = argIndexToShift;
            matchedParams[n2] = matchedParams[n2] + 1;
            return true;
        }
        return false;
    }

    private static boolean tryMakeInitialMatch(int[] matchedParams, int matchedParamsOffset, int paramsOffset, JSParameterItem[] parameters) {
        boolean fits;
        if (matchedParamsOffset > matchedParams.length) {
            return false;
        }
        if (paramsOffset > parameters.length) {
            return false;
        }
        int argumentsToMatch = matchedParams.length - matchedParamsOffset;
        int required = 0;
        boolean hasRest = false;
        for (int i = paramsOffset; i < parameters.length; ++i) {
            if (parameters[i].getTypeDecorator().isRest()) {
                hasRest = true;
                continue;
            }
            if (parameters[i].isOptional()) continue;
            ++required;
        }
        boolean bl = fits = required <= argumentsToMatch && (hasRest || argumentsToMatch <= parameters.length - paramsOffset);
        if (!fits) {
            return false;
        }
        for (int i = matchedParamsOffset; i < matchedParams.length; ++i) {
            if (required == matchedParams.length - i) {
                while (parameters[paramsOffset].getTypeDecorator().isRest() || parameters[paramsOffset].isOptional()) {
                    ++paramsOffset;
                }
            }
            matchedParams[i] = paramsOffset;
            if (parameters[paramsOffset].getTypeDecorator().isRest()) continue;
            if (!parameters[paramsOffset].isOptional()) {
                --required;
            }
            ++paramsOffset;
        }
        return true;
    }

    @Nullable
    @Contract(value="!null, _, _, _, _, _ -> !null")
    protected final JSType modifyParameterTypeFromCall(@Nullable JSType type, @NotNull JSGenericTypeEvaluationFunction genericEvaluationFunction, @NotNull JSCallExpression callExpression, boolean isRestTuple, int argIndex, int signatureParameterCount) {
        JSType nested;
        JSType toProcess;
        if (genericEvaluationFunction == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(38);
        }
        if (callExpression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(39);
        }
        if (type instanceof JSRestTypeImpl && isRestTuple && (toProcess = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(genericEvaluationFunction.evaluate(nested = ((JSRestTypeImpl)type).getIterableType()))) instanceof JSTupleType) {
            return this.verifyAndModifyByTuple((JSTupleType)toProcess, callExpression, argIndex, signatureParameterCount);
        }
        return genericEvaluationFunction.evaluate(type);
    }

    @Nullable
    private JSType verifyAndModifyByTuple(@NotNull JSTupleType type, @NotNull JSCallExpression callExpression, int argIndex, int signatureParameterCount) {
        int restPosition;
        int tupleElement;
        if (type == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(40);
        }
        if (callExpression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(41);
        }
        if (type.hasTypeByIndex(tupleElement = argIndex - (restPosition = signatureParameterCount - 1))) {
            return type.getTypeByIndex(tupleElement);
        }
        int maxLength = type.getMaxLength();
        String fromUpTo = type.getOptionalStart() == -1 ? String.valueOf(signatureParameterCount + maxLength - 1) : (maxLength == 0 ? "0" : (maxLength != Integer.MAX_VALUE ? "from " + restPosition + " up to " + (signatureParameterCount + maxLength - 1) : restPosition + " or more"));
        if (maxLength == Integer.MAX_VALUE || argIndex == signatureParameterCount + maxLength - 1) {
            this.registerProblem(callExpression, JavaScriptBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{fromUpTo}), new LocalQuickFix[0]);
        }
        return null;
    }

    protected DefaultReporter createReporter(@Nullable JSExpression expression) {
        return new DefaultReporter(expression);
    }

    protected boolean checkCallArgumentType(@NotNull JSParameterItem p, @Nullable JSExpression expression, @NotNull JSCallExpression node, @NotNull ProcessingContext processingContext, @NotNull JSGenericTypeEvaluationFunction function2) {
        if (p == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(42);
        }
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(43);
        }
        if (processingContext == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(44);
        }
        if (function2 == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(45);
        }
        return this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError(expression, function2.evaluate(p.getInferredType()), (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null), "javascript.argument.type.mismatch", processingContext, false);
    }

    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChecker";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 31: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFixes";
                break;
            }
            case 21: 
            case 22: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialMatchedParams";
                break;
            }
            case 25: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericEvaluationFunction";
                break;
            }
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 29: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minMaxParameters";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionInternal";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorCall";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeCalledWithArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeCalledWithArgumentsSingle";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallParameters";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "mapAsInitials";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgumentsWithOffset";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyImplicitFunction";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameterLength";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSpread";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyParameterTypeFromCall";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyAndModifyByTuple";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallArgumentType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class DefaultReporter
    implements JSGenericTypesEvaluator.GenericErrorReporter {
        @Nullable
        private final JSExpression myExpression;
        public String myMessage = null;

        public DefaultReporter(JSExpression expression) {
            this.myExpression = expression;
        }

        @Override
        public void error(@NotNull String parameter) {
            if (parameter == null) {
                DefaultReporter.$$$reportNull$$$0(0);
            }
            if (this.myMessage != null) {
                return;
            }
            this.myMessage = parameter;
        }

        public void reportGenericErrorIfExist() {
            if (this.myMessage != null && this.myExpression != null && DialectDetector.isTypeScript((PsiElement)this.myExpression)) {
                JSFunctionSignatureChecker.this.myTypeChecker.registerProblem((PsiElement)this.myExpression, JavaScriptBundle.message((String)this.myMessage, (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)this.myExpression), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker$DefaultReporter", "error"));
        }
    }
}

