/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordElementType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSKeywordHighlighterVisitor
extends JSRecursiveWalkingElementVisitor {
    @NotNull
    protected final HighlightInfoHolder myHolder;
    @NotNull
    protected final JSHighlighter myHighlighter;
    @NotNull
    private final Set<String> myKeywords;

    public JSKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull DialectOptionHolder dialectOptionHolder) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        if (dialectOptionHolder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this(holder, new JSHighlighter(dialectOptionHolder, true));
    }

    protected JSKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull JSHighlighter highlighter) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        if (highlighter == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.myKeywords = new HashSet<String>();
        this.myHolder = holder;
        this.myHighlighter = highlighter;
        TokenSet keywords = highlighter.getKeywords();
        for (IElementType keyword : keywords.getTypes()) {
            if (!(keyword instanceof JSKeywordElementType)) continue;
            this.myKeywords.add(((JSKeywordElementType)keyword).getKeyword());
        }
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSGeneratorExpression(element);
    }

    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitES6DecoratorDeclaration(ES6DecoratorDeclaration node) {
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.DECORATOR_KEYWORD);
        super.visitES6DecoratorDeclaration(node);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression function2) {
        if (function2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightKeywordGetterAndSetter((JSFunction)function2);
        super.visitJSFunctionExpression(function2);
    }

    public void visitJSFunctionProperty(JSFunctionProperty function2) {
        this.highlightKeywordGetterAndSetter((JSFunction)function2);
        super.visitJSFunctionProperty(function2);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        this.highlightKeywordGetterAndSetter(function2);
        super.visitJSFunctionDeclaration(function2);
    }

    public void visitES6FromClause(ES6FromClause element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.FROM_KEYWORD);
        super.visitES6FromClause(element);
    }

    public void visitES6NamespaceImportExport(ES6NamespaceImportExport element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AS_KEYWORD);
        super.visitES6NamespaceImportExport(element);
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        this.highlightChildKeywordOfType((PsiElement)specifierAlias, JSTokenTypes.AS_KEYWORD);
        super.visitES6ImportSpecifierAlias(specifierAlias);
    }

    protected void highlightKeywordGetterAndSetter(@NotNull JSFunction function2) {
        PsiElement nameIdentifier;
        if (function2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        if ((nameIdentifier = function2.getNameIdentifier()) == null) {
            return;
        }
        JSAttributeList list2 = function2.getAttributeList();
        if (list2 != null) {
            PsiElement element = list2.findModifierElement(JSAttributeList.ModifierType.GET);
            if (element != null) {
                this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(element.getNode(), this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
                return;
            }
            element = list2.findModifierElement(JSAttributeList.ModifierType.SET);
            if (element != null) {
                this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(element.getNode(), this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
            }
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        String elementText;
        IElementType elementType;
        if (element == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        if (element instanceof LeafPsiElement && (elementType = ((LeafPsiElement)element).getElementType()) == JSTokenTypes.IDENTIFIER && this.myKeywords.contains(elementText = element.getText())) {
            Lexer lexer = this.myHighlighter.getHighlightingLexer();
            lexer.start((CharSequence)elementText);
            if (this.myHighlighter.getKeywords().contains(lexer.getTokenType())) {
                this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(element.getNode(), TextAttributes.ERASE_MARKER));
            }
        }
        super.visitElement(element);
    }

    protected static HighlightInfo highlightKeyword(@NotNull ASTNode keyword, @NotNull TextAttributesKey key) {
        if (keyword == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        if (key == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).severity(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(keyword).textAttributes(key).create();
    }

    protected static HighlightInfo highlightKeyword(@NotNull ASTNode keyword, @NotNull TextAttributes attributes) {
        if (keyword == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(10);
        }
        if (attributes == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(11);
        }
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).severity(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(keyword).textAttributes(attributes).create();
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types2) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(12);
        }
        if (types2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(13);
        }
        if ((keyword = parent.getNode().findChildByType(types2)) != null) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
        }
    }

    protected void highlightChildKeywordOfType(@NotNull PsiElement parent, @NotNull IElementType type) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(14);
        }
        if (type == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(15);
        }
        if ((keyword = parent.getNode().findChildByType(type)) != null) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeywordGetterAndSetter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfTypes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

