/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ChangeJSDocTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String myType;
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    private final String myNameKey;

    public ChangeJSDocTypeFix(@NotNull JSNamedElement psiElement, @NotNull JSType newType) {
        if (psiElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)psiElement);
        this.myType = newType.getTypeText(JSType.TypeTextFormat.CODE);
        this.myNameKey = psiElement instanceof JSParameter ? "javascript.fix.change.parameter.type" : (psiElement instanceof JSFunction ? "javascript.fix.set.method.return.type" : "javascript.fix.change.type");
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String paramName;
        JSFunction function2;
        PsiComment comment;
        if (project == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(5);
        }
        if ((comment = JSDocumentationUtils.findDocComment(startElement)) == null && startElement instanceof JSParameter && (function2 = ((JSParameter)startElement).getDeclaringFunction()) != null) {
            comment = JSDocumentationUtils.findFunctionComment(function2);
        }
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocTag[] tags = ((JSDocComment)comment).getTags();
        JSDocumentationProcessor.MetaDocType requiredTagName = startElement instanceof JSParameter ? JSDocumentationProcessor.MetaDocType.PARAMETER : (startElement instanceof JSFunction ? JSDocumentationProcessor.MetaDocType.RETURN : JSDocumentationProcessor.MetaDocType.TYPE);
        String string = paramName = startElement instanceof JSParameter ? ((JSParameter)startElement).getName() : null;
        if (requiredTagName == JSDocumentationProcessor.MetaDocType.PARAMETER && paramName == null) {
            return;
        }
        Optional<JSDocTagValue> typeValue = Arrays.stream(tags).map(tag -> {
            JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
            JSDocTagValue value = tag.getValue();
            return docTag != null && docTag.type == requiredTagName && value != null && (requiredTagName != JSDocumentationProcessor.MetaDocType.PARAMETER || paramName.equals(docTag.matchName)) ? value : null;
        }).filter(value -> value != null).findFirst();
        if (!typeValue.isPresent()) {
            return;
        }
        JSDocTagValue typeElement = typeValue.get();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(typeElement.getContainingFile());
        if (document2 != null) {
            boolean wrapInBrackets = typeElement.getText().startsWith("{");
            document2.replaceString(typeElement.getTextRange().getStartOffset(), typeElement.getTextRange().getEndOffset(), (CharSequence)(wrapInBrackets ? "{" + this.myType + "}" : this.myType));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        }
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)this.myNameKey, (Object[])new Object[]{((JSNamedElement)this.getStartElement()).getName(), this.myType});
        if (string == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.change.jsdoc.type.family.name", (Object[])new Object[0]);
        if (string == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

