/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        if ((Integer)args[0] > 0) {
            String string = InspectionJSBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", new Object[0]);
            if (string == null) {
                ShiftOutOfRangeJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", new Object[0]);
        if (string == null) {
            ShiftOutOfRangeJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        JSExpression rhs = ((JSBinaryExpression)location).getROperand();
        assert (rhs != null);
        return new ShiftOutOfRangeFix((Integer)ExpressionUtil.computeConstantExpression(rhs));
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection", "buildErrorString"));
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private static final TokenSet SHIFT_OPS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LTLT, JSTokenTypes.GTGT, JSTokenTypes.GTGTGT});

        private ShiftOutOfRange() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                ShiftOutOfRange.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            IElementType tokenType = expression.getOperationSign();
            if (!SHIFT_OPS.contains(tokenType)) {
                return;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ExpressionUtil.isConstantExpression(rhs, false)) {
                return;
            }
            Object valueObject = ExpressionUtil.computeConstantExpression(rhs);
            if (!(valueObject instanceof Integer)) {
                return;
            }
            int value = (Integer)valueObject;
            if (value < 0 || value > 31) {
                this.registerErrorForChild((PsiElement)expression, tokenType, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection$ShiftOutOfRange", "visitJSBinaryExpression"));
        }
    }

    private static class ShiftOutOfRangeFix
    extends InspectionJSFix {
        private final int value;

        ShiftOutOfRangeFix(int value) {
            this.value = value;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.value, this.value & 0x1F});
            if (string == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return "Fix shift value";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            JSExpression expression = (JSExpression)descriptor2.getPsiElement();
            if (!(expression instanceof JSBinaryExpression)) {
                return;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            JSExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            rhs.replace((JSExpression)JSPsiElementFactory.createJSExpression(String.valueOf(this.value & 0x1F), (PsiElement)expression, JSLiteralExpression.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection$ShiftOutOfRangeFix", "getName"));
        }
    }
}

