/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class TextLabelInSwitchStatementJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("text.label.in.switch.statement.error.string", new Object[0]);
        if (string == null) {
            TextLabelInSwitchStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TextLabelInSwitchStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/TextLabelInSwitchStatementJSInspection", "buildErrorString"));
    }

    private static class TextLabelInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private TextLabelInSwitchStatementVisitor() {
        }

        public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
            JSCaseClause[] caseClauses;
            if (statement == null) {
                TextLabelInSwitchStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSSwitchStatement(statement);
            for (JSCaseClause caseClause : caseClauses = statement.getCaseClauses()) {
                JSSourceElement[] statements;
                for (JSSourceElement statement1 : statements = caseClause.getStatementListItems()) {
                    this.checkForLabel(statement1);
                }
            }
        }

        private void checkForLabel(JSSourceElement statement) {
            if (!(statement instanceof JSLabeledStatement)) {
                return;
            }
            JSLabeledStatement labeledStatement = (JSLabeledStatement)statement;
            PsiElement label = labeledStatement.getLabelIdentifier();
            this.registerError(label);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/bugs/TextLabelInSwitchStatementJSInspection$TextLabelInSwitchStatementVisitor", "visitJSSwitchStatement"));
        }
    }
}

