/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ExceptionCaughtLocallyJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("exception.caught.locally.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean isCaughtLocally(@NotNull JSElement throwStatement) {
        if (throwStatement == null) {
            ExceptionCaughtLocallyJSInspection.$$$reportNull$$$0(0);
        }
        JSElement currentElement = throwStatement;
        JSSourceElement element;
        while (!((element = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, (Class[])new Class[]{JSTryStatement.class, JSFunction.class})) instanceof JSFunction)) {
            JSStatement tryBlock;
            JSTryStatement tryStatement = (JSTryStatement)element;
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getCatchBlock() != null && (tryBlock = tryStatement.getStatement()) != null && PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwStatement", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection", "isCaughtLocally"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSThrowStatement(@NotNull JSThrowStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSThrowStatement(statement);
            if (!ExceptionCaughtLocallyJSInspection.isCaughtLocally((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, new Object[0]);
        }

        public void visitJSThrowExpression(JSThrowExpression node) {
            super.visitJSThrowExpression(node);
            if (!ExceptionCaughtLocallyJSInspection.isCaughtLocally((JSElement)node)) {
                return;
            }
            this.registerError((PsiElement)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/ExceptionCaughtLocallyJSInspection$Visitor", "visitJSThrowStatement"));
        }
    }
}

