/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.django.util.DjangoPsiUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoXmlExtension
extends DefaultXmlExtension {
    public SchemaPrefix getPrefixDeclaration(@Nullable XmlTag context, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (context == null) {
            return null;
        }
        return this.findPrefixDeclaration(context, namespacePrefix);
    }

    @Nullable
    private SchemaPrefix findPrefixDeclaration(@NotNull XmlTag context, String prefix) {
        if (context == null) {
            DjangoXmlExtension.$$$reportNull$$$0(0);
        }
        PsiFile file2 = context.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement tag = viewProvider.findElementAt(context.getTextOffset(), (Language)DjangoTemplateLanguage.INSTANCE);
        return this.findBlockTagAndResolveToIt(tag, prefix, Sets.newHashSet());
    }

    @Nullable
    private SchemaPrefix findBlockTagAndResolveToIt(PsiElement tag, String prefix, Set<DjangoBlockTag> blocksSet) {
        DjangoBlockTag block = DjangoPsiUtil.findOpeningBlock(tag);
        if (block != null) {
            return this.findPrefixFromBlockDeclaration(block, prefix, blocksSet);
        }
        return null;
    }

    @Nullable
    private SchemaPrefix findPrefixFromBlockDeclaration(DjangoBlockTag block, String prefix, Set<DjangoBlockTag> blocksSet) {
        PsiElement injection;
        PsiElement el;
        if (blocksSet.contains((Object)block)) {
            return null;
        }
        blocksSet.add(block);
        PsiReference ref = block.getReference();
        if (ref != null && (el = ref.resolve()) != null && (injection = DjangoPsiUtil.findContainingElementInTemplateDataLanguage(el)) != null) {
            SchemaPrefix result = super.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)injection, XmlTag.class), prefix);
            if (result != null) {
                return result;
            }
            return this.findBlockTagAndResolveToIt(DjangoPsiUtil.prevFromTag(el), prefix, blocksSet);
        }
        return null;
    }

    public boolean isAvailable(PsiFile file2) {
        return file2.getViewProvider() instanceof DjangoTemplateFileViewProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/django/lang/template/DjangoXmlExtension", "findPrefixDeclaration"));
    }
}

