/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.util.DjangoStringUtil;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        CompletionResultSet endCommentCompletion;
        if (parameters == null) {
            DjangoTemplateCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            DjangoTemplateCompletionContributor.$$$reportNull$$$0(1);
        }
        int startOffset = parameters.getOffset();
        PsiElement insertedElement = parameters.getPosition();
        if (insertedElement.getNode() != null && DjangoTemplateCompletionContributor.isComment(insertedElement) && DjangoTemplateCompletionContributor.isAfterTagStart(insertedElement, startOffset)) {
            endCommentCompletion = result.withPrefixMatcher(DjangoTemplateCompletionContributor.findTagNamePrefix(insertedElement, startOffset));
            endCommentCompletion.addElement((LookupElement)LookupElementBuilder.create((String)"endcomment"));
        }
        if (insertedElement.getNode() != null && DjangoTemplateCompletionContributor.isVerbatim(insertedElement) && DjangoTemplateCompletionContributor.isAfterTagStart(insertedElement, startOffset)) {
            endCommentCompletion = result.withPrefixMatcher(DjangoTemplateCompletionContributor.findTagNamePrefix(insertedElement, startOffset));
            endCommentCompletion.addElement((LookupElement)LookupElementBuilder.create((String)"endverbatim"));
        }
    }

    private static boolean isComment(@NotNull PsiElement insertedElement) {
        if (insertedElement == null) {
            DjangoTemplateCompletionContributor.$$$reportNull$$$0(2);
        }
        return DjangoTemplateTokenTypes.BLOCK_COMMENT_TOKENS.contains(insertedElement.getNode().getElementType());
    }

    private static boolean isVerbatim(@NotNull PsiElement insertedElement) {
        if (insertedElement == null) {
            DjangoTemplateCompletionContributor.$$$reportNull$$$0(3);
        }
        return DjangoTemplateTokenTypes.DJANGO_UNCLOSED_VERBATIM == insertedElement.getNode().getElementType();
    }

    private static String findTagNamePrefix(PsiElement insertedElement, int offset) {
        if (insertedElement == null) {
            return "";
        }
        String text2 = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextRange().getStartOffset();
        return DjangoStringUtil.findTagNamePrefix(text2, offsetInElement);
    }

    private static boolean isAfterTagStart(PsiElement insertedElement, int offset) {
        if (insertedElement == null) {
            return false;
        }
        String text2 = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextRange().getStartOffset();
        return DjangoStringUtil.isAfterTagStart(text2, offsetInElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoTemplateCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVerbatim";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

