/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DjangoBrokenLineCommentInspection
extends DjangoLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            DjangoBrokenLineCommentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoBrokenLineCommentInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/inspection/DjangoBrokenLineCommentInspection", "getGroupDisplayName"));
    }

    private static class DjangoTagVisitor
    extends PsiRecursiveElementVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = Lists.newArrayList();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            if (element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_COMMENT_START_WITHOUT_END) {
                this.reportProblem(element, "Start comment {# without ending #}");
            }
            if (element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_COMMENT_END_WITHOUT_START) {
                this.reportProblem(element, "End comment #} without starting {#");
            }
            super.visitElement(element);
        }

        private void reportProblem(PsiElement elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/django/lang/template/inspection/DjangoBrokenLineCommentInspection$DjangoTagVisitor", "visitElement"));
        }
    }
}

