/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.psi.impl.DjangoUrlViewImpl;
import com.jetbrains.django.lang.template.tags.DjangoUrlTag;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.NotNull;

public class DjangoUnresolvedUrlInspection
extends DjangoLocalInspectionTool {
    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new MyUnresolvedUrlVisitor(manager);
    }

    private static class MyUnresolvedUrlVisitor
    extends DjangoInspectionVisitorAdapter {
        MyUnresolvedUrlVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                MyUnresolvedUrlVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        @Override
        public void visitUrlTag(@NotNull DjangoUrlTag urlTag) {
            DjangoUrlViewImpl view;
            if (urlTag == null) {
                MyUnresolvedUrlVisitor.$$$reportNull$$$0(1);
            }
            if ((view = urlTag.getUrlView()) == null) {
                return;
            }
            String urlName = view.getUrlName();
            if (urlName != null && urlTag.findAssociatedUrl() == null) {
                String message = DjangoBundle.message("inspection.unresolved_url.error", urlName);
                this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)urlTag, message, true, ProblemHighlightType.WEAK_WARNING, true, new LocalQuickFix[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlTag";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/lang/template/inspection/DjangoUnresolvedUrlInspection$MyUnresolvedUrlVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUrlTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

