/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberExpressionImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoVariableReferenceImpl;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ref.TypedReference;
import com.jetbrains.django.ref.VariableReference;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoQualifiedMemberReference
extends BaseReference
implements TypedReference,
CachedValueProvider<Ref<PsiElement>> {
    @NotNull
    private final DjangoMemberNameImpl myMember;

    public DjangoQualifiedMemberReference(@NotNull DjangoMemberNameImpl member) {
        if (member == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)member);
        this.myMember = member;
    }

    public PsiElement resolve() {
        return (PsiElement)((Ref)CachedValuesManager.getCachedValue((PsiElement)this.myMember, (CachedValueProvider)this)).get();
    }

    @Nullable
    public CachedValueProvider.Result<Ref<PsiElement>> compute() {
        Iterator<PsiElement> iterator = this.resolveMulti(TypeEvalContext.deepCodeInsight(this.myMember.getProject())).iterator();
        if (iterator.hasNext()) {
            PsiElement el = iterator.next();
            return CachedValueProvider.Result.create((Object)Ref.create((Object)el), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
        return CachedValueProvider.Result.create((Object)new Ref(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    public Object @NotNull [] getVariants() {
        TypeEvalContext context = TypeEvalContext.codeCompletion(this.myElement.getProject(), CompletionUtil.getOriginalOrSelf((PsiElement)this.myElement).getContainingFile());
        PyExpression expr = this.getExpressionHook(context);
        ProcessingContext ctx = new ProcessingContext();
        ctx.put(PyClassTypeImpl.CTX_SUPPRESS_PARENTHESES, (Object)Boolean.TRUE);
        boolean djangoTemplates = DjangoQualifiedMemberReference.isDjangoTemplates((PsiElement)this.myMember);
        ArrayList res = Lists.newArrayList();
        PsiReference[] refs = this.getPrevReferences();
        if (refs != null) {
            for (PsiReference ref : refs) {
                TypedReference tr;
                PyType refType;
                if (!(ref instanceof TypedReference) || (refType = (tr = (TypedReference)ref).resolveType(context)) == null) continue;
                Object[] vars = refType.getCompletionVariants(this.getElement().getText(), (PsiElement)expr, ctx);
                if (djangoTemplates) {
                    vars = Arrays.stream(vars).filter(o -> !(o instanceof LookupElement) || !((LookupElement)o).getLookupString().startsWith("_")).toArray();
                }
                res.addAll(Arrays.asList(vars));
            }
        }
        res.addAll(this.collectAssignedAttributes(this.myMember, (PsiElement)expr));
        Object[] objectArray = res.toArray();
        if (objectArray == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static boolean isDjangoTemplates(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor)) == null) {
            return false;
        }
        return Objects.equals(TemplatesService.getInstance(module).getSelectedTemplateLanguage(), (Object)DjangoTemplateLanguage.INSTANCE);
    }

    private Collection<PyTargetExpression> collectAssignedAttributes(@NotNull DjangoMemberNameImpl member, @Nullable PsiElement hookElement) {
        QualifiedName qName;
        if (member == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(3);
        }
        if ((qName = this.getQualifierPath(member)) == null || hookElement == null) {
            return Collections.emptyList();
        }
        return PyQualifiedReference.collectAssignedAttributes(qName, hookElement);
    }

    @Override
    @Nullable
    public PyType resolveType(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(4);
        }
        PyType res = null;
        for (PsiElement member : this.resolveMulti(context)) {
            PyType type;
            if (member instanceof PyTypedElement && (type = context.getType((PyTypedElement)member)) != null) {
                res = res == null ? type : PyUnionType.union(res, type);
            }
            if (!(member instanceof PyFunction)) continue;
            return PyTargetExpressionImpl.getContextSensitiveType((PyFunction)member, context, null);
        }
        return res;
    }

    public List<PsiElement> resolveMulti(TypeEvalContext context) {
        ArrayList res = Lists.newArrayList();
        PsiReference[] refs = this.getPrevReferences();
        if (refs != null) {
            for (PsiReference ref : refs) {
                TypedReference tr;
                PyType typeRef;
                if (!(ref instanceof TypedReference) || (typeRef = (tr = (TypedReference)ref).resolveType(context)) == null) continue;
                PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
                List<? extends RatedResolveResult> members = typeRef.resolveMember(this.getElement().getText(), null, AccessDirection.READ, resolveContext);
                if (members == null) continue;
                for (RatedResolveResult ratedResolveResult : members) {
                    res.add(ratedResolveResult.getElement());
                }
            }
        }
        for (PyExpression pyExpression : this.collectAssignedAttributes(this.myMember, (PsiElement)this.getExpressionHook(context))) {
            if (!PythonStringUtil.getLastSuffix(pyExpression.getText(), ".").equals(this.getElement().getText())) continue;
            res.add(pyExpression);
        }
        return res;
    }

    public PsiReference @Nullable [] getPrevReferences() {
        PsiElement prevSibling = this.getElement().getPrevSibling();
        if (prevSibling != null && ".".equals(prevSibling.getText())) {
            PsiElement el = prevSibling.getPrevSibling();
            if (el instanceof DjangoVariableReferenceImpl || el instanceof DjangoMemberNameImpl) {
                return el.getReferences();
            }
            if (el instanceof DjangoMemberExpressionImpl && el.getLastChild() != null) {
                return el.getLastChild().getReferences();
            }
        }
        return null;
    }

    public static boolean isVariableMember(DjangoMemberNameImpl djangoMemberName) {
        return DjangoQualifiedMemberReference.getVariableReference(djangoMemberName) != null;
    }

    @Nullable
    public static DjangoVariableReferenceImpl getVariableReference(DjangoMemberNameImpl djangoMemberName) {
        if (djangoMemberName.getParent() instanceof DjangoMemberExpressionImpl) {
            DjangoMemberExpressionImpl memberExpression = (DjangoMemberExpressionImpl)djangoMemberName.getParent();
            return DjangoQualifiedMemberReference.getVariableReference(memberExpression);
        }
        return null;
    }

    @Nullable
    public static DjangoVariableReferenceImpl getVariableReference(DjangoMemberExpressionImpl memberExpression) {
        if (memberExpression.getNode().getFirstChildNode().getElementType() == DjangoTemplateElementTypes.VAR) {
            return (DjangoVariableReferenceImpl)memberExpression.getNode().getFirstChildNode().getPsi();
        }
        if (memberExpression.getNode().getFirstChildNode() instanceof DjangoMemberExpressionImpl) {
            return DjangoQualifiedMemberReference.getVariableReference((DjangoMemberExpressionImpl)memberExpression.getNode().getFirstChildNode());
        }
        return null;
    }

    @Nullable
    private PyExpression getExpressionHook(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(5);
        }
        Set<NavigatablePsiElement> refs = DjangoTemplateManager.getTemplateReferences(DjangoPsiUtil.getFile(this.getElement()), PyExpression.class, context);
        for (NavigatablePsiElement ref : refs) {
            if (!(ref instanceof PyExpression)) continue;
            return (PyExpression)ref;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private QualifiedName getQualifierPath(DjangoMemberNameImpl member) {
        DjangoMemberNameImpl el;
        ArrayList res = Lists.newArrayList();
        if (this.myMember.getParent() instanceof DjangoMemberExpressionImpl) {
            DjangoMemberExpressionImpl memberExpression = (DjangoMemberExpressionImpl)this.myMember.getParent();
            el = memberExpression.getFirstChild();
        } else {
            el = this.myMember;
        }
        while (el != null && el != member) {
            PsiReference ref = el.getReference();
            if (ref instanceof VariableReference) {
                PyExpression expr = ((VariableReference)ref).resolveTypeValueExpression();
                if (!(expr instanceof PyQualifiedExpression)) return null;
                QualifiedName qualifiedName = ((PyQualifiedExpression)expr).asQualifiedName();
                if (qualifiedName != null) {
                    res.addAll(qualifiedName.getComponents());
                }
            } else if (!".".equals(el.getText())) {
                res.addAll(QualifiedName.fromDottedString((String)el.getText()).getComponents());
            }
            el = el.getNextSibling();
        }
        return QualifiedName.fromComponents((Collection)res);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoQualifiedMemberReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoQualifiedMemberReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplates";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignedAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionHook";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

