/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.tags;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTagParser;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.ui.DjangoBundle;

public class DjangoBlockTransTagParser
extends DjangoTagParser<DjangoTemplateParsing> {
    @Override
    public void parse(PsiBuilder builder, PsiBuilder.Marker tagStartMarker, DjangoTemplateParsing templateParser) {
        String tokenText;
        boolean withParsed = false;
        boolean trimmedParsed = false;
        boolean asVarParsed = false;
        while (builder.getTokenType() != DjangoTemplateTokenTypes.DJANGO_TAG_END && (tokenText = builder.getTokenText()) != null) {
            if ("asvar".equals(tokenText)) {
                if (asVarParsed || withParsed || trimmedParsed) {
                    builder.error(DjangoBundle.message("django.parse.error.as.var.should.be.the.first.argument.of.tag", new Object[0]));
                } else {
                    asVarParsed = true;
                }
                builder.advanceLexer();
                if (templateParser.parseId()) continue;
                builder.error(DjangoBundle.message("django.parse.error.id.lowercase.expected", new Object[0]));
                continue;
            }
            if ("trimmed".equals(tokenText)) {
                if (withParsed) {
                    builder.error(DjangoBundle.message("django.parse.error.trimmed.should.be.the.first.argument.of.tag", new Object[0]));
                } else if (trimmedParsed) {
                    builder.error(DjangoBundle.message("django.parse.error.trimmed.argument.duplicated", new Object[0]));
                } else {
                    trimmedParsed = true;
                }
                builder.advanceLexer();
                continue;
            }
            if (withParsed || asVarParsed || this.isBlocktransKeyword(tokenText)) {
                if (tokenText.equals("with")) {
                    withParsed = true;
                }
                if (withParsed && !this.isBlocktransKeyword(tokenText)) {
                    if (!templateParser.isId()) {
                        builder.error(DjangoBundle.message("django.parse.error.id.expected", new Object[0]));
                        builder.advanceLexer();
                        break;
                    }
                } else {
                    builder.advanceLexer();
                }
                if (!templateParser.isIdOrLiteral()) {
                    builder.error(DjangoBundle.message("django.parse.error.id.or.literal.expected", new Object[0]));
                    builder.advanceLexer();
                    continue;
                }
                boolean isId = false;
                if (templateParser.isId()) {
                    isId = true;
                }
                if (templateParser.isId() && builder.lookAhead(1) == DjangoTemplateTokenTypes.ASSIGN) {
                    templateParser.parseNamedExpr();
                    templateParser.advance();
                    templateParser.parseMemberLiteral();
                    continue;
                }
                templateParser.parseMemberLiteral();
                if (templateParser.hasTokenType(DjangoTemplateTokenTypes.AS, new IElementType[0])) {
                    builder.advanceLexer();
                    templateParser.parseNamedExpr();
                    continue;
                }
                if (!isId) {
                    builder.error(DjangoBundle.message("django.parse.error.as.expected", new Object[0]));
                    continue;
                }
                builder.error(DjangoBundle.message("django.parse.error.equals.or.as.expected", new Object[0]));
                continue;
            }
            builder.error(DjangoBundle.message("django.parse.error.unknown.subtag.for.blocktrans.found.with.count.or.and.expected", new Object[0]));
            break;
        }
        tagStartMarker.done(DjangoTemplateElementTypes.BLOCKTRANS_TAG);
    }

    private boolean isBlocktransKeyword(String tokenText) {
        return tokenText.equals("with") || tokenText.equals("and") || tokenText.equals("count");
    }
}

