/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.django.manage.DjangoManageTask;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoConsoleExecutor
implements CommandExecutor {
    static final CommandExecutor INSTANCE = new DjangoConsoleExecutor();
    private static final FileSystemFlusher SYSTEM_FLUSHER = new FileSystemFlusher();

    protected DjangoConsoleExecutor() {
    }

    @Override
    public void execute(@NotNull String commandName, @NotNull Module module, @NotNull List<String> parameters, @Nullable ConsoleView consoleView) {
        if (commandName == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(0);
        }
        if (module == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(2);
        }
        VirtualFile manageFile = DjangoUtil.getManageFile(module);
        String projectRoot = DjangoUtil.getProjectRoot(module);
        if (projectRoot == null && manageFile != null) {
            projectRoot = manageFile.getParent().getPath();
        }
        try {
            DjangoManageTask task2 = new DjangoManageTask(module, DjangoBundle.message("manage.run.tab.name", new Object[0]));
            task2.setWorkingDirectory(projectRoot);
            task2.setHelper(PythonHelper.DJANGO_MANAGE);
            ImmutableList.Builder parametersString = new ImmutableList.Builder().add((Object)commandName).addAll(parameters);
            if (!SystemInfo.isWindows) {
                NotNullFunction escaperFunction = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
                projectRoot = (String)escaperFunction.fun((Object)projectRoot);
            }
            parametersString.add((Object)projectRoot);
            task2.setParameters((List<String>)parametersString.build());
            task2.setHelpId("reference.manage.py");
            task2.setAfterCompletion(SYSTEM_FLUSHER);
            task2.run(consoleView);
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((String)DjangoBundle.message("manage.run.error" + e.getMessage(), new Object[0]), (String)DjangoBundle.message("django", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/manage/DjangoConsoleExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileSystemFlusher
    implements Runnable {
        private FileSystemFlusher() {
        }

        @Override
        public void run() {
            LocalFileSystem.getInstance().refresh(true);
        }
    }
}

