/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.django.console.DjangoConsoleOptions;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PyRemoteSdkWithoutSudo;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DjangoManageTask
extends PythonTask {
    public DjangoManageTask(Module module, String runTabTitle) throws ExecutionException {
        super(module, runTabTitle, PyRemoteSdkWithoutSudo.wrapNullable(PythonSdkUtil.findPythonSdk(module)));
    }

    public DjangoManageTask(Module module, String runTabTitle, Sdk sdk) throws ExecutionException {
        super(module, runTabTitle, sdk);
    }

    @Override
    protected List<String> setupPythonPath() {
        PyConsoleOptions.PyConsoleSettings settingsProvider = DjangoConsoleOptions.getInstance(this.myModule.getProject()).getState();
        List<String> strings = this.setupPythonPath(settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        DjangoFacet facet = DjangoFacet.getInstance(this.myModule);
        if (facet != null) {
            String djangoPath = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath();
            this.setWorkingDirectory(djangoPath);
            strings.add(djangoPath);
        }
        return strings;
    }

    @NotNull
    public final ProcessHandler createProcess() throws ExecutionException {
        Map environment = this.createCommandLine().getEnvironment();
        ProcessHandler processHandler2 = this.createProcess(environment);
        if (processHandler2 == null) {
            DjangoManageTask.$$$reportNull$$$0(0);
        }
        return processHandler2;
    }

    @Override
    public final GeneralCommandLine createCommandLine() {
        GeneralCommandLine cmd = super.createCommandLine();
        DjangoFacet djangoFacet = DjangoFacet.getInstance(this.myModule);
        if (djangoFacet != null) {
            DjangoFacetConfiguration configuration = (DjangoFacetConfiguration)djangoFacet.getConfiguration();
            cmd.getEnvironment().putAll(configuration.getEnvVariables());
            String filePattern = configuration.getTrackFilePattern();
            cmd.getEnvironment().put("PYCHARM_TRACK_FILES_PATTERN", filePattern);
        }
        ApplicationManager.getApplication().runReadAction(() -> DjangoUtil.addDjangoSettingsToEnv(this.myModule, cmd.getEnvironment()));
        return cmd;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/manage/DjangoManageTask", "createProcess"));
    }
}

