/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoClosingTagTools {
    private static final Pattern END_TAG_PATTERN = Pattern.compile("^end_?(.+)$");

    private DjangoClosingTagTools() {
    }

    @Nullable
    public static String getOpeningByClosing(@NotNull String closingTagName) {
        Matcher matcher;
        if (closingTagName == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(0);
        }
        if ((matcher = END_TAG_PATTERN.matcher(closingTagName)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    public static String getOpeningByClosingIfPossible(@NotNull String closingTagName) {
        String result;
        if (closingTagName == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(1);
        }
        String string = (result = DjangoClosingTagTools.getOpeningByClosing(closingTagName)) != null ? result : closingTagName;
        if (string == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String suggestClosingTag(@NotNull String openingTagName) {
        if (openingTagName == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(3);
        }
        String string = openingTagName.contains("_") ? String.format("end_%s", openingTagName) : String.format("end%s", openingTagName);
        if (string == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isStartsWithEndPrefix(@NotNull String tagName) {
        if (tagName == null) {
            DjangoClosingTagTools.$$$reportNull$$$0(5);
        }
        return END_TAG_PATTERN.matcher(tagName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingTagName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoClosingTagTools";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTagName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoClosingTagTools";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpeningByClosingIfPossible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestClosingTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOpeningByClosing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOpeningByClosingIfPossible";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestClosingTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStartsWithEndPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

