/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.lang.template.DjangoCustomTagsLoadingRecursiveVisitor;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.ref.DjangoLoadedNameReference;
import com.jetbrains.django.lang.template.tags.DjangoLoadTag;
import com.jetbrains.django.model.TemplateLanguageTagLibrary;
import com.jetbrains.django.model.modelApi.templates.DjangoTemplateEngineSettings;
import com.jetbrains.django.model.modelApi.templates.PyTemplateEngineSettings;
import com.jetbrains.django.util.DjangoFileUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.pyi.PyiFile;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTagLibrary
implements TemplateLanguageTagLibrary {
    @NonNls
    private static final String SIMPLE_TAG_METHOD = "simple_tag";
    @NonNls
    private static final String ASSIGNMENT_TAG_METHOD = "assignment_tag";
    @NonNls
    private static final String TAG_METHOD = "tag";
    @NonNls
    private static final String INCLUSION_TAG_METHOD = "inclusion_tag";
    @NonNls
    private static final String FILTER_METHOD = "filter";
    @NonNls
    private static final String STRINGFILTER_METHOD = "stringfilter";
    public static final String TAKES_CONTEXT = "takes_context";
    private Set<String> myTags;
    private final Set<String> myBlockTags = ImmutableSet.of((Object)"for", (Object)"block", (Object)"filter", (Object)"spaceless", (Object)"with", (Object)"autoescape", (Object[])new String[]{"comment", "blocktrans", "cache", "verbatim"});
    private static final String[] FOR_LOOP_ATTRIBUTES = new String[]{"counter", "counter0", "revcounter", "revcounter0", "first", "last", "parentloop"};
    private static final String[] IF_INNER_TAGS = new String[]{"else", "elif"};
    private static final String[] FOR_INNER_TAGS = new String[]{"empty"};
    private static final String[] BLOCKTRANS_INNER_TAGS = new String[]{"plural"};
    private static final String[] THUMBNAIL_INNER_TAGS = new String[]{"empty"};

    @Override
    public Collection<String> getCoreTags() {
        if (this.myTags == null) {
            this.loadTags();
        }
        return this.myTags;
    }

    private void loadTags() {
        try {
            this.myTags = DjangoFileUtil.readFileLines(this.getClass(), "tags.txt");
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read tag names");
        }
    }

    @Override
    public boolean isBlockTag(String name) {
        return this.myBlockTags.contains(name);
    }

    @Override
    public String[] getInnerTags(String tagName) {
        if (tagName.equals("if")) {
            return IF_INNER_TAGS;
        }
        if (tagName.equals("for")) {
            return FOR_INNER_TAGS;
        }
        if (tagName.equals("blocktrans")) {
            return BLOCKTRANS_INNER_TAGS;
        }
        if (tagName.equals("thumbnail")) {
            return THUMBNAIL_INNER_TAGS;
        }
        if (tagName.equals("ifchanged") || tagName.equals("ifequal") || tagName.equals("ifnotequal")) {
            return new String[]{"else"};
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getForLoopIterator() {
        return "forloop";
    }

    @Override
    public String[] getForLoopAttributes() {
        return FOR_LOOP_ATTRIBUTES;
    }

    @Override
    public Collection<String> collectLoadedTags(PsiFile template) {
        final HashSet<String> result = new HashSet<String>();
        DjangoTagLibrary.processLoadedTags(template, new TagProcessor(){

            @Override
            public void processTag(String name, PyElement declaration) {
                result.add(name);
            }
        }, true);
        return result;
    }

    @Override
    public Collection<Pair<String, PyFunction>> collectLoadedFilters(PsiFile template) {
        final HashSet<Pair<String, PyFunction>> result = new HashSet<Pair<String, PyFunction>>();
        DjangoTagLibrary.processLoadedTags(template, new TagProcessor(){

            @Override
            public void processFilter(String name, PyElement declaration) {
                if (name != null && declaration instanceof PyFunction) {
                    result.add(Pair.create((Object)name, (Object)((PyFunction)declaration)));
                }
            }
        }, false);
        return result;
    }

    @Override
    public PsiElement resolveTag(PsiFile template, String tagName) {
        ResolveProcessor processor2 = new ResolveProcessor(tagName, true);
        DjangoTagLibrary.processLoadedTags(template, processor2, true);
        return processor2.myResult;
    }

    @Override
    public PsiElement resolveFilter(PsiFile template, String name) {
        ResolveProcessor processor2 = new ResolveProcessor(name, false);
        DjangoTagLibrary.processLoadedTags(template, processor2, false);
        return processor2.myResult;
    }

    static void processLoadedTags(PsiFile template, final TagProcessor processor2, boolean isTag) {
        Module module;
        QualifiedName defaultsQName = QualifiedName.fromComponents((String[])new String[]{"django", "template", isTag ? "defaulttags" : "defaultfilters"});
        List<PsiElement> elements = ResolveImportUtil.multiResolveModuleInRoots(defaultsQName, (PsiElement)template);
        PsiElement defaultsFile = elements.stream().filter(file2 -> file2 instanceof PyFile && !(file2 instanceof PyiFile)).findFirst().orElseGet(() -> (PsiElement)ContainerUtil.getFirstItem((List)elements));
        if (defaultsFile instanceof PyFile) {
            DjangoTagLibrary.processRegisteredTags((PyFile)defaultsFile, processor2);
        }
        if (processor2.isDone()) {
            return;
        }
        PsiFile psi = template.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE);
        if (psi != null) {
            psi.acceptChildren((PsiElementVisitor)new DjangoCustomTagsLoadingRecursiveVisitor(){

                @Override
                public void visitLoadTag(DjangoLoadTag loadTag) {
                    block4: {
                        super.visitLoadTag(loadTag);
                        if (processor2.isDone()) break block4;
                        if (loadTag.getLoadedNames() != null) {
                            PsiReference[] references2;
                            for (PsiReference ref : references2 = loadTag.getReferences()) {
                                DjangoLoadedNameReference.LoadedTag tag;
                                if (!(ref instanceof DjangoLoadedNameReference) || (tag = ((DjangoLoadedNameReference)ref).resolveLoadedTag()) == null || !tag.isTag()) continue;
                                processor2.process(tag.getName(), tag.getDeclaration(), tag.isTag());
                            }
                        } else {
                            PsiReference[] references3;
                            for (PsiReference reference : references3 = loadTag.getReferences()) {
                                PsiElement tagsFile = reference.resolve();
                                if (!(tagsFile instanceof PyFile)) continue;
                                DjangoTagLibrary.processRegisteredTags((PyFile)tagsFile, processor2);
                            }
                        }
                    }
                }
            });
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)template.getOriginalFile())) != null) {
            List builtins = StreamEx.of(PyTemplateEngineSettings.getSettings(module)).select(DjangoTemplateEngineSettings.class).flatMap(settings -> settings.getBuiltins().stream()).toList();
            builtins.forEach(location -> {
                List<PsiElement> result = ResolveImportUtil.multiResolveModuleInRoots(QualifiedName.fromDottedString((String)location), (PsiElement)template);
                PsiElement f = result.stream().filter(file2 -> file2 instanceof PyFile && !(file2 instanceof PyiFile)).findFirst().orElseGet(() -> (PsiElement)ContainerUtil.getFirstItem((List)result));
                if (f instanceof PyFile) {
                    DjangoTagLibrary.processRegisteredTags((PyFile)f, processor2);
                }
            });
        }
    }

    public static void processRegisteredTags(PyFile file2, TagProcessor processor2) {
        file2.acceptChildren(new RegisteredTagCollector(processor2));
    }

    @Nullable
    private static String getRegisterMethodName(PyCallExpression node) {
        PyReferenceExpression referenceExpression;
        PyExpression qualifier;
        PyExpression callee = node.getCallee();
        if (callee instanceof PyReferenceExpression && (qualifier = (referenceExpression = (PyReferenceExpression)callee).getQualifier()) != null && qualifier.getText().equals("register")) {
            return referenceExpression.getReferencedName();
        }
        return null;
    }

    private static class ResolveProcessor
    extends TagProcessor {
        private final String myName;
        private final boolean myTag;
        private PsiElement myResult;

        ResolveProcessor(String name, boolean isTag) {
            this.myName = name;
            this.myTag = isTag;
        }

        @Override
        public void processTag(@Nullable String name, PyElement declaration) {
            if (name != null && name.equals(this.myName) && this.myTag) {
                this.myResult = declaration;
            }
        }

        @Override
        public void processFilter(@Nullable String name, PyElement declaration) {
            if (name != null && name.equals(this.myName) && !this.myTag) {
                this.myResult = declaration;
            }
        }

        @Override
        public boolean isDone() {
            return this.myResult != null;
        }
    }

    public static abstract class TagProcessor {
        private boolean myDone = false;

        public void processTag(@Nullable String name, PyElement declaration) {
        }

        public void processFilter(@Nullable String name, PyElement declaration) {
        }

        public void process(String name, PyElement declaration, boolean isTag) {
            if (isTag) {
                this.processTag(name, declaration);
            } else {
                this.processFilter(name, declaration);
            }
        }

        public boolean isDone() {
            return this.myDone;
        }

        public void setDone(boolean done) {
            this.myDone = done;
        }
    }

    private static class RegisteredTagCollector
    extends PyRecursiveElementVisitor {
        private final TagProcessor myProcessor;

        RegisteredTagCollector(TagProcessor processor2) {
            this.myProcessor = processor2;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                RegisteredTagCollector.$$$reportNull$$$0(0);
            }
            if (this.myProcessor.isDone()) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            this.processPossibleTagElement(node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            this.processPossibleTagElement(node);
        }

        private <T extends PyDecoratable & PyElement> void processPossibleTagElement(@NotNull T node) {
            PyDecoratorList decoratorList;
            if (node == null) {
                RegisteredTagCollector.$$$reportNull$$$0(1);
            }
            if ((decoratorList = node.getDecoratorList()) != null) {
                PyDecorator[] decorators;
                for (PyDecorator decorator : decorators = decoratorList.getDecorators()) {
                    String methodName = DjangoTagLibrary.getRegisterMethodName(decorator);
                    if (DjangoTagLibrary.SIMPLE_TAG_METHOD.equals(methodName) || DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName) || DjangoTagLibrary.TAG_METHOD.equals(methodName) || DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName)) {
                        this.processRegisterDecorator(node, decorator, true);
                        continue;
                    }
                    if (!DjangoTagLibrary.FILTER_METHOD.equals(methodName)) continue;
                    this.processRegisterDecorator(node, decorator, false);
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            super.visitPyCallExpression(node);
            String methodName = DjangoTagLibrary.getRegisterMethodName(node);
            PyExpression[] args2 = node.getArguments();
            if (DjangoTagLibrary.TAG_METHOD.equals(methodName) && args2.length >= 1) {
                this.processRegisterCall(args2, true);
            } else if ((DjangoTagLibrary.SIMPLE_TAG_METHOD.equals(methodName) || DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName) || DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName)) && args2.length >= 1) {
                PsiElement func;
                PsiReference reference;
                PyCallExpression parent;
                PyExpression funcRef;
                PyTypedElement declaration = funcRef = args2[0];
                if (DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName)) {
                    if (funcRef instanceof PyKeywordArgument && DjangoTagLibrary.TAKES_CONTEXT.equals(((PyKeywordArgument)funcRef).getKeyword()) && node.getParent() instanceof PyCallExpression && (parent = (PyCallExpression)node.getParent()).getArguments().length > 0) {
                        funcRef = parent.getArguments()[0];
                    }
                } else if (DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName) && node.getParent() instanceof PyCallExpression && (parent = (PyCallExpression)node.getParent()).getArguments().length > 0) {
                    funcRef = parent.getArguments()[0];
                }
                String name = null;
                if (funcRef instanceof PyReferenceExpression && (reference = funcRef.getReference()) != null && (func = reference.resolve()) instanceof PyFunction) {
                    name = ((PyFunction)func).getName();
                    declaration = (PyFunction)func;
                }
                if (args2.length > 1 && args2[1] instanceof PyKeywordArgument && "name".equals(((PyKeywordArgument)args2[1]).getKeyword())) {
                    name = PyStringLiteralUtil.getStringValue((PsiElement)((PyKeywordArgument)args2[1]).getValueExpression());
                }
                if (!StringUtil.isEmpty(name)) {
                    this.foundTag(name, declaration);
                }
            } else if (DjangoTagLibrary.FILTER_METHOD.equals(methodName) && args2.length >= 1) {
                this.processRegisterCall(args2, false);
            }
        }

        private void processRegisterDecorator(PyElement node, PyDecorator decorator, boolean isTag) {
            String name = node.getName();
            PyArgumentList args2 = decorator.getArgumentList();
            if (args2 != null) {
                String val;
                PyKeywordArgument nameArg = args2.getKeywordArgument("name");
                if (nameArg != null) {
                    name = PyPsiUtils.strValue(nameArg.getValueExpression());
                } else if (args2.getArguments().length > 0 && !(args2.getArguments()[0] instanceof PyKeywordArgument) && RegisteredTagCollector.isTagOrFilter(decorator.getName()) && !StringUtil.isEmpty((String)(val = PyPsiUtils.strValue(args2.getArguments()[0])))) {
                    name = val;
                }
            }
            if (!StringUtil.isEmpty((String)name)) {
                if (isTag) {
                    this.foundTag(name, node);
                } else {
                    this.myProcessor.processFilter(name, node);
                }
            }
        }

        private static boolean isTagOrFilter(String name) {
            return DjangoTagLibrary.FILTER_METHOD.equals(name) || DjangoTagLibrary.TAG_METHOD.equals(name);
        }

        private void processRegisterCall(PyExpression[] args2, boolean isTag) {
            PyExpression impl;
            PyExpression pyExpression = impl = args2.length > 1 ? args2[1] : args2[0];
            if (impl instanceof PyReferenceExpression && impl.getReference() != null) {
                PyExpression[] stringfilterArgs;
                PyExpression value2;
                Object declaration = impl.getReference().resolve();
                String name = null;
                if (args2.length > 1 && args2[0] instanceof PyStringLiteralExpression) {
                    name = ((PyStringLiteralExpression)args2[0]).getStringValue();
                }
                if (declaration instanceof PyTargetExpression && (value2 = ((PyTargetExpression)declaration).findAssignedValue()) instanceof PyCallExpression && ((PyCallExpression)value2).isCalleeText(DjangoTagLibrary.STRINGFILTER_METHOD) && (stringfilterArgs = ((PyCallExpression)value2).getArguments()).length == 1 && (declaration = stringfilterArgs[0]) instanceof PyReferenceExpression && declaration.getReference() != null) {
                    declaration = declaration.getReference().resolve();
                }
                if (declaration instanceof PyFunction && name == null) {
                    name = ((PyFunction)declaration).getName();
                }
                if (name != null && declaration != null) {
                    if (isTag) {
                        this.foundTag(name, (PyElement)declaration);
                    } else {
                        this.myProcessor.processFilter(name, (PyElement)declaration);
                    }
                }
            }
        }

        private void foundTag(String name, PyElement declaration) {
            this.myProcessor.processTag(name, declaration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/model/DjangoTagLibrary$RegisteredTagCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processPossibleTagElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

