/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.templateLanguages.TemplateContextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateParametersEvaluator {
    private static final Set<String> TEMPLATE_METHODS_FIRST_ARG = Sets.newHashSet((Object[])new String[]{"get_template", "load_template", "load_template_source", "find_template", "find_template_source", "render_to_string", "render_to_response", "inclusion_tag"});
    private static final Set<String> TEMPLATE_METHODS_SECOND_ARG = Sets.newHashSet((Object[])new String[]{"direct_to_template", "render", "TemplateResponse", "SimpleTemplateResponse"});

    private TemplateParametersEvaluator() {
    }

    public static boolean isRenderDecorator(@NotNull PyCallExpression call) {
        String name;
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(0);
        }
        if ((name = call.getName()) == null) {
            return false;
        }
        return name.contains("render") && call instanceof PyDecorator;
    }

    @NotNull
    public static Collection<LookupElement> getTemplateContext(PsiFile template) {
        HashMap result = Maps.newHashMap();
        for (TemplateContextProvider provider : TemplateContextProvider.EP_NAME.getExtensionList()) {
            Collection<LookupElement> params = provider.getTemplateContext(template);
            if (params == null) continue;
            for (LookupElement el : params) {
                result.put(el.getLookupString(), el);
            }
        }
        Collection<LookupElement> collection = result.values();
        if (collection == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static List<String> getMultiCallableName(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.map(call.multiResolveCalleeFunction(PyResolveContext.defaultContext()), NavigationItem::getName);
        if (list == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<String> getMultiFullCallableName(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PyCallable callable : call.multiResolveCalleeFunction(PyResolveContext.defaultContext())) {
            String name = callable.getName();
            String fullName = Optional.ofNullable(callable.getContainingFile()).map(PsiFile::getVirtualFile).map(virtualFile2 -> QualifiedNameFinder.findShortestImportableName((PsiElement)callable, virtualFile2) + "." + name).orElse(name);
            result.add(fullName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static String getCalleeName(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(6);
        }
        if ((callee = call.getCallee()) == null) {
            return null;
        }
        return callee.getName();
    }

    public static boolean isDirectMethod(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(7);
        }
        return "direct_to_template".equals(TemplateParametersEvaluator.getCalleeName(call));
    }

    public static boolean isShortcutsRender(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(8);
        }
        return "render".equals(TemplateParametersEvaluator.getCalleeName(call));
    }

    public static boolean isRenderMethod(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(9);
        }
        return "render_to_response".equals(TemplateParametersEvaluator.getCalleeName(call));
    }

    public static boolean isMakoTemplateCall(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(10);
        }
        return (callee = call.getCallee()) != null && "Template".equals(callee.getText()) && TemplateParametersEvaluator.getMultiCallableName(call).contains("__init__");
    }

    public static boolean isTemplateValueInPatternsCall(PyStringLiteralExpression strLiteral) {
        PyCallExpression call = DjangoPsiUtil.getPatternCall(strLiteral);
        if (call == null) {
            return false;
        }
        return TemplateParametersEvaluator.isTemplateDictValue(strLiteral, "template", "template_name");
    }

    public static boolean isTemplateValueInRenderDecorated(PyStringLiteralExpression strLiteral) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList != null) {
            PyDecorator[] decorators = decoratorList.getDecorators();
            boolean flag = false;
            for (PyDecorator decorator : decorators) {
                if (!TemplateParametersEvaluator.isRenderDecorator(decorator)) continue;
                flag = true;
            }
            if (flag) {
                return TemplateParametersEvaluator.isTemplateDictValue(strLiteral, "TEMPLATE");
            }
            return false;
        }
        return false;
    }

    public static boolean isTemplateDictValue(PyStringLiteralExpression strLiteral, String ... keyNames) {
        PyDictLiteralExpression dict = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyDictLiteralExpression.class);
        if (dict != null) {
            for (PyKeyValueExpression exp : dict.getElements()) {
                String val = PyStringLiteralUtil.getStringValue((PsiElement)exp.getKey());
                for (String key : keyNames) {
                    if (!key.equals(val)) continue;
                    return strLiteral == exp.getValue();
                }
            }
        }
        return false;
    }

    public static boolean isTemplateNameArg(PyStringLiteralExpression strLiteral) {
        PyCallExpression asViewCall = NameResolverTools.findCallExpParent(strLiteral, DjangoFQNamesProvider.TEMPLATE_AS_VIEW_FUNCTION);
        if (asViewCall == null) {
            return false;
        }
        return strLiteral.equals(asViewCall.getArgument(DjangoFunctionParams.AS_VIEW_TEMPLATE_NAME, PyStringLiteralExpression.class));
    }

    public static boolean isTemplateNameInViewClass(NavigatablePsiElement strLiteral) {
        if (!(strLiteral instanceof PyStringLiteralExpression)) {
            return false;
        }
        PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyClass.class);
        if (cls == null) {
            return false;
        }
        if (!DjangoPsiUtil.isTemplateResponseClass(cls)) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)ObjectUtils.tryCast((Object)strLiteral.getParent(), PyAssignmentStatement.class);
        return assignment != null && assignment.isAssignmentTo("template_name");
    }

    @Nullable
    public static PyDictLiteralExpression getArgDict(PsiElement element) {
        PyCallExpression call = DjangoPsiUtil.getUrlCall(element);
        if (call != null && call.getArguments().length >= 3 && call.getArguments()[2] instanceof PyDictLiteralExpression) {
            return call.getArgument(2, PyDictLiteralExpression.class);
        }
        PyTupleExpression tuple = (PyTupleExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyTupleExpression.class);
        if (tuple != null && tuple.getElements().length >= 3 && tuple.getElements()[2] instanceof PyDictLiteralExpression) {
            return (PyDictLiteralExpression)tuple.getElements()[2];
        }
        return null;
    }

    static boolean isTemplateMethod(@NotNull String name, int argument) {
        if (name == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(11);
        }
        if (argument < 0 || argument > 1) {
            return false;
        }
        return (argument == 0 ? TEMPLATE_METHODS_FIRST_ARG : TEMPLATE_METHODS_SECOND_ARG).contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/TemplateParametersEvaluator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/TemplateParametersEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCallableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiFullCallableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRenderDecorator";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCallableName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMultiFullCallableName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isShortcutsRender";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRenderMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMakoTemplateCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

