/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.stubs;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.django.model.stubs.DjangoForeignKeyStubType;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DjangoForeignKeyStub
implements CustomTargetExpressionStub {
    private final StringRef myForeignKeyClass;

    public DjangoForeignKeyStub(StringRef foreignKeyClass) {
        this.myForeignKeyClass = foreignKeyClass;
    }

    public String getForeignKeyClass() {
        return this.myForeignKeyClass.getString();
    }

    @Override
    @NotNull
    public Class<? extends CustomTargetExpressionStubType> getTypeClass() {
        return DjangoForeignKeyStubType.class;
    }

    @Override
    public void serialize(StubOutputStream stream) throws IOException {
        stream.writeName(this.myForeignKeyClass.getString());
    }

    @Override
    public QualifiedName getCalleeName() {
        return QualifiedName.fromDottedString((String)"django.db.models.fields.related.ForeignKey");
    }

    public static DjangoForeignKeyStub deserialize(StubInputStream stream) throws IOException {
        return new DjangoForeignKeyStub(stream.readName());
    }
}

