/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoReferenceUtil {
    private DjangoReferenceUtil() {
    }

    @Nullable
    public static PsiDirectory getDjangoRoot(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            DjangoReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((file2 = DjangoPsiUtil.getFile(element)) == null || file2.getParent() == null) {
            return null;
        }
        PsiDirectory djangoRoot = DjangoUtil.getProjectRoot((PsiFileSystemItem)file2.getParent());
        if (djangoRoot == null) {
            return null;
        }
        return djangoRoot;
    }

    public static List<VirtualFile> getPathVirtualFileList(VirtualFile root, String path) {
        List pathElements = StringUtil.split((String)path, (String)".");
        ArrayList result = Lists.newArrayList();
        for (int i = 0; root != null && i < pathElements.size(); ++i) {
            String name = (String)pathElements.get(i);
            if (root.findChild(name) == null && (i == pathElements.size() - 1 || i == pathElements.size() - 2)) {
                name = name + ".py";
            }
            if ((root = root.findChild(name)) == null) continue;
            result.add(root);
        }
        return result;
    }

    @Nullable
    public static PsiFile findLibraryFile(String path, PsiElement element) {
        VirtualFile file2 = DjangoPythonUtil.findLibraryFile(path, PythonSdkUtil.findPythonSdk(element));
        return file2 != null ? element.getManager().findFile(file2) : null;
    }

    @Nullable
    public static PsiDirectory findLibraryDirectory(String path, PsiElement element) {
        VirtualFile file2 = DjangoPythonUtil.findLibraryFile(path, PythonSdkUtil.findPythonSdk(element));
        return file2 != null ? element.getManager().findDirectory(file2) : null;
    }

    @Nullable
    public static PsiFileSystemItem findLibraryFSItem(String path, PsiElement element) {
        PsiDirectory item = DjangoReferenceUtil.findLibraryDirectory(path, element);
        if (item == null) {
            item = DjangoReferenceUtil.findLibraryFile(path + ".py", element);
        }
        return item;
    }

    @Nullable
    public static PsiFileSystemItem findProjectFSItem(PsiDirectory folder, String filePath) {
        PsiDirectory item = DjangoPsiUtil.findFolder(folder, filePath);
        if (item == null) {
            item = DjangoPsiUtil.findChild(folder, filePath + ".py");
        }
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/django/ref/DjangoReferenceUtil", "getDjangoRoot"));
    }
}

