/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberExpressionImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.ref.ViewMethodReferenceProvider;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ViewParameters {
    private final PsiFile myFile;
    private String myMethodName;
    private PyFile myViewsFile;
    private String myViewsPath;
    private String myFullPath;
    private List<String> myParameters = null;
    private String myUrl;

    ViewParameters(PsiFile file2) {
        this.myFile = file2;
    }

    static ViewParameters fromElement(PsiElement element) {
        ViewParameters result = new ViewParameters(DjangoPsiUtil.getFile(element));
        PyStringLiteralExpression urlElement = ViewParameters.findUrlElement(element);
        if (urlElement != null) {
            result.setUrl(urlElement.getStringValue());
        }
        result.setPath(element);
        if (ViewParameters.isReferenceFromCall(element) || ViewParameters.isReferenceFromUrlTag(element)) {
            String name = element.getText();
            if (!name.contains(".")) {
                result.setMethodName(name);
                PsiDirectory folder = DjangoPsiUtil.getFile(element).getParent();
                result.setViewsFile(folder != null ? folder.findFile("views.py") : null);
            } else {
                result.setViewFromPath(name, element);
            }
        }
        return result;
    }

    private static PyStringLiteralExpression findUrlElement(PsiElement element) {
        if (element.getParent() instanceof PyTupleExpression) {
            PyExpression[] elements = ((PyTupleExpression)element.getParent()).getElements();
            if (elements.length > 1 && element == elements[1] && elements[0] instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)elements[0];
            }
        } else {
            PyExpression[] arguments;
            PyArgumentList argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
            if (argumentList != null && (arguments = argumentList.getArguments()).length > 1 && ViewMethodReferenceProvider.isViewArgument(element, argumentList.getCallExpression()) && arguments[0] instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)arguments[0];
            }
        }
        return null;
    }

    private static boolean isReferenceFromCall(PsiElement element) {
        return element instanceof PyReferenceExpression && element.getParent() instanceof PyArgumentList;
    }

    private static boolean isReferenceFromUrlTag(PsiElement element) {
        return element instanceof DjangoMemberExpressionImpl || element instanceof DjangoStringLiteralImpl;
    }

    @NotNull
    private static String appendPatternsPrefix(@NotNull String path, PsiElement element) {
        if (path == null) {
            ViewParameters.$$$reportNull$$$0(0);
        }
        String prefix = ViewMethodReferenceProvider.getPrefix(element);
        String string = ViewMethodReferenceProvider.withPrefix(path, prefix);
        if (string == null) {
            ViewParameters.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void setPath(PsiElement element) {
        PsiElement el;
        PsiReference ref;
        PyExpression qualifier;
        if (element instanceof PyReferenceExpressionImpl && (qualifier = ((PyReferenceExpressionImpl)element).getQualifier()) != null && (ref = qualifier.getReference()) != null && (el = ref.resolve()) != null) {
            this.setViewsFile(el.getContainingFile());
            this.setMethodName(((PyReferenceExpressionImpl)element).getName());
            return;
        }
        String path = PyStringLiteralUtil.getStringValue(element);
        if (path == null) {
            return;
        }
        path = ViewParameters.appendPatternsPrefix(path, element);
        this.setViewFromPath(path, element);
    }

    private void setViewFromPath(@NotNull String viewMethodPath, PsiElement element) {
        if (viewMethodPath == null) {
            ViewParameters.$$$reportNull$$$0(2);
        }
        this.setFullPath(viewMethodPath);
        int pos = viewMethodPath.lastIndexOf(".");
        if (pos == -1) {
            return;
        }
        String path = viewMethodPath.substring(0, pos);
        String name = viewMethodPath.substring(pos + 1);
        PsiFile viewFile = DjangoUtil.searchFile(path, element);
        if (viewFile != null) {
            this.setMethodName(name);
            this.setViewsPath(path);
            this.setViewsFile(viewFile);
        }
    }

    private void setViewsFile(PsiFile file2) {
        if (file2 instanceof PyFile) {
            this.myViewsFile = (PyFile)file2;
        }
    }

    private void setUrl(String url) {
        this.myUrl = url;
    }

    private void parseParameters() {
        this.myParameters = new ArrayList<String>();
        RegExpFile file2 = (RegExpFile)PsiFileFactory.getInstance((Project)this.myFile.getProject()).createFileFromText("a.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.myUrl);
        file2.acceptChildren((PsiElementVisitor)new RegExpRecursiveElementVisitor(){

            public void visitRegExpGroup(RegExpGroup group2) {
                super.visitRegExpGroup(group2);
                if (group2.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP) {
                    ViewParameters.this.myParameters.add(group2.getGroupName());
                } else {
                    ViewParameters.this.myParameters.add("p" + (ViewParameters.this.myParameters.size() + 1));
                }
            }
        });
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    public void setViewsPath(String viewsPath) {
        this.myViewsPath = viewsPath;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public PyFile getViewsFile() {
        return this.myViewsFile;
    }

    public String getViewsPath() {
        return this.myViewsPath;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public String getFullPath() {
        return this.myFullPath;
    }

    public void setFullPath(String fullPath) {
        this.myFullPath = fullPath;
    }

    public List<String> getParameters() {
        if (this.myParameters == null) {
            this.parseParameters();
        }
        return this.myParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/ViewParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewMethodPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/ViewParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPatternsPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendPatternsPrefix";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setViewFromPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

