/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ui;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.django.lang.template.DjangoTemplateFileType;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonStringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DjangoTemplateFileFactory {
    private static final String DEFAULT_TEMPLATE_EXTENSION = "." + DjangoTemplateFileType.INSTANCE.getDefaultExtension();

    public abstract boolean isValid(@Nullable String var1);

    public abstract PsiFile doCreateTemplate(@NotNull PsiDirectory var1, @NotNull String var2);

    abstract boolean exists(@NotNull PsiDirectory var1, @NotNull String var2);

    @Nullable
    public PsiFile createTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
        if (rootFolder == null) {
            DjangoTemplateFileFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            DjangoTemplateFileFactory.$$$reportNull$$$0(1);
        }
        return this.doCreateTemplate(rootFolder, name);
    }

    public static DjangoTemplateFileFactory fileNameOnly() {
        return new DjangoTemplateFileNameOnly();
    }

    public static DjangoTemplateFileFactory acceptsRelativePath() {
        return new DjangoTemplateFileAcceptsRelativePath();
    }

    private static PsiFile createTemplateFile(PsiDirectory rootFolder, String name) {
        PsiFile file2 = rootFolder.findFile(name);
        if (file2 != null) {
            return file2;
        }
        return (PsiFile)WriteAction.compute(() -> rootFolder.createFile(name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootFolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory";
        objectArray[2] = "createTemplate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DjangoTemplateFileAcceptsRelativePath
    extends DjangoTemplateFileFactory {
        private DjangoTemplateFileAcceptsRelativePath() {
        }

        @Override
        public boolean isValid(@Nullable String name) {
            if (name == null) {
                return false;
            }
            name = FileUtil.toSystemIndependentName((String)name);
            return PythonStringUtil.isPath(name);
        }

        @Override
        boolean exists(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            VirtualFile f;
            if (rootFolder == null) {
                DjangoTemplateFileAcceptsRelativePath.$$$reportNull$$$0(0);
            }
            if (name == null) {
                DjangoTemplateFileAcceptsRelativePath.$$$reportNull$$$0(1);
            }
            return (f = rootFolder.getVirtualFile()).findFileByRelativePath(name) != null;
        }

        @Override
        public PsiFile doCreateTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            if (rootFolder == null) {
                DjangoTemplateFileAcceptsRelativePath.$$$reportNull$$$0(2);
            }
            if (name == null) {
                DjangoTemplateFileAcceptsRelativePath.$$$reportNull$$$0(3);
            }
            name = FileUtil.toSystemIndependentName((String)name);
            List components = StringUtil.split((String)name, (String)"/");
            int i = 0;
            String fileName = null;
            boolean createSubdirs = false;
            for (String cmp : components) {
                if (i < components.size() - 1) {
                    PsiDirectory dir = rootFolder.findSubdirectory(cmp);
                    if (dir == null) {
                        if (createSubdirs || Messages.showOkCancelDialog((String)DjangoBundle.message("django.template.factory.error.missing.dir.message", cmp, FileUtil.toSystemDependentName((String)rootFolder.getVirtualFile().getPath())), (String)DjangoBundle.message("django.template.factory.error.missing.dir.title", cmp), (Icon)Messages.getQuestionIcon()) == 0) {
                            dir = DjangoTemplateFileAcceptsRelativePath.createSubdirectory(rootFolder, cmp);
                            createSubdirs = true;
                        } else {
                            rootFolder = null;
                            break;
                        }
                    }
                    rootFolder = dir;
                } else {
                    fileName = cmp;
                }
                ++i;
            }
            if (rootFolder != null) {
                return DjangoTemplateFileFactory.createTemplateFile(rootFolder, fileName);
            }
            return null;
        }

        private static PsiDirectory createSubdirectory(@NotNull PsiDirectory rootFolder, String cmp) {
            if (rootFolder == null) {
                DjangoTemplateFileAcceptsRelativePath.$$$reportNull$$$0(4);
            }
            return (PsiDirectory)WriteAction.compute(() -> rootFolder.createSubdirectory(cmp));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootFolder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory$DjangoTemplateFileAcceptsRelativePath";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exists";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCreateTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSubdirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DjangoTemplateFileNameOnly
    extends DjangoTemplateFileFactory {
        private DjangoTemplateFileNameOnly() {
        }

        @Override
        public boolean isValid(@Nullable String name) {
            return name != null && PathUtil.isValidFileName((String)name);
        }

        @Override
        public PsiFile doCreateTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            if (rootFolder == null) {
                DjangoTemplateFileNameOnly.$$$reportNull$$$0(0);
            }
            if (name == null) {
                DjangoTemplateFileNameOnly.$$$reportNull$$$0(1);
            }
            return DjangoTemplateFileFactory.createTemplateFile(rootFolder, name);
        }

        @Override
        boolean exists(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            VirtualFile f;
            if (rootFolder == null) {
                DjangoTemplateFileNameOnly.$$$reportNull$$$0(2);
            }
            if (name == null) {
                DjangoTemplateFileNameOnly.$$$reportNull$$$0(3);
            }
            return (f = rootFolder.getVirtualFile()).findChild(name) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootFolder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory$DjangoTemplateFileNameOnly";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCreateTemplate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exists";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

