/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.tags.DjangoIncludeExtendsTag;
import com.jetbrains.django.model.TagLibrary;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateUtil {
    private DjangoTemplateUtil() {
    }

    @Nullable
    public static DjangoTagName getTagNameElement(@NotNull DjangoTagElementImpl tag) {
        PsiElement[] endNames;
        if (tag == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(0);
        }
        if ((endNames = PsiTreeUtil.collectElements((PsiElement)tag, element -> element instanceof DjangoTagName)).length == 1) {
            return (DjangoTagName)endNames[0];
        }
        return null;
    }

    @Nullable
    public static String getTagName(@NotNull DjangoTagElementImpl tag) {
        DjangoTagName tagName;
        if (tag == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(1);
        }
        if ((tagName = DjangoTemplateUtil.getTagNameElement(tag)) != null) {
            return tagName.getTagName();
        }
        return null;
    }

    @Nullable
    public static DjangoTagElementImpl findEndTag(String endTagName, DjangoTagElementImpl startTag) {
        while (startTag != null) {
            DjangoTagName[] endNames = (DjangoTagName[])PsiTreeUtil.getChildrenOfType((PsiElement)startTag, DjangoTagName.class);
            if (endNames != null) {
                for (DjangoTagName tag : endNames) {
                    if (!endTagName.equals(tag.getTagName())) continue;
                    return (DjangoTagElementImpl)tag.getParent();
                }
            }
            startTag = (DjangoTagElementImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)startTag, DjangoTagElementImpl.class);
        }
        return null;
    }

    @NotNull
    public static List<DjangoTagElementImpl> getEndTags(DjangoTagElementImpl tag) {
        ArrayList result = Lists.newArrayList();
        while (tag != null) {
            if (DjangoTemplateUtil.isEndTag(DjangoTemplateUtil.getTagNameElement(tag))) {
                result.add(tag);
            }
            tag = (DjangoTagElementImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, DjangoTagElementImpl.class);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static PsiElement @NotNull [] findElementsBeforeOfType(@NotNull PsiElement parent, int caretOffset, @NotNull Class<?> clazz) {
        PsiElement[] list;
        if (parent == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(4);
        }
        if ((list = PsiTreeUtil.collectElements((PsiElement)parent, e -> {
            if (e == null || !clazz.isInstance(e)) {
                return false;
            }
            return e.getTextOffset() <= caretOffset;
        })) == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<DjangoTagName> getOpenedTags(@NotNull DjangoTagElementImpl tag) {
        if (tag == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(6);
        }
        final ArrayList result = Lists.newArrayList();
        TagLibrary.getInstance(tag.getProject()).processPrecedingOpenedTags((PsiElement)tag, new TagLibrary.OpenTagProcessor(){

            @Override
            public boolean process(@NotNull DjangoTagName tag, boolean open2) {
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (open2) {
                    result.add(tag);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/django/util/DjangoTemplateUtil$1", "process"));
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static TextRange betweenTags(PsiElement start, PsiElement end) {
        TextRange textRange = TextRange.from((int)start.getTextRange().getStartOffset(), (int)(end.getTextRange().getEndOffset() - start.getTextRange().getStartOffset()));
        if (textRange == null) {
            DjangoTemplateUtil.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    public static boolean isEndTag(@Nullable DjangoTagName name) {
        return name != null && name.getTagName().startsWith("end");
    }

    public static PsiElement findParentXmlTag(PsiElement element) {
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (parent.getNode() == null || parent.getNode().getElementType() != DjangoTemplateElementTypes.XML_TAG) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static DjangoIncludeExtendsTag getExtends(PsiFile psiFile) {
        PsiFile element = psiFile.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE);
        if (element == null) {
            return null;
        }
        if ((element = element.getFirstChild()) == null) {
            return null;
        }
        for (PsiElement ee : element.getChildren()) {
            DjangoIncludeExtendsTag extendsTag;
            if (ee.getNode().getElementType() != DjangoTemplateElementTypes.XML_TAG || (extendsTag = (DjangoIncludeExtendsTag)PsiTreeUtil.findChildOfType((PsiElement)ee, DjangoIncludeExtendsTag.class)) == null || !extendsTag.isExtendsTag()) continue;
            return extendsTag;
        }
        return null;
    }

    public static boolean isDjangoTag(@Nullable PsiElement el, String ... names) {
        if (!(el instanceof DjangoTagElementImpl)) {
            return false;
        }
        for (String name : names) {
            if (!name.equals(DjangoTemplateUtil.getTagName((DjangoTagElementImpl)el))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoTemplateUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoTemplateUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsBeforeOfType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenedTags";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "betweenTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementsBeforeOfType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOpenedTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

