/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jinja2.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateParserDefinition;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParser;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.jinja2.Jinja2FileType;
import com.jetbrains.jinja2.lexer.Jinja2Lexer;
import com.jetbrains.jinja2.parsing.Jinja2ElementTypes;
import com.jetbrains.jinja2.parsing.Jinja2TemplateParsing;
import com.jetbrains.jinja2.tags.Jinja2CallTag;
import com.jetbrains.jinja2.tags.Jinja2FromTag;
import com.jetbrains.jinja2.tags.Jinja2FunctionCall;
import com.jetbrains.jinja2.tags.Jinja2ImportTag;
import com.jetbrains.jinja2.tags.Jinja2MacroParameter;
import com.jetbrains.jinja2.tags.Jinja2MacroTag;
import com.jetbrains.jinja2.tags.Jinja2SetTag;
import com.jetbrains.jinja2.tags.Jinja2TestName;
import org.jetbrains.annotations.NotNull;

public class Jinja2ParserDefinition
extends DjangoTemplateParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        return new Jinja2Lexer();
    }

    @Override
    public IFileElementType getFileNodeType() {
        return Jinja2ElementTypes.JINJA2_TEMPLATE_FILE;
    }

    @Override
    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new DjangoTemplateFileImpl(fileViewProvider, Jinja2ElementTypes.JINJA2_TEMPLATE_FILE, (FileType)Jinja2FileType.INSTANCE);
    }

    @Override
    public PsiParser createParser(Project project) {
        return new DjangoTemplateParser(){

            @Override
            protected DjangoTemplateParsing createParsing(PsiBuilder builder) {
                return new Jinja2TemplateParsing(builder);
            }
        };
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == Jinja2ElementTypes.SET_TAG) {
            return new Jinja2SetTag(node);
        }
        if (type == Jinja2ElementTypes.MACRO_TAG) {
            return new Jinja2MacroTag(node);
        }
        if (type == Jinja2ElementTypes.MACRO_PARAMETER) {
            return new Jinja2MacroParameter(node);
        }
        if (type == Jinja2ElementTypes.FROM_TAG) {
            return new Jinja2FromTag(node);
        }
        if (type == Jinja2ElementTypes.IMPORT_TAG) {
            return new Jinja2ImportTag(node);
        }
        if (type == Jinja2ElementTypes.CALL_TAG) {
            return new Jinja2CallTag(node);
        }
        if (type == Jinja2ElementTypes.TEST_NAME) {
            return new Jinja2TestName(node);
        }
        if (type == Jinja2ElementTypes.FUNCTION_CALL) {
            return new Jinja2FunctionCall(node);
        }
        PsiElement psiElement = super.createElement(node);
        if (psiElement == null) {
            Jinja2ParserDefinition.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jinja2/parsing/Jinja2ParserDefinition", "createElement"));
    }
}

