/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jinja2.parsing;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTagParser;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.parsing.parser.TagParserRegistry;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.tags.DjangoBlockTagParser;
import com.jetbrains.django.lang.template.tags.DjangoFilterTagParser;
import com.jetbrains.jinja2.lexer.Jinja2TokenTypes;
import com.jetbrains.jinja2.parsing.Jinja2CallTagParser;
import com.jetbrains.jinja2.parsing.Jinja2ElementTypes;
import com.jetbrains.jinja2.parsing.Jinja2ExpressionTagParser;
import com.jetbrains.jinja2.parsing.Jinja2ForTagParser;
import com.jetbrains.jinja2.parsing.Jinja2FromTagParser;
import com.jetbrains.jinja2.parsing.Jinja2ImportTagParser;
import com.jetbrains.jinja2.parsing.Jinja2IncludeTagParser;
import com.jetbrains.jinja2.parsing.Jinja2MacroTagParser;
import com.jetbrains.jinja2.parsing.Jinja2SetTagParser;
import com.jetbrains.jinja2.parsing.Jinja2WithTagParser;

public class Jinja2TemplateParsing
extends DjangoTemplateParsing {
    private static final TagParserRegistry JINJA2_TAG_PARSER_REGISTRY = new TagParserRegistry<Jinja2TemplateParsing>().with("if", new Jinja2ExpressionTagParser(DjangoTemplateElementTypes.IF_TAG)).with("for", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2ForTagParser()).with("filter", new DjangoFilterTagParser()).with("include", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2IncludeTagParser()).with("extends", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2ExpressionTagParser(DjangoTemplateElementTypes.INCLUDE_EXTENDS_TAG)).with("set", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2SetTagParser()).with("macro", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2MacroTagParser()).with("import", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2ImportTagParser()).with("from", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2FromTagParser()).with("call", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2CallTagParser()).with("with", (DjangoTagParser<Jinja2TemplateParsing>)new Jinja2WithTagParser()).with("block", new DjangoBlockTagParser("scoped"));
    private static final TokenSet STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{DjangoTemplateTokenTypes.DJANGO_TAG_END, Jinja2TokenTypes.TAG_END_TRIM, DjangoTemplateTokenTypes.DJANGO_EXPRESSION_END, DjangoTemplateTokenTypes.FILTER});
    private static final ImmutableSet<String> CONSTANTS = ImmutableSet.of((Object)"true", (Object)"True", (Object)"false", (Object)"False", (Object)"none", (Object)"None", (Object[])new String[0]);

    public Jinja2TemplateParsing(PsiBuilder builder) {
        super(builder, JINJA2_TAG_PARSER_REGISTRY);
    }

    @Override
    protected boolean isTagInjectionStart() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_TAG_START, new IElementType[]{Jinja2TokenTypes.TAG_START_TRIM});
    }

    @Override
    protected boolean isTagInjectionEnd() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_TAG_END, new IElementType[]{Jinja2TokenTypes.TAG_END_TRIM});
    }

    @Override
    protected boolean isExpressionInjectionStart() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START, new IElementType[]{Jinja2TokenTypes.EXPRESSION_START_TRIM});
    }

    @Override
    protected boolean isExpressionInjectionEnd() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_EXPRESSION_END, new IElementType[]{Jinja2TokenTypes.EXPRESSION_END_TRIM});
    }

    @Override
    public boolean parseFilterArguments() {
        return !this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0]) || this.parseArgumentList();
    }

    private boolean parseArgumentList() {
        this.advance();
        if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.advance();
            return true;
        }
        if (!this.parseArgument()) {
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
            this.advance();
            if (this.parseArgument()) continue;
            return false;
        }
        if (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.error("Closing parenthesis expected");
            return false;
        }
        this.advance();
        return true;
    }

    private boolean parseArgument() {
        if (this.hasTokenTypeSequence(new IElementType[]{DjangoTemplateTokenTypes.ID, DjangoTemplateTokenTypes.ASSIGN})) {
            PsiBuilder.Marker kwargMarker = this.mark();
            this.advance();
            this.advance();
            if (!this.parseSingleExpression()) {
                kwargMarker.drop();
                this.error("Expression expected");
                return false;
            }
            kwargMarker.done((IElementType)Jinja2ElementTypes.KEYWORD_ARGUMENT);
            return true;
        }
        if (this.hasTokenType(Jinja2TokenTypes.MUL, new IElementType[0]) || this.hasTokenType(Jinja2TokenTypes.POW, new IElementType[0])) {
            PsiBuilder.Marker starArgMarker = this.mark();
            this.advance();
            if (!this.parseSingleExpression()) {
                this.error("Expression expected");
                starArgMarker.drop();
                return false;
            }
            starArgMarker.done((IElementType)Jinja2ElementTypes.STAR_ARGUMENT);
            return true;
        }
        return this.parseSingleExpression();
    }

    @Override
    protected boolean parseExpression() {
        return this.parseTuple();
    }

    private boolean parseTuple() {
        return this.parseTuple(TokenSet.EMPTY, false, true);
    }

    public boolean parseTuple(TokenSet stopAtTokens, boolean advanceOverStopToken, boolean condexpr) {
        PsiBuilder.Marker tupleStart = this.mark();
        boolean foundComma = false;
        boolean foundExpression = false;
        TokenSet allStopTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{stopAtTokens, STOP_TOKENS});
        while (!this.hasTokenType(allStopTokens)) {
            boolean result;
            boolean bl = result = condexpr ? this.parseSingleExpression() : this.parseOr();
            if (!result) {
                this.error("Expression expected");
                tupleStart.drop();
                return false;
            }
            foundExpression = true;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                foundComma = true;
                continue;
            }
            if (!condexpr && this.hasTokenText("if")) break;
            if (this.hasTokenType(allStopTokens)) continue;
            if (stopAtTokens.getTypes().length <= 0) break;
            this.error("Closing parenthesis expected");
            break;
        }
        if (foundComma || !foundExpression && stopAtTokens.getTypes().length > 0) {
            tupleStart.done((IElementType)Jinja2ElementTypes.TUPLE);
        } else {
            tupleStart.drop();
        }
        if (advanceOverStopToken && this.hasTokenType(stopAtTokens)) {
            this.advance();
        }
        return true;
    }

    public boolean parseSingleExpression() {
        PsiBuilder.Marker condExprStart = this.mark();
        if (!this.parseOr()) {
            condExprStart.drop();
            return false;
        }
        if (this.hasTokenText("if")) {
            this.createTokenElement(Jinja2ElementTypes.SOFT_KEYWORD);
            if (!this.parseOr()) {
                this.error("Expression expected");
                condExprStart.drop();
                return false;
            }
            if (this.hasTokenText("else")) {
                this.createTokenElement(Jinja2ElementTypes.SOFT_KEYWORD);
                if (!this.parseOr()) {
                    this.error("Expression expected");
                    condExprStart.drop();
                    return false;
                }
            }
            condExprStart.done((IElementType)Jinja2ElementTypes.CONDEXPR);
        } else {
            condExprStart.drop();
        }
        return true;
    }

    public boolean parseOr() {
        PsiBuilder.Marker orStart = this.mark();
        if (!this.parseAnd()) {
            orStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.OR, new IElementType[0])) {
            this.advance();
            if (!this.parseAnd()) {
                orStart.drop();
                return false;
            }
            orStart.done((IElementType)Jinja2ElementTypes.BINOP);
            orStart = orStart.precede();
        }
        orStart.drop();
        return true;
    }

    private boolean parseAnd() {
        PsiBuilder.Marker andStart = this.mark();
        if (!this.parseNot()) {
            andStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.AND, new IElementType[0])) {
            this.advance();
            if (!this.parseNot()) {
                andStart.drop();
                return false;
            }
            andStart.done((IElementType)Jinja2ElementTypes.BINOP);
            andStart = andStart.precede();
        }
        andStart.drop();
        return true;
    }

    private boolean parseNot() {
        if (this.hasTokenType(DjangoTemplateTokenTypes.NOT, new IElementType[0])) {
            PsiBuilder.Marker notStart = this.mark();
            this.advance();
            if (!this.parseNot()) {
                notStart.drop();
                return false;
            }
            notStart.done((IElementType)Jinja2ElementTypes.UNARY);
            return true;
        }
        return this.parseCompare();
    }

    private boolean parseCompare() {
        PsiBuilder.Marker compareStart = this.mark();
        if (!this.parseAdd()) {
            compareStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_RELATION_OPERATORS) || this.hasTokenTypeSequence(new IElementType[]{DjangoTemplateTokenTypes.NOT, DjangoTemplateTokenTypes.IN})) {
            if (this.hasTokenTypeSequence(new IElementType[]{DjangoTemplateTokenTypes.NOT, DjangoTemplateTokenTypes.IN})) {
                this.advance();
            }
            this.advance();
            if (!this.parseAdd()) {
                compareStart.drop();
                return false;
            }
            compareStart.done((IElementType)Jinja2ElementTypes.BINOP);
            compareStart = compareStart.precede();
        }
        compareStart.drop();
        return true;
    }

    private boolean parseAdd() {
        PsiBuilder.Marker addStart = this.mark();
        if (!this.parseSub()) {
            addStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.ADD, new IElementType[0])) {
            this.advance();
            if (!this.parseSub()) {
                addStart.drop();
                return false;
            }
            addStart.done((IElementType)Jinja2ElementTypes.BINOP);
            addStart = addStart.precede();
        }
        addStart.drop();
        return true;
    }

    private boolean parseSub() {
        PsiBuilder.Marker subStart = this.mark();
        if (!this.parseConcat()) {
            subStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.SUB, new IElementType[0])) {
            this.advance();
            if (!this.parseConcat()) {
                subStart.drop();
                return false;
            }
            subStart.done((IElementType)Jinja2ElementTypes.BINOP);
            subStart = subStart.precede();
        }
        subStart.drop();
        return true;
    }

    private boolean parseConcat() {
        PsiBuilder.Marker concatStart = this.mark();
        if (!this.parseMul()) {
            concatStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.TILDE, new IElementType[0])) {
            this.advance();
            if (!this.parseMul()) {
                concatStart.drop();
                return false;
            }
            concatStart.done((IElementType)Jinja2ElementTypes.BINOP);
            concatStart = concatStart.precede();
        }
        concatStart.drop();
        return true;
    }

    private boolean parseMul() {
        PsiBuilder.Marker mulStart = this.mark();
        if (!this.parseDiv()) {
            mulStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.MUL, new IElementType[0])) {
            this.advance();
            if (!this.parseDiv()) {
                mulStart.drop();
                return false;
            }
            mulStart.done((IElementType)Jinja2ElementTypes.BINOP);
            mulStart = mulStart.precede();
        }
        mulStart.drop();
        return true;
    }

    private boolean parseDiv() {
        PsiBuilder.Marker divStart = this.mark();
        if (!this.parseFloorDiv()) {
            divStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.SLASH, new IElementType[0])) {
            this.advance();
            if (!this.parseFloorDiv()) {
                divStart.drop();
                return false;
            }
            divStart.done((IElementType)Jinja2ElementTypes.BINOP);
            divStart = divStart.precede();
        }
        divStart.drop();
        return true;
    }

    private boolean parseFloorDiv() {
        PsiBuilder.Marker divStart = this.mark();
        if (!this.parseMod()) {
            divStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.FLOORDIV, new IElementType[0])) {
            this.advance();
            if (!this.parseMod()) {
                divStart.drop();
                return false;
            }
            divStart.done((IElementType)Jinja2ElementTypes.BINOP);
            divStart = divStart.precede();
        }
        divStart.drop();
        return true;
    }

    private boolean parseMod() {
        PsiBuilder.Marker modStart = this.mark();
        if (!this.parsePow()) {
            modStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.MOD, new IElementType[0])) {
            this.advance();
            if (!this.parsePow()) {
                modStart.drop();
                return false;
            }
            modStart.done((IElementType)Jinja2ElementTypes.BINOP);
            modStart = modStart.precede();
        }
        modStart.drop();
        return true;
    }

    private boolean parsePow() {
        PsiBuilder.Marker powStart = this.mark();
        if (!this.parseUnary(true)) {
            powStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.POW, new IElementType[0])) {
            this.advance();
            if (!this.parseUnary(true)) {
                powStart.drop();
                return false;
            }
            powStart.done((IElementType)Jinja2ElementTypes.BINOP);
            powStart = powStart.precede();
        }
        powStart.drop();
        return true;
    }

    private boolean parseUnary(boolean withFilter) {
        if (this.hasTokenType(Jinja2TokenTypes.SUB, new IElementType[0]) || this.hasTokenType(Jinja2TokenTypes.ADD, new IElementType[0])) {
            PsiBuilder.Marker unaryStart = this.mark();
            this.advance();
            if (!this.parseUnary(false)) {
                this.error("Expression expected");
                unaryStart.drop();
                return false;
            }
            unaryStart.done((IElementType)Jinja2ElementTypes.UNARY);
            return true;
        }
        return withFilter ? this.parseWithFilter() : this.parseWithPostfix();
    }

    private boolean parseWithFilter() {
        PsiBuilder.Marker filtersMarker = this.mark();
        if (!this.parseWithPostfix()) {
            filtersMarker.drop();
            return false;
        }
        if (this.hasTokenType(DjangoTemplateTokenTypes.FILTER, new IElementType[0])) {
            while (this.hasTokenType(DjangoTemplateTokenTypes.FILTER, new IElementType[0])) {
                this.advance();
                if (this.parseFilterExpression()) continue;
                this.error("Filter expression expected");
                filtersMarker.drop();
                return false;
            }
            filtersMarker.done(DjangoTemplateElementTypes.FILTERS);
        } else if (this.hasTokenType(Jinja2TokenTypes.IS, new IElementType[0])) {
            this.advance();
            if (this.hasTokenType(DjangoTemplateTokenTypes.NOT, new IElementType[0])) {
                this.advance();
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.ID, new IElementType[0])) {
                this.error("Test name expected");
                filtersMarker.drop();
                return false;
            }
            PsiBuilder.Marker testNameMarker = this.mark();
            this.advance();
            testNameMarker.done((IElementType)Jinja2ElementTypes.TEST_NAME);
            if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                this.parseArgumentList();
            } else if (!(this.hasTokenText("else") || this.hasTokenText("or") || this.hasTokenText("and") || this.hasTokenType(Jinja2TokenTypes.CLOSING_BRACES))) {
                this.parseExpression();
            }
            filtersMarker.done((IElementType)Jinja2ElementTypes.TEST);
        } else {
            filtersMarker.drop();
        }
        return true;
    }

    private boolean parseWithPostfix() {
        PsiBuilder.Marker postfixMarker = this.mark();
        if (!this.parsePrimary()) {
            postfixMarker.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.DOT, new IElementType[0])) {
            this.advance();
            if (!this.parsePrimary()) {
                postfixMarker.drop();
                return false;
            }
            postfixMarker.done(DjangoTemplateElementTypes.MEMBER);
            postfixMarker = postfixMarker.precede();
        }
        postfixMarker.drop();
        return true;
    }

    private boolean parsePrimary() {
        PsiBuilder.Marker exprStart = this.mark();
        boolean result = this.parseIdOrLiteral();
        if (!result) {
            exprStart.drop();
            return false;
        }
        while (true) {
            if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                if (!this.parseArgumentList()) {
                    exprStart.drop();
                    return false;
                }
                exprStart.done((IElementType)Jinja2ElementTypes.FUNCTION_CALL);
                exprStart = exprStart.precede();
                continue;
            }
            if (!this.hasTokenType(Jinja2TokenTypes.LBRACKET, new IElementType[0])) break;
            if (!this.parseSubscription()) {
                exprStart.drop();
                return false;
            }
            exprStart.done((IElementType)Jinja2ElementTypes.SUBSCRIPTION);
            exprStart = exprStart.precede();
        }
        exprStart.drop();
        return true;
    }

    private boolean parseSubscription() {
        while (true) {
            this.advance();
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0]) && !this.parseSingleExpression()) {
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error("Closing bracket, comma or colon expected");
                return false;
            }
            this.advance();
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0]) && !this.parseSingleExpression()) {
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error("Colon expected");
                return false;
            }
            this.advance();
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.parseSingleExpression()) {
                this.error("Expression expected");
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            this.error("Closing bracket or comma expected");
        }
        this.advance();
        return true;
    }

    @Override
    protected boolean isAtExpression() {
        return true;
    }

    @Override
    public boolean isLiteral() {
        return super.isLiteral() || this.hasTokenType(Jinja2TokenTypes.OPENING_BRACES) || this.hasTokenType(Jinja2TokenTypes.FLOAT_LITERAL, new IElementType[0]);
    }

    @Override
    public void parseLiteral() {
        if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
            this.advance();
            this.parseTuple(Jinja2TokenTypes.RPAR_TOKENSET, true, true);
        } else if (this.hasTokenType(Jinja2TokenTypes.LBRACKET, new IElementType[0])) {
            this.parseList();
        } else if (this.hasTokenType(Jinja2TokenTypes.LBRACE, new IElementType[0])) {
            this.parseDict();
        } else if (this.isStringLiteral()) {
            PsiBuilder.Marker literalStart = this.mark();
            while (this.isStringLiteral()) {
                this.advance();
            }
            literalStart.done(DjangoTemplateElementTypes.STRING);
        } else if (this.hasTokenType(Jinja2TokenTypes.FLOAT_LITERAL, new IElementType[0])) {
            this.createTokenElement(DjangoTemplateElementTypes.NUMBER);
        } else {
            super.parseLiteral();
        }
    }

    private void parseList() {
        PsiBuilder.Marker listStart = this.mark();
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) {
            if (!this.parseSingleExpression()) {
                this.error("Expression expected");
                listStart.drop();
                return;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) continue;
            this.error("Closing bracket expected");
            break;
        }
        this.advance();
        listStart.done((IElementType)Jinja2ElementTypes.LIST);
    }

    private void parseDict() {
        PsiBuilder.Marker dictStart = this.mark();
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RBRACE, new IElementType[0])) {
            if (!this.parseSingleExpression()) {
                this.error("Expression expected");
                dictStart.drop();
                return;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error("Colon expected");
                dictStart.drop();
                return;
            }
            this.advance();
            if (!this.parseSingleExpression()) {
                this.error("Expression expected");
                dictStart.drop();
                return;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACE, new IElementType[0])) continue;
            this.error("Closing bracket expected");
            break;
        }
        this.advance();
        dictStart.done((IElementType)Jinja2ElementTypes.DICT);
    }

    @Override
    public boolean parseLogical() {
        return this.parseExpression();
    }

    void parseSignature() {
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            PsiBuilder.Marker paramStart = this.mark();
            if (!this.parseNamedExpr()) {
                this.error("Parameter name expected");
                paramStart.drop();
                break;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.ASSIGN, new IElementType[0])) {
                this.advance();
                if (!this.parseSingleExpression()) {
                    this.error("Default parameter value expected");
                    paramStart.drop();
                    break;
                }
            }
            paramStart.done((IElementType)Jinja2ElementTypes.MACRO_PARAMETER);
            if (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0]) && !this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.error("Comma or closing parenthesis expected");
                break;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) continue;
            this.advance();
        }
        if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.advance();
        }
    }

    void parseContext() {
        if (this.hasTokenText("with") || this.hasTokenText("without")) {
            PsiBuilder.Marker keyword = this.mark();
            this.advance();
            if (!this.hasTokenText("context")) {
                this.error("'context' expected");
            } else {
                this.advance();
            }
            keyword.done((IElementType)Jinja2ElementTypes.SOFT_KEYWORD);
        }
    }

    @Override
    public void parseNameList() {
        while (true) {
            if (this.hasTokenType(ID, new IElementType[0])) {
                PsiBuilder.Marker namedExpression = this.mark();
                this.advance();
                namedExpression.done(DjangoTemplateElementTypes.NAMED_EXPR);
            } else if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                this.advance();
                this.parseNameList();
                if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
                    this.advance();
                } else {
                    this.error("Closing parenthesis expected");
                }
            } else {
                this.error("Identifier expected");
            }
            if (this.tagEnded() || !this.hasTokenType(COMMA, new IElementType[0])) break;
            this.advance();
        }
    }

    @Override
    public boolean parseMemberExpr(IElementType elementType, boolean wrapByMemberAnyway) {
        if (!this.isId()) {
            this.error("ID expected");
            return false;
        }
        String tokenText = this.myPsiBuilder.getTokenText();
        if (CONSTANTS.contains((Object)tokenText)) {
            this.createTokenElement(Jinja2ElementTypes.CONST);
            return true;
        }
        return super.parseMemberExpr(elementType, wrapByMemberAnyway);
    }
}

