/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.highlighting;

import com.google.common.collect.ImmutableMap;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.jetbrains.mako.MakoFileType;
import com.jetbrains.mako.highlighting.MakoSyntaxHighlighter;
import com.jetbrains.python.PythonProBundle;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MakoColorsPage
implements ColorSettingsPage,
InspectionColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(PythonProBundle.message("mako.colors.comment"), MakoSyntaxHighlighter.LINE_COMMENT), new AttributesDescriptor(PythonProBundle.message("mako.colors.control.structure.name"), MakoSyntaxHighlighter.CONTROL_STRUCTURE_ID), new AttributesDescriptor(PythonProBundle.message("mako.colors.tag"), MakoSyntaxHighlighter.TAG), new AttributesDescriptor(PythonProBundle.message("mako.colors.tag.name"), MakoSyntaxHighlighter.TAG_ID), new AttributesDescriptor(PythonProBundle.message("mako.colors.attribute.name"), MakoSyntaxHighlighter.ATTRIBUTE_NAME), new AttributesDescriptor(PythonProBundle.message("mako.colors.attribute.value"), MakoSyntaxHighlighter.ATTRIBUTE_VALUE), new AttributesDescriptor(PythonProBundle.message("mako.colors.substitution.expression"), MakoSyntaxHighlighter.SUBSTITUTION)};
    @NonNls
    private static final Map<String, TextAttributesKey> ourTagToDescriptorMap = ImmutableMap.builder().put((Object)"substitution", (Object)MakoSyntaxHighlighter.SUBSTITUTION).put((Object)"attr_value", (Object)MakoSyntaxHighlighter.ATTRIBUTE_VALUE).build();

    @NotNull
    public String getDisplayName() {
        String string = PythonProBundle.message("mako.colors.name");
        if (string == null) {
            MakoColorsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return MakoFileType.INSTANCE.getIcon();
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            MakoColorsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            MakoColorsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)MakoFileType.INSTANCE, null, null);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            MakoColorsPage.$$$reportNull$$$0(3);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        return "<%inherit file=\"base.html\"/>\n<%\n    rows = [[v for v in range(0,10)] for row in range(0,10)]\n%>\n<table>\n    % for row in rows:\n        <substitution>${makerow(row)}</substitution>\n    % endfor\n</table>\n   \n## and some comment here\n<%def name=\"makerow(row)\">\n    <tr>\n    % for name in row:\n        <td><substitution>${name}</substitution></td>\\\n    % endfor\n    </tr>\n</%def>";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ourTagToDescriptorMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/mako/highlighting/MakoColorsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

