/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.parser.MakoExpressionParsing;
import com.jetbrains.mako.parser.MakoParsingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.StatementParsing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakoParser
implements PsiParser,
MakoElementTypes,
MakoTokenTypes {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        Parsing parsing = new Parsing(builder);
        parsing.parseDocument();
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            MakoParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/parser/MakoParser", "parse"));
    }

    private static class Parsing {
        protected MakoParsingContext myContext;
        private final PsiBuilder myBuilder;
        private final Stack<String> myTagNamesStack = new Stack();
        private final Stack<String> myControlNamesStack = new Stack();

        Parsing(PsiBuilder builder) {
            this.myBuilder = builder;
            this.myContext = new MakoParsingContext(this.myBuilder);
        }

        private void parseDocument() {
            while (!this.myBuilder.eof()) {
                if (this.token() == MakoTokenTypes.SUBSTITUTION_START) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    this.parseSubstitution();
                    this.myContext.popScope();
                    continue;
                }
                if (this.token() == MakoTokenTypes.MAKO_TAG_START) {
                    PsiBuilder.Marker marker = this.mark();
                    this.advance();
                    this.parseTagBlock(marker);
                    this.myTagNamesStack.clear();
                    continue;
                }
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    this.parseControlStructure();
                    this.myContext.popScope();
                    this.myControlNamesStack.clear();
                    continue;
                }
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE_END) {
                    this.error("Closing control structure matches nothing");
                    continue;
                }
                if (this.token() == MakoTokenTypes.MAKO_END_TAG_START) {
                    this.error("Closing mako template tag matches nothing");
                    continue;
                }
                this.advance();
            }
        }

        private void parsePython() {
            if (this.token() == MakoTokenTypes.SUBSTITUTION_START) {
                this.myContext.pushScope(this.myContext.emptyParsingScope());
                this.parseSubstitution();
                this.myContext.popScope();
            } else {
                this.advance();
            }
        }

        private void parseTagBlock(PsiBuilder.Marker openTag) {
            if (this.token() == MakoTokenTypes.MAKO_TAG_END) {
                this.advance();
                openTag.done((IElementType)MakoElementTypes.PYTHON_TAG);
            } else if (this.token() == MakoTokenTypes.MAKO_TAG_NAME) {
                this.parseTag(openTag);
            } else {
                if (this.token() == MakoTokenTypes.PYTHON_CODE) {
                    this.advance();
                }
                StatementParsing statementParser = this.myContext.getPyStatementParser();
                if (this.token() == PyTokenTypes.STATEMENT_BREAK) {
                    this.advance();
                }
                while (this.token() != MakoTokenTypes.MAKO_TAG_END && !this.myBuilder.eof()) {
                    if (this.token() == MakoTokenTypes.SUBSTITUTION_START) {
                        this.myContext.pushScope(this.myContext.emptyParsingScope());
                        this.parseSubstitution();
                        this.myContext.popScope();
                    } else {
                        this.myContext.pushScope(this.myContext.emptyParsingScope());
                        statementParser.parseStatement();
                        this.myContext.popScope();
                    }
                    if (this.token() == PyTokenTypes.STATEMENT_BREAK) {
                        this.advance();
                    }
                    if (this.token() != PyTokenTypes.INCONSISTENT_DEDENT && this.token() != PyTokenTypes.DEDENT) continue;
                    this.error("unindent does not match any outer indentation level");
                    break;
                }
                while (this.token() != MakoTokenTypes.MAKO_TAG_END && !this.myBuilder.eof()) {
                    this.advance();
                }
                if (this.token() == MakoTokenTypes.MAKO_TAG_END) {
                    this.advance();
                }
                openTag.done((IElementType)MakoElementTypes.PYTHON_TAG);
            }
        }

        private void parseTag(PsiBuilder.Marker openTag) {
            PsiBuilder.Marker tag;
            String originalTagName = this.parseTagName();
            if (this.parseTagHeader(openTag, originalTagName, tag = openTag.precede())) {
                return;
            }
            this.parseTagContent(tag, originalTagName);
        }

        private boolean parseTagHeader(PsiBuilder.Marker openTag, String originalTagName, PsiBuilder.Marker tag) {
            this.myTagNamesStack.push((Object)originalTagName);
            do {
                if (this.token() == MakoTokenTypes.ATTR_NAME) {
                    String attributeName = this.parseAttribute();
                    if (!this.inFunction(attributeName) || this.token() != MakoTokenTypes.EMPTY_TAG_END) continue;
                    PsiBuilder.Marker statementList = this.mark();
                    statementList.done((IElementType)MakoElementTypes.MAKO_STATEMENT_LIST);
                    continue;
                }
                if (this.token() != MakoTokenTypes.MAKO_COMMA) break;
                this.advance();
            } while (!this.myBuilder.eof());
            if (this.token() == MakoTokenTypes.EMPTY_TAG_END) {
                this.advance();
                openTag.drop();
                Parsing.doneTagOrFunction(tag, originalTagName);
                return true;
            }
            if (this.token() == MakoTokenTypes.TAG_END) {
                this.advance();
                openTag.done((IElementType)MakoElementTypes.OPEN_TAG);
            } else {
                this.error("Mako template tag start is not closed");
                openTag.done((IElementType)MakoElementTypes.OPEN_TAG);
            }
            return false;
        }

        private void parseTagContent(@NotNull PsiBuilder.Marker tag, @NotNull String originalTagName) {
            if (tag == null) {
                Parsing.$$$reportNull$$$0(0);
            }
            if (originalTagName == null) {
                Parsing.$$$reportNull$$$0(1);
            }
            PsiBuilder.Marker statementList = this.mark();
            while (!this.myBuilder.eof()) {
                IElementType tt = this.token();
                if (tt == MakoTokenTypes.MAKO_TAG_START) {
                    PsiBuilder.Marker innerTag = this.mark();
                    this.advance();
                    this.parseTagBlock(innerTag);
                }
                if (this.token() == MakoTokenTypes.MAKO_END_TAG_START) {
                    PsiBuilder.Marker err;
                    statementList.done((IElementType)MakoElementTypes.MAKO_STATEMENT_LIST);
                    PsiBuilder.Marker footer = this.mark();
                    this.advance();
                    if (this.token() == MakoTokenTypes.MAKO_TAG_NAME) {
                        String endName = this.parseTagName();
                        if (!originalTagName.equals(endName)) {
                            boolean hasChancesToMatch = this.myTagNamesStack.contains((Object)endName);
                            if (hasChancesToMatch) {
                                footer.rollbackTo();
                                PsiBuilder.Marker err2 = this.mark();
                                err2.error(PythonProBundle.message("mako.element.is.not.closed", originalTagName));
                                Parsing.doneTagOrFunction(tag, originalTagName);
                                return;
                            }
                            if (this.token() == MakoTokenTypes.TAG_END) {
                                this.advance();
                            }
                            footer.done((IElementType)MakoTokenTypes.TAG_END);
                            Parsing.doneTagOrFunction(tag, originalTagName);
                            return;
                        }
                        while (this.token() != MakoTokenTypes.TAG_END && this.token() != MakoTokenTypes.MAKO_TAG_START && this.token() != MakoTokenTypes.MAKO_END_TAG_START && !this.myBuilder.eof()) {
                            this.error("Unexpected token");
                        }
                    } else {
                        err = this.mark();
                        err.error(PythonProBundle.message("mako.closing.tag.name.missing"));
                    }
                    if (this.token() == MakoTokenTypes.TAG_END) {
                        this.advance();
                        footer.done((IElementType)MakoElementTypes.CLOSE_TAG);
                    } else {
                        footer.drop();
                        err = this.mark();
                        err.error(PythonProBundle.message("mako.closing.tag.is.not.done"));
                    }
                    Parsing.doneTagOrFunction(tag, originalTagName);
                    return;
                }
                if (this.token() == MakoTokenTypes.SUBSTITUTION_START) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    this.parseSubstitution();
                    this.myContext.popScope();
                    continue;
                }
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    this.parseControlStructure();
                    this.myContext.popScope();
                    continue;
                }
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE_END) {
                    this.error("Closing control structure matches nothing");
                    continue;
                }
                this.advance();
            }
            statementList.drop();
            PsiBuilder.Marker err = this.mark();
            err.error(PythonProBundle.message("mako.element.is.not.closed", originalTagName));
            tag.drop();
        }

        private static void doneTagOrFunction(@NotNull PsiBuilder.Marker tag, @NotNull String originalTagName) {
            if (tag == null) {
                Parsing.$$$reportNull$$$0(2);
            }
            if (originalTagName == null) {
                Parsing.$$$reportNull$$$0(3);
            }
            if ("def".equals(originalTagName)) {
                tag.done(MakoElementTypes.MAKO_FUNCTION);
            } else {
                tag.done((IElementType)MakoElementTypes.TAG_BLOCK);
            }
        }

        private String parseTagName() {
            String originalTagName = this.myBuilder.getTokenText();
            if (originalTagName == null) {
                originalTagName = "";
            }
            PsiBuilder.Marker tagName = this.mark();
            this.advance();
            if (this.token() == MakoTokenTypes.MAKO_COLON) {
                originalTagName = originalTagName + this.myBuilder.getTokenText();
                this.advance();
                if (this.token() == MakoTokenTypes.MAKO_TAG_NAME) {
                    originalTagName = originalTagName + this.myBuilder.getTokenText();
                    this.advance();
                    tagName.done((IElementType)MakoTokenTypes.MAKO_QUALIFIED_TAG_NAME);
                } else {
                    tagName.drop();
                }
            } else {
                tagName.drop();
            }
            return originalTagName;
        }

        private String parseAttribute() {
            PsiBuilder.Marker att = this.mark();
            String attrName = this.myBuilder.getTokenText();
            this.advance();
            if (this.token() == MakoTokenTypes.MAKO_EQ) {
                this.advance();
                if (this.inFunction(attrName)) {
                    this.parseFunctionAttrValue();
                } else if (this.inCall(attrName)) {
                    this.parseCallAttrValue();
                } else if (this.inNameSpace(attrName)) {
                    this.parseNamespace();
                } else {
                    this.parseAttributeValue();
                }
                att.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE);
            } else {
                att.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE);
            }
            return attrName;
        }

        private void parseNamespace() {
            PsiBuilder.Marker attValue = this.mark();
            if (this.token() == MakoTokenTypes.ATTR_START_DELIM) {
                this.advance();
                if (this.token() == PyTokenTypes.MULT) {
                    this.advance();
                } else {
                    StatementParsing statementParser = this.myContext.getStatementParser();
                    while (this.token() != MakoTokenTypes.ATTR_END_DELIM && !this.myBuilder.eof()) {
                        this.myContext.pushScope(this.myContext.emptyParsingScope());
                        statementParser.parseStatement();
                        this.myContext.popScope();
                    }
                }
                this.advance();
            } else if (this.token() != MakoTokenTypes.TAG_END) {
                this.advance();
            }
            attValue.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE_VALUE);
        }

        private void parseCallAttrValue() {
            PsiBuilder.Marker attValue = this.mark();
            if (this.token() == MakoTokenTypes.ATTR_START_DELIM) {
                this.advance();
                StatementParsing statementParsing = this.myContext.getStatementParser();
                while (this.token() != MakoTokenTypes.ATTR_END_DELIM && !this.myBuilder.eof()) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    statementParsing.parseStatement();
                    this.myContext.popScope();
                }
                this.advance();
            } else if (this.token() != MakoTokenTypes.TAG_END) {
                this.advance();
            }
            attValue.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE_VALUE);
        }

        private void parseFunctionAttrValue() {
            PsiBuilder.Marker attValue = this.mark();
            if (this.token() == MakoTokenTypes.ATTR_START_DELIM) {
                this.advance();
                if (this.token() == PyTokenTypes.IDENTIFIER) {
                    PsiBuilder.Marker functionSignature = this.mark();
                    PsiBuilder.Marker name = this.mark();
                    while (this.token() == PyTokenTypes.IDENTIFIER || this.token() == PyTokenTypes.DOT) {
                        this.advance();
                    }
                    name.done((IElementType)MakoElementTypes.FUNCTION_NAME);
                    FunctionParsing fp = new FunctionParsing(this.myContext);
                    fp.parseParameterList();
                    functionSignature.done((IElementType)MakoElementTypes.FUNCTION_SIGNATURE);
                    if (this.token() == MakoTokenTypes.ATTR_END_DELIM) {
                        this.advance();
                    } else {
                        this.error("Attribute value is not closed");
                    }
                } else {
                    this.error("Function name expected");
                }
            } else if (this.token() != MakoTokenTypes.TAG_END) {
                this.advance();
            }
            attValue.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE_VALUE);
        }

        private void parseAttributeValue() {
            PsiBuilder.Marker attValue = this.mark();
            if (this.token() == MakoTokenTypes.ATTR_START_DELIM) {
                IElementType tt;
                while ((tt = this.token()) != null && tt != MakoTokenTypes.ATTR_END_DELIM) {
                    if (tt == MakoTokenTypes.SUBSTITUTION_START) {
                        this.myContext.pushScope(this.myContext.emptyParsingScope());
                        this.parseSubstitution();
                        this.myContext.popScope();
                        continue;
                    }
                    this.advance();
                }
                if (this.token() == MakoTokenTypes.ATTR_END_DELIM) {
                    this.advance();
                } else {
                    this.error("Attribute value is not closed");
                }
            } else if (this.token() != MakoTokenTypes.TAG_END) {
                this.advance();
            }
            attValue.done((IElementType)MakoElementTypes.TAG_ATTRIBUTE_VALUE);
        }

        private void parseSubstitution() {
            MakoExpressionParsing expressionParsing = new MakoExpressionParsing(this.myContext);
            expressionParsing.parseSubstitution();
        }

        private String getStructureName() {
            String tokenText = this.myBuilder.getTokenText();
            String name = tokenText != null ? tokenText : "%";
            if ((name = StringUtil.trimStart((String)name, (String)"%").trim()).endsWith(":")) {
                name = name.substring(0, name.length() - 1).trim();
            }
            return name;
        }

        private void parseControlStructure() {
            PsiBuilder.Marker marker = this.mark();
            String name = this.getStructureName();
            this.advance();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                while (this.token() == MakoTokenTypes.SUBSTITUTION_START || this.token() == PyTokenTypes.COLON) {
                    this.parsePython();
                }
                marker.drop();
                return;
            }
            this.myControlNamesStack.push((Object)name);
            this.parseControlExpression(name);
            PsiBuilder.Marker statementList = this.mark();
            while (!this.myBuilder.eof()) {
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE) {
                    String structureName = this.getStructureName();
                    if (structureName.equals("else")) {
                        statementList.done((IElementType)MakoElementTypes.MAKO_STATEMENT_LIST);
                        this.advance();
                        this.checkMatches(PyTokenTypes.COLON, "colon expected");
                        statementList = this.mark();
                        continue;
                    }
                    if (structureName.equals("elif")) {
                        statementList.done((IElementType)MakoElementTypes.MAKO_STATEMENT_LIST);
                        this.advance();
                        this.parseControlExpression(structureName);
                        statementList = this.mark();
                        continue;
                    }
                    this.parseControlStructure();
                    continue;
                }
                if (this.token() == MakoTokenTypes.CONTROL_STRUCTURE_END) {
                    boolean hasChancesToMatch;
                    statementList.done((IElementType)MakoElementTypes.MAKO_STATEMENT_LIST);
                    PsiBuilder.Marker footer = marker.precede();
                    String endName = this.myBuilder.getTokenText();
                    String string = endName = endName == null ? "" : endName.substring(1).trim().substring(3);
                    if (!name.equals(endName) && (hasChancesToMatch = this.myControlNamesStack.contains((Object)endName))) {
                        marker.done((IElementType)MakoElementTypes.CONTROL_BLOCK);
                        footer.rollbackTo();
                        this.advance();
                        this.myBuilder.error(PythonProBundle.message("mako.element.is.not.closed", name));
                        return;
                    }
                    this.advance();
                    footer.drop();
                    marker.done((IElementType)MakoElementTypes.CONTROL_BLOCK);
                    return;
                }
                if (this.token() == MakoTokenTypes.SUBSTITUTION_START) {
                    this.myContext.pushScope(this.myContext.getScope().withSuite());
                    this.parseSubstitution();
                    this.myContext.popScope();
                    continue;
                }
                if (this.token() == MakoTokenTypes.MAKO_TAG_START) {
                    PsiBuilder.Marker tagMarker = this.mark();
                    this.advance();
                    this.parseTagBlock(tagMarker);
                    continue;
                }
                if (this.token() == MakoTokenTypes.MAKO_END_TAG_START) {
                    this.error("Closing mako template tag matches nothing");
                    continue;
                }
                if (this.token() == PyTokenTypes.IDENTIFIER || this.token() == PyTokenTypes.LPAR) {
                    this.parseControlExpression(name);
                    continue;
                }
                this.advance();
            }
            this.error("Element " + name + " of mako template is not closed");
            statementList.drop();
            marker.done((IElementType)MakoElementTypes.CONTROL_BLOCK);
        }

        private void parseControlExpression(String name) {
            ExpressionParsing expressionParser = this.myContext.getExpressionParser();
            if ("for".equals(name)) {
                expressionParser.parseExpression(true, true);
                this.checkMatches(PyTokenTypes.IN_KEYWORD, "'in' expected");
            }
            expressionParser.parseExpression();
            this.checkMatches(PyTokenTypes.COLON, "colon expected");
        }

        protected boolean checkMatches(IElementType token, @NotNull String message) {
            if (message == null) {
                Parsing.$$$reportNull$$$0(4);
            }
            if (this.token() == token) {
                this.advance();
                return true;
            }
            this.myBuilder.error(message);
            return false;
        }

        private IElementType token() {
            return this.myBuilder.getTokenType();
        }

        private PsiBuilder.Marker mark() {
            return this.myBuilder.mark();
        }

        private void advance() {
            this.myBuilder.advanceLexer();
        }

        private void error(@Nullable PsiBuilder.Marker marker, @NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(5);
            }
            PsiBuilder.Marker err = this.mark();
            err.error(errorString);
            this.advance();
            if (marker != null) {
                marker.drop();
            }
        }

        private void error(@NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(6);
            }
            this.error(null, errorString);
        }

        private boolean inFunction(String tagName) {
            if (!this.myTagNamesStack.empty()) {
                return ((String)this.myTagNamesStack.peek()).equals("def") && "name".equals(tagName);
            }
            return false;
        }

        private boolean inNameSpace(String tagName) {
            if (!this.myTagNamesStack.empty()) {
                return ((String)this.myTagNamesStack.peek()).equals("namespace") && ("import".equals(tagName) || "module".equals(tagName));
            }
            return false;
        }

        private boolean inCall(String tagName) {
            if (!this.myTagNamesStack.empty()) {
                return ((String)this.myTagNamesStack.peek()).equals("call") && "expr".equals(tagName);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalTagName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorString";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/mako/parser/MakoParser$Parsing";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseTagContent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doneTagOrFunction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMatches";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

