/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.structureView;

import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlTagTreeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import com.jetbrains.mako.structureView.MakoStructureViewElement;
import com.jetbrains.mako.structureView.MakoStructureViewUtil;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class MakoXmlTagTreeElement
extends XmlTagTreeElement {
    private final XmlTag myElement;
    private final TemplateLanguageFileViewProvider myViewProvider;

    public MakoXmlTagTreeElement(XmlTag tag, TemplateLanguageFileViewProvider viewProvider) {
        super(tag);
        this.myElement = tag;
        this.myViewProvider = viewProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        TreeMap<Integer, Object> result = new TreeMap<Integer, Object>();
        Object[] children2 = (PsiElement[])ArrayUtil.reverseArray((Object[])this.myElement.getChildren());
        List<PsiElement> makoTags = MakoStructureViewUtil.findAllElementsInsideOfLanguage((PsiElement)this.myElement, this.myViewProvider, this.myViewProvider.getBaseLanguage());
        for (PsiElement psiElement : children2) {
            if (MakoStructureViewUtil.inMakoTag(psiElement, makoTags) || !(psiElement instanceof XmlTag)) continue;
            result.put(psiElement.getTextOffset(), (Object)new MakoXmlTagTreeElement((XmlTag)psiElement, this.myViewProvider));
        }
        for (PsiElement makoElement : makoTags) {
            void var7_13;
            if (MakoStructureViewUtil.inXmlTag(makoElement, Lists.newArrayList((Object[])children2)) || !(makoElement instanceof MakoCodeBlock) && !(makoElement instanceof MakoTagBlock)) continue;
            NavigatablePsiElement namedElement = (NavigatablePsiElement)makoElement;
            String string = namedElement.getName();
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                String string2 = namedElement.getText();
            }
            if (StringUtil.isEmptyOrSpaces((String)var7_13)) continue;
            result.put(namedElement.getTextOffset(), new MakoStructureViewElement(namedElement, this.myViewProvider));
        }
        Collection<StructureViewTreeElement> collection = result.values();
        if (collection == null) {
            MakoXmlTagTreeElement.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/structureView/MakoXmlTagTreeElement", "getChildrenBase"));
    }
}

