/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.project;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.pyramid.project.PyramidNewProjectSettings;
import com.jetbrains.pyramid.project.PyramidProjectCreatePanel;
import com.jetbrains.pyramid.project.PyramidUtils;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonUltimateIcons;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyramidProjectGenerator
extends PythonProjectGenerator<PyramidNewProjectSettings>
implements PyFrameworkProjectGenerator {
    private static final Logger LOG = Logger.getInstance(PyramidProjectGenerator.class);
    private PyramidProjectCreatePanel myPyramidPanel;

    @Override
    @NotNull
    public String getFrameworkTitle() {
        return "Pyramid";
    }

    @Override
    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        List<PyPackage> packages;
        if (sdk == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(0);
        }
        return PyPsiPackageUtil.findPackage(packages = PyPackageUtil.refreshAndGetPackagesModally(sdk), "pyramid") != null;
    }

    @Override
    public boolean supportsPython3() {
        return true;
    }

    public Icon getLogo() {
        return PythonUltimateIcons.Pyramid.Pyramid_logo;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PythonProBundle.message("pyramid.name");
        if (string == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.myPyramidPanel = new PyramidProjectCreatePanel(baseDir.getName());
        return this.myPyramidPanel.createCenterPanel();
    }

    @Override
    public PyramidNewProjectSettings getProjectSettings() {
        PyramidNewProjectSettings settings = new PyramidNewProjectSettings();
        this.myPyramidPanel.saveSettings(settings);
        return settings;
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull PyramidNewProjectSettings settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(5);
        }
        Sdk sdk = settings.getSdk();
        PyramidProjectGenerator.installFrameworkIfNeeded(project, "cookiecutter", "cookiecutter", sdk, true, () -> {
            if (sdk == null || sdk.getHomePath() == null) {
                PyramidProjectGenerator.showError(PythonProBundle.message("pyramid.create.project.invalid.interpreter"), project);
                return;
            }
            File tempDir = null;
            try {
                tempDir = FileUtil.generateRandomTemporaryPath();
                boolean created = tempDir.mkdir();
                if (!created) {
                    PyramidProjectGenerator.showError(PythonProBundle.message("pyramid.create.project.failed.to.create.temp.dir"), project);
                    return;
                }
                LOG.info("Created temp directory " + tempDir);
                List<String> command = PyramidProjectGenerator.createCookiecutterCommand(baseDir, settings);
                GeneralCommandLine cmd = new GeneralCommandLine().withExePath(sdk.getHomePath()).withParameters(command);
                ProcessOutput output = PySdkUtil.getProcessOutput(cmd, tempDir.getPath(), PySdkUtil.activateVirtualEnv(sdk), 10000);
                if (output.getStderr().isEmpty()) {
                    File rootRepoFile = tempDir.listFiles()[0];
                    for (File file2 : rootRepoFile.listFiles()) {
                        file2.renameTo(Paths.get(baseDir.getPath(), file2.getName()).toFile());
                    }
                } else {
                    PyramidProjectGenerator.showError(output.getStderr(), project);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                PyramidProjectGenerator.showError(PythonProBundle.message("pyramid.create.project.failed.to.initialize"), project);
            }
            finally {
                if (tempDir != null) {
                    boolean deleted = FileUtil.delete((File)tempDir);
                    if (deleted) {
                        LOG.info("Temp dir removed: " + tempDir);
                    } else {
                        LOG.warn("Failed to remove temp directory: " + tempDir);
                    }
                }
            }
        });
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            baseDir.refresh(false, true);
            TemplatesService service = TemplatesService.getInstance(module);
            service.setTemplateLanguage(settings.getTemplateLanguage());
            service.setTemplateFolderPaths(baseDir.getPath() + File.separator + settings.getTemplatesFolder());
            PyramidUtils.createRunConfigurations(module, baseDir);
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiFile readme;
                PsiDirectory baseDirPsi = PsiManager.getInstance((Project)project).findDirectory(baseDir);
                if (baseDirPsi != null && (readme = baseDirPsi.findFile("README.txt")) != null) {
                    readme.navigate(true);
                }
            });
        });
    }

    @NotNull
    private static List<String> createCookiecutterCommand(@NotNull VirtualFile baseDir, @NotNull PyramidNewProjectSettings settings) {
        if (baseDir == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(7);
        }
        List<String> list = Arrays.asList("-m", "cookiecutter", "--no-input", "gh:Pylons/pyramid-cookiecutter-starter", "project_name=" + settings.getProjectName(), "repo_name=" + baseDir.getName(), "template_language=" + settings.getTemplateLanguage().toLowerCase(), "backend=" + settings.getBackend().toLowerCase());
        if (list == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void showError(String errorMessage, Project project) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)PythonProBundle.message("pyramid.create.project.error", errorMessage), (String)PythonProBundle.message("pyramid.create.project")));
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        String projectName;
        if (baseDirPath == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isJavaIdentifier((String)(projectName = PythonStringUtil.getLastSuffix(baseDirPath, String.valueOf(File.separatorChar))))) {
            return new ValidationResult(PythonProBundle.message("pyramid.project.name.validation.error.message"));
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(10);
        }
        return validationResult;
    }

    @Override
    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        String message = PythonProBundle.message("cookiecutter.installation.notification");
        if (this.myPyramidPanel == null) {
            return new ValidationResult(message);
        }
        ValidationResult result = PyTemplatesUtil.checkInstalled(sdk, this.myPyramidPanel.getTemplateLanguage(), "pyramid_");
        if (result != null) {
            return new ValidationResult(message + "<br/>" + result.getErrorMessage());
        }
        return new ValidationResult(message);
    }

    @Override
    public void locationChanged(@NonNls @NotNull String projectName) {
        if (projectName == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(11);
        }
        this.myPyramidPanel.locationChanged(projectName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyramid/project/PyramidProjectGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyramid/project/PyramidProjectGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCookiecutterCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCookiecutterCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

