/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.templates.file;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.pyramid.templates.psi.ChameleonElementTypes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChameleonFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private Set<Language> myLanguages;

    public ChameleonFileViewProvider(PsiManager manager, VirtualFile virtualFile2, boolean physical) {
        super(manager, virtualFile2, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        ChameleonLanguage chameleonLanguage = ChameleonLanguage.INSTANCE;
        if (chameleonLanguage == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(0);
        }
        return chameleonLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language javaScript;
        VirtualFile file2 = this.getVirtualFile();
        FileType type = file2.getFileType();
        if (StdFileTypes.XML == type) {
            XMLLanguage xMLLanguage = XMLLanguage.INSTANCE;
            if (xMLLanguage == null) {
                ChameleonFileViewProvider.$$$reportNull$$$0(1);
            }
            return xMLLanguage;
        }
        if (StdFileTypes.JS == type && (javaScript = Language.findLanguageByID((String)"JavaScript")) != null) {
            Language language = javaScript;
            if (language == null) {
                ChameleonFileViewProvider.$$$reportNull$$$0(2);
            }
            return language;
        }
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(3);
        }
        return hTMLLanguage;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(4);
        }
        return new ChameleonFileViewProvider((PsiManager)this.getManager(), virtualFile2, false);
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myLanguages == null) {
            HashSet<Language> languages = new HashSet<Language>();
            languages.add(this.getBaseLanguage());
            languages.add(this.getTemplateDataLanguage());
            this.myLanguages = languages;
        }
        Set<Language> set = this.myLanguages;
        if (set == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition def;
        if (lang == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(6);
        }
        if ((def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
            if (lang == this.getTemplateDataLanguage()) {
                PsiFileImpl file2 = (PsiFileImpl)def.createFile((FileViewProvider)this);
                file2.setContentElementType((IElementType)ChameleonElementTypes.TEMPLATE_DATA);
                return file2;
            }
            if (lang == ChameleonLanguage.INSTANCE) {
                return def.createFile((FileViewProvider)this);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyramid/templates/file/ChameleonFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyramid/templates/file/ChameleonFileViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

