/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStatementMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int end;
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PyStatementMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            PyStatementMover.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        int offset = editor2.getCaretModel().getOffset();
        SelectionModel selectionModel = editor2.getSelectionModel();
        Document document = editor2.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int start = PyStatementMover.getLineStartSafeOffset((Document)document, (int)lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int n = end = lineEndOffset == 0 ? 0 : lineEndOffset - 1;
        if (selectionModel.hasSelection()) {
            start = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            end = selectionEnd == 0 ? 0 : selectionEnd - 1;
        }
        PsiElement elementToMove1 = PyUtil.findNonWhitespaceAtOffset(file2, start);
        PsiElement elementToMove2 = PyUtil.findNonWhitespaceAtOffset(file2, end);
        if (elementToMove1 == null || elementToMove2 == null) {
            return false;
        }
        if (PyStatementMover.ifInsideString(document, lineNumber, elementToMove1, down)) {
            return false;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)(elementToMove1 = PyStatementMover.getCommentOrStatement(document, elementToMove1)), (PsiElement)(elementToMove2 = PyStatementMover.getCommentOrStatement(document, elementToMove2)), (boolean)false)) {
            elementToMove2 = elementToMove1;
        } else if (PsiTreeUtil.isAncestor((PsiElement)elementToMove2, (PsiElement)elementToMove1, (boolean)false)) {
            elementToMove1 = elementToMove2;
        }
        info.toMove = new MyLineRange(elementToMove1, elementToMove2);
        info.toMove2 = PyStatementMover.getDestinationScope(file2, editor2, down ? elementToMove2 : elementToMove1, down);
        info.indentTarget = false;
        info.indentSource = false;
        return true;
    }

    private static boolean ifInsideString(@NotNull Document document, int lineNumber, @NotNull PsiElement elementToMove1, boolean down) {
        Pair<String, String> quotes;
        int nearLine;
        if (document == null) {
            PyStatementMover.$$$reportNull$$$0(3);
        }
        if (elementToMove1 == null) {
            PyStatementMover.$$$reportNull$$$0(4);
        }
        int start = document.getLineStartOffset(lineNumber);
        int end = document.getLineEndOffset(lineNumber);
        int n = nearLine = down ? lineNumber + 1 : lineNumber - 1;
        if (nearLine >= document.getLineCount() || nearLine <= 0) {
            return false;
        }
        PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToMove1, PyStringLiteralExpression.class);
        if (stringLiteralExpression != null && (quotes = PyStringLiteralUtil.getQuotes(stringLiteralExpression.getText())) != null && (((String)quotes.first).equals("'''") || ((String)quotes.first).equals("\"\"\""))) {
            String text1 = document.getText(TextRange.create((int)start, (int)end)).trim();
            String text2 = document.getText(TextRange.create((int)document.getLineStartOffset(nearLine), (int)document.getLineEndOffset(nearLine))).trim();
            if (!(text1.startsWith((String)quotes.first) || text1.endsWith((String)quotes.second) || text2.startsWith((String)quotes.first) || text2.endsWith((String)quotes.second))) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LineRange getDestinationScope(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull PsiElement elementToMove, boolean down) {
        PyStatementList scope;
        String lineText;
        boolean isEmptyLine;
        int lineNumber;
        Document document;
        if (file2 == null) {
            PyStatementMover.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(6);
        }
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(7);
        }
        if ((document = file2.getViewProvider().getDocument()) == null) {
            return null;
        }
        int offset = down ? elementToMove.getTextRange().getEndOffset() : elementToMove.getTextRange().getStartOffset();
        int n = lineNumber = down ? document.getLineNumber(offset) + 1 : document.getLineNumber(offset) - 1;
        if (PyStatementMover.moveOutsideFile(document, lineNumber)) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int startOffset = document.getLineStartOffset(lineNumber);
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        PsiElement destination = PyStatementMover.getDestinationElement(elementToMove, document, lineEndOffset, down);
        int start = destination != null ? destination.getTextRange().getStartOffset() : lineNumber;
        int end = destination != null ? destination.getTextRange().getEndOffset() : lineNumber;
        int startLine = document.getLineNumber(start);
        int endLine = document.getLineNumber(end);
        if (elementToMove instanceof PyClass || elementToMove instanceof PyFunction) {
            PyStatementList scope2;
            PyElement pyElement = scope2 = statementList == null ? (PyElement)elementToMove.getContainingFile() : statementList;
            if (destination != null) {
                return new ScopeRange(scope2, destination, !down, true);
            }
        }
        if ((isEmptyLine = StringUtil.isEmptyOrSpaces((String)(lineText = document.getText(TextRange.create((int)startOffset, (int)lineEndOffset))))) && PyStatementMover.moveToEmptyLine(elementToMove, down)) {
            return new LineRange(lineNumber, lineNumber + 1);
        }
        ScopeRange scopeRange = PyStatementMover.moveOut(elementToMove, editor2, down);
        if (scopeRange != null) {
            return scopeRange;
        }
        scopeRange = PyStatementMover.moveInto(elementToMove, file2, editor2, down, lineEndOffset);
        if (scopeRange != null) {
            return scopeRange;
        }
        if (elementToMove instanceof PsiComment && PsiTreeUtil.isAncestor((PsiElement)destination, (PsiElement)elementToMove, (boolean)true) || destination instanceof PsiComment) {
            return new LineRange(lineNumber, lineNumber + 1);
        }
        PyElement pyElement = scope = statementList == null ? (PyElement)elementToMove.getContainingFile() : statementList;
        if (elementToMove instanceof PyClass || elementToMove instanceof PyFunction) {
            return new ScopeRange(scope, scope.getFirstChild(), !down, true);
        }
        return new LineRange(startLine, endLine + 1);
    }

    private static boolean moveOutsideFile(@NotNull Document document, int lineNumber) {
        if (document == null) {
            PyStatementMover.$$$reportNull$$$0(8);
        }
        return lineNumber < 0 || lineNumber >= document.getLineCount();
    }

    private static boolean moveToEmptyLine(@NotNull PsiElement elementToMove, boolean down) {
        PyStatementList statementList;
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(9);
        }
        if ((statementList = PyStatementMover.getStatementList(elementToMove)) != null) {
            if (down) {
                PsiElement child = statementList.getLastChild();
                if (elementToMove == child && PsiTreeUtil.getNextSiblingOfType((PsiElement)statementList.getParent(), PyStatementPart.class) != null || child != elementToMove) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return statementList == null;
    }

    private static PyStatementList getStatementList(@NotNull PsiElement elementToMove) {
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(10);
        }
        return (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)elementToMove, PyStatementList.class, (boolean)true, (Class[])new Class[]{PyStatementWithElse.class, PyLoopStatement.class, PyFunction.class, PyClass.class});
    }

    @Nullable
    private static ScopeRange moveOut(@NotNull PsiElement elementToMove, @NotNull Editor editor2, boolean down) {
        PyStatementPart sibling;
        PyStatementList statementList;
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(12);
        }
        if ((statementList = PyStatementMover.getStatementList(elementToMove)) == null) {
            return null;
        }
        if (!(down && statementList.getLastChild() == elementToMove || !down && statementList.getFirstChild() == elementToMove)) {
            return null;
        }
        boolean addBefore = !down;
        PsiElement parent = statementList.getParent();
        PyStatementPart pyStatementPart = sibling = down ? (PyStatementPart)PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, PyStatementPart.class) : (PyStatementPart)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, PyStatementPart.class);
        if (sibling != null) {
            PyStatementList list = sibling.getStatementList();
            return new ScopeRange((PsiElement)list, down ? list.getFirstChild() : list.getLastChild(), !addBefore);
        }
        PsiElement scope = PyStatementMover.getScopeForComment(elementToMove, editor2, parent, !down);
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)statementList, PyStatement.class);
        return scope == null || anchor == null ? null : new ScopeRange(scope, anchor, addBefore);
    }

    private static PsiElement getScopeForComment(@NotNull PsiElement elementToMove, @NotNull Editor editor2, @Nullable PsiElement parent, boolean down) {
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(14);
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyStatementList.class, PyFile.class});
        int offset = elementToMove.getTextOffset();
        PsiElement sibling = elementToMove;
        while (scope != null && elementToMove instanceof PsiComment) {
            PsiElement prevSibling;
            PsiElement psiElement = prevSibling = down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PyStatement.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PyStatement.class);
            if (prevSibling == null || editor2.offsetToLogicalPosition((int)prevSibling.getTextOffset()).column == editor2.offsetToLogicalPosition((int)offset).column) break;
            sibling = scope;
            scope = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PyStatementList.class, PyFile.class});
        }
        return scope;
    }

    @Nullable
    private static LineRange moveInto(@NotNull PsiElement elementToMove, @NotNull PsiFile file2, @NotNull Editor editor2, boolean down, int offset) {
        PsiElement rawElement;
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            PyStatementMover.$$$reportNull$$$0(16);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(17);
        }
        if ((rawElement = PyUtil.findNonWhitespaceAtOffset(file2, offset)) == null) {
            return null;
        }
        return down ? PyStatementMover.moveDownInto(editor2.getDocument(), rawElement) : PyStatementMover.moveUpInto(elementToMove, editor2, rawElement, false);
    }

    @Nullable
    private static LineRange moveUpInto(@NotNull PsiElement elementToMove, @NotNull Editor editor2, @NotNull PsiElement rawElement, boolean down) {
        int start2;
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(19);
        }
        if (rawElement == null) {
            PyStatementMover.$$$reportNull$$$0(20);
        }
        Document document = editor2.getDocument();
        PsiElement element = PyStatementMover.getCommentOrStatement(document, rawElement);
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        PsiElement scopeForComment = statementList == null ? null : PyStatementMover.getScopeForComment(elementToMove, editor2, elementToMove, down);
        PyStatementList statementList2 = PyStatementMover.getStatementList(element);
        int start1 = elementToMove.getTextOffset() - document.getLineStartOffset(document.getLineNumber(elementToMove.getTextOffset()));
        if (start1 != (start2 = element.getTextOffset() - document.getLineStartOffset(document.getLineNumber(element.getTextOffset())))) {
            PyStatementList parent2 = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementList2, PyStatementList.class);
            while (parent2 != scopeForComment && parent2 != null) {
                element = PsiTreeUtil.getParentOfType((PsiElement)statementList2, PyStatement.class);
                statementList2 = parent2;
                parent2 = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)parent2, PyStatementList.class);
            }
        }
        if (statementList2 != null && scopeForComment != statementList2 && (statementList2.getLastChild() == element || statementList2.getLastChild() == elementToMove) && element != null) {
            return new ScopeRange((PsiElement)statementList2, element, false);
        }
        return null;
    }

    @Nullable
    private static LineRange moveDownInto(@NotNull Document document, @NotNull PsiElement rawElement) {
        int number2;
        int number;
        PsiElement element;
        PyStatementList statementList2;
        if (document == null) {
            PyStatementMover.$$$reportNull$$$0(21);
        }
        if (rawElement == null) {
            PyStatementMover.$$$reportNull$$$0(22);
        }
        if ((statementList2 = PyStatementMover.getStatementList(element = PyStatementMover.getCommentOrStatement(document, rawElement))) != null && (number = document.getLineNumber(element.getTextOffset())) == (number2 = document.getLineNumber(statementList2.getParent().getTextOffset()))) {
            return new ScopeRange((PsiElement)statementList2, statementList2.getFirstChild(), true);
        }
        PyStatementPart statementPart = (PyStatementPart)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyStatementPart.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyFunction functionDefinition = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyFunction.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyClass classDefinition = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyClass.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyStatementList list = null;
        if (statementPart != null) {
            list = statementPart.getStatementList();
        } else if (functionDefinition != null) {
            list = functionDefinition.getStatementList();
        } else if (classDefinition != null) {
            list = classDefinition.getStatementList();
        }
        if (list != null) {
            return new ScopeRange((PsiElement)list, list.getFirstChild(), true);
        }
        return null;
    }

    private static PsiElement getDestinationElement(@NotNull PsiElement elementToMove, @NotNull Document document, int lineEndOffset, boolean down) {
        PsiElement sibling;
        if (elementToMove == null) {
            PyStatementMover.$$$reportNull$$$0(23);
        }
        if (document == null) {
            PyStatementMover.$$$reportNull$$$0(24);
        }
        Object destination = PyUtil.findPrevAtOffset(elementToMove.getContainingFile(), lineEndOffset, PsiWhiteSpace.class);
        PsiElement psiElement = sibling = down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)elementToMove, PyStatement.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)elementToMove, PyStatement.class);
        if (destination == null) {
            if (elementToMove instanceof PyClass) {
                destination = sibling;
            } else if (elementToMove instanceof PyFunction) {
                destination = !(sibling instanceof PyClass) ? sibling : null;
            } else {
                return null;
            }
        }
        if (destination instanceof PsiComment) {
            return destination;
        }
        destination = elementToMove instanceof PyClass ? sibling : (elementToMove instanceof PyFunction ? (!(sibling instanceof PyClass) ? sibling : null) : PyStatementMover.getCommentOrStatement(document, sibling == null ? destination : sibling));
        return destination;
    }

    @NotNull
    private static PsiElement getCommentOrStatement(@NotNull Document document, @NotNull PsiElement destination) {
        PsiElement statement;
        if (document == null) {
            PyStatementMover.$$$reportNull$$$0(25);
        }
        if (destination == null) {
            PyStatementMover.$$$reportNull$$$0(26);
        }
        if ((statement = PsiTreeUtil.getParentOfType((PsiElement)destination, PyStatement.class, (boolean)false)) == null) {
            PsiElement psiElement = destination;
            if (psiElement == null) {
                PyStatementMover.$$$reportNull$$$0(27);
            }
            return psiElement;
        }
        if (destination instanceof PsiComment) {
            if (document.getLineNumber(destination.getTextOffset()) == document.getLineNumber(statement.getTextOffset())) {
                destination = statement;
            }
        } else {
            destination = statement;
        }
        PsiElement psiElement = destination;
        if (psiElement == null) {
            PyStatementMover.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    public void beforeMove(@NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(29);
        }
        if (info == null) {
            PyStatementMover.$$$reportNull$$$0(30);
        }
        LineRange toMove = info.toMove;
        LineRange toMove2 = info.toMove2;
        if (toMove instanceof MyLineRange && toMove2 instanceof ScopeRange) {
            PostprocessReformattingAspect.getInstance((Project)editor2.getProject()).disablePostprocessFormattingInside(() -> {
                PsiElement startToMove = ((MyLineRange)toMove).myStartElement;
                PsiElement endToMove = ((MyLineRange)toMove).myEndElement;
                PsiFile file2 = startToMove.getContainingFile();
                SelectionModel selectionModel = editor2.getSelectionModel();
                CaretModel caretModel = editor2.getCaretModel();
                int selectionStart = selectionModel.getSelectionStart();
                boolean isSelectionStartAtCaret = caretModel.getOffset() == selectionStart;
                SelectionContainer selectionLen = PyStatementMover.getSelectionLenContainer(editor2, (MyLineRange)toMove);
                int shift = PyStatementMover.getCaretShift(startToMove, endToMove, caretModel, isSelectionStartAtCaret);
                boolean hasSelection = selectionModel.hasSelection();
                int offset = ((ScopeRange)toMove2).isTheSameLevel() ? PyStatementMover.moveTheSameLevel((ScopeRange)toMove2, (MyLineRange)toMove) : PyStatementMover.moveInOut((MyLineRange)toMove, editor2, info);
                PyStatementMover.restoreCaretAndSelection(file2, editor2, isSelectionStartAtCaret, hasSelection, selectionLen, shift, offset, (MyLineRange)toMove);
                info.toMove2 = info.toMove;
            });
        }
    }

    private static SelectionContainer getSelectionLenContainer(@NotNull Editor editor2, @NotNull MyLineRange toMove) {
        int additionalSelection;
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(31);
        }
        if (toMove == null) {
            PyStatementMover.$$$reportNull$$$0(32);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        PsiElement startToMove = toMove.myStartElement;
        PsiElement endToMove = toMove.myEndElement;
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        TextRange range = startToMove.getTextRange();
        int column = editor2.offsetToLogicalPosition((int)selectionStart).column;
        int n = additionalSelection = range.getStartOffset() > selectionStart ? range.getStartOffset() - selectionStart : 0;
        if (startToMove == endToMove) {
            return new SelectionContainer(selectionEnd - range.getStartOffset(), additionalSelection, column == 0);
        }
        int len = range.getStartOffset() <= selectionStart ? range.getEndOffset() - selectionStart : startToMove.getTextLength();
        for (PsiElement tmp = startToMove.getNextSibling(); tmp != endToMove && tmp != null; tmp = tmp.getNextSibling()) {
            if (tmp instanceof PsiWhiteSpace) continue;
            len += tmp.getTextLength();
        }
        len = len + selectionEnd - endToMove.getTextOffset();
        return new SelectionContainer(len, additionalSelection, column == 0);
    }

    private static void restoreCaretAndSelection(@NotNull PsiFile file2, @NotNull Editor editor2, boolean selectionStartAtCaret, boolean hasSelection, @NotNull SelectionContainer selectionContainer, int shift, int offset, @NotNull MyLineRange toMove) {
        int documentLength;
        int newCaretOffset;
        if (file2 == null) {
            PyStatementMover.$$$reportNull$$$0(33);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(34);
        }
        if (selectionContainer == null) {
            PyStatementMover.$$$reportNull$$$0(35);
        }
        if (toMove == null) {
            PyStatementMover.$$$reportNull$$$0(36);
        }
        Document document = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        CaretModel caretModel = editor2.getCaretModel();
        int selectionLen = selectionContainer.myLen;
        PsiElement at = file2.findElementAt(offset);
        if (at != null) {
            PsiElement added = PyStatementMover.getCommentOrStatement(document, at);
            int size = toMove.size;
            if (size > 1) {
                for (PsiElement tmp = added.getNextSibling(); size > 1 && tmp != null; tmp = tmp.getNextSibling(), --size) {
                    if (!(tmp instanceof PsiWhiteSpace)) continue;
                    if (!selectionStartAtCaret) {
                        shift += tmp.getTextLength();
                    }
                    selectionLen += tmp.getTextLength();
                }
            }
            if (shift < 0) {
                shift = 0;
            }
            int column = editor2.offsetToLogicalPosition((int)added.getTextRange().getStartOffset()).column;
            selectionLen = selectionContainer.myAtTheBeginning || column < selectionContainer.myAdditional ? (selectionLen += column) : (selectionLen += selectionContainer.myAdditional);
            if (selectionContainer.myAtTheBeginning && selectionStartAtCaret) {
                shift = -column;
            }
        }
        if ((newCaretOffset = offset + shift) >= (documentLength = document.getTextLength())) {
            newCaretOffset = documentLength;
        }
        caretModel.moveToOffset(newCaretOffset);
        if (hasSelection) {
            if (selectionStartAtCaret) {
                int newSelectionEnd = newCaretOffset + selectionLen;
                selectionModel.setSelection(newCaretOffset, newSelectionEnd);
            } else {
                int newSelectionStart = newCaretOffset - selectionLen;
                selectionModel.setSelection(newSelectionStart, newCaretOffset);
            }
        }
    }

    private static int getCaretShift(PsiElement startToMove, PsiElement endToMove, CaretModel caretModel, boolean selectionStartAtCaret) {
        int shift;
        if (selectionStartAtCaret) {
            shift = caretModel.getOffset() - startToMove.getTextRange().getStartOffset();
        } else {
            shift = caretModel.getOffset();
            if (startToMove != endToMove) {
                shift += startToMove.getTextLength();
                for (PsiElement tmp = startToMove.getNextSibling(); tmp != endToMove && tmp != null; tmp = tmp.getNextSibling()) {
                    if (tmp instanceof PsiWhiteSpace) continue;
                    shift += tmp.getTextLength();
                }
            }
            shift -= endToMove.getTextOffset();
        }
        return shift;
    }

    private static int moveTheSameLevel(@NotNull ScopeRange toMove2, @NotNull MyLineRange toMove) {
        if (toMove2 == null) {
            PyStatementMover.$$$reportNull$$$0(37);
        }
        if (toMove == null) {
            PyStatementMover.$$$reportNull$$$0(38);
        }
        PsiElement anchor = toMove2.getAnchor();
        PsiElement anchorCopy = anchor.copy();
        PsiElement startToMove = toMove.myStartElement;
        PsiElement endToMove = toMove.myEndElement;
        PsiElement parent = anchor.getParent();
        PsiElement tmp = startToMove.getNextSibling();
        if (startToMove != endToMove && tmp != null) {
            parent.addRangeAfter(tmp, endToMove, anchor);
        }
        PsiElement startCopy = startToMove.copy();
        startToMove.replace(anchorCopy);
        PsiElement addedElement = anchor.replace(startCopy);
        if (startToMove != endToMove && tmp != null) {
            parent.deleteChildRange(tmp, endToMove);
        }
        return addedElement.getTextRange().getStartOffset();
    }

    private static int moveInOut(@NotNull MyLineRange toMove, @NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info) {
        PsiElement psiElement;
        PsiElement addedElement;
        PyStatement[] statements;
        if (toMove == null) {
            PyStatementMover.$$$reportNull$$$0(39);
        }
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(40);
        }
        if (info == null) {
            PyStatementMover.$$$reportNull$$$0(41);
        }
        boolean removePass = false;
        ScopeRange toMove2 = (ScopeRange)info.toMove2;
        PsiElement scope = toMove2.getScope();
        PsiElement anchor = toMove2.getAnchor();
        Project project = scope.getProject();
        PsiElement startElement = toMove.myStartElement;
        PsiElement endElement = toMove.myEndElement;
        PsiElement parent = startElement.getParent();
        if (scope instanceof PyStatementList && (startElement != endElement || !(startElement instanceof PsiComment)) && (statements = ((PyStatementList)scope).getStatements()).length == 1 && statements[0] == anchor && statements[0] instanceof PyPassStatement) {
            removePass = true;
        }
        PsiElement nextSibling = startElement.getNextSibling();
        if (toMove2.isAddBefore()) {
            PsiElement tmp = endElement.getPrevSibling();
            if (startElement != endElement && tmp != null) {
                addedElement = scope.addRangeBefore(startElement, tmp, anchor);
                scope.addBefore(endElement, anchor);
            } else {
                addedElement = scope.addBefore(endElement, anchor);
            }
        } else {
            if (startElement != endElement && nextSibling != null) {
                scope.addRangeAfter(nextSibling, endElement, anchor);
            }
            addedElement = scope.addAfter(startElement, anchor);
        }
        PyStatementMover.addPassStatement(toMove, project);
        if (startElement != endElement && nextSibling != null) {
            parent.deleteChildRange(nextSibling, endElement);
        }
        startElement.delete();
        int addedElementLine = editor2.getDocument().getLineNumber(addedElement.getTextOffset());
        PsiFile file2 = scope.getContainingFile();
        PyStatementMover.adjustLineIndents(editor2, scope, project, addedElement, toMove.size);
        if (removePass) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Document document = editor2.getDocument();
                int lineNumber = document.getLineNumber(anchor.getTextOffset());
                int endOffset = document.getLineCount() <= lineNumber + 1 ? document.getLineEndOffset(lineNumber) : document.getLineStartOffset(lineNumber + 1);
                document.deleteString(document.getLineStartOffset(lineNumber), endOffset);
                PsiDocumentManager.getInstance((Project)startElement.getProject()).commitAllDocuments();
            });
        }
        int offset = addedElement.getTextRange().getStartOffset();
        int newLine = editor2.getDocument().getLineNumber(offset);
        if (newLine != addedElementLine && !removePass && (psiElement = PyUtil.findNonWhitespaceAtOffset(file2, editor2.getDocument().getLineEndOffset(addedElementLine) - 1)) != null) {
            psiElement = PyStatementMover.getCommentOrStatement(editor2.getDocument(), psiElement);
            offset = psiElement.getTextRange().getStartOffset();
        }
        return offset;
    }

    private static void adjustLineIndents(@NotNull Editor editor2, @NotNull PsiElement scope, @NotNull Project project, @NotNull PsiElement addedElement, int size) {
        if (editor2 == null) {
            PyStatementMover.$$$reportNull$$$0(42);
        }
        if (scope == null) {
            PyStatementMover.$$$reportNull$$$0(43);
        }
        if (project == null) {
            PyStatementMover.$$$reportNull$$$0(44);
        }
        if (addedElement == null) {
            PyStatementMover.$$$reportNull$$$0(45);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        Document document = editor2.getDocument();
        if (!(scope instanceof PsiFile)) {
            int line1 = editor2.offsetToLogicalPosition((int)scope.getTextRange().getStartOffset()).line;
            int line2 = editor2.offsetToLogicalPosition((int)scope.getTextRange().getEndOffset()).line;
            codeStyleManager.adjustLineIndent(scope.getContainingFile(), new TextRange(document.getLineStartOffset(line1), document.getLineEndOffset(line2)));
        } else {
            PsiElement tmp;
            int line1 = editor2.offsetToLogicalPosition((int)addedElement.getTextRange().getStartOffset()).line;
            PsiElement end = addedElement;
            while (size > 0 && (tmp = end.getNextSibling()) != null) {
                --size;
                end = tmp;
            }
            int endOffset = end.getTextRange().getEndOffset();
            int line2 = editor2.offsetToLogicalPosition((int)endOffset).line;
            codeStyleManager.adjustLineIndent(scope.getContainingFile(), new TextRange(document.getLineStartOffset(line1), document.getLineEndOffset(line2)));
        }
    }

    private static void addPassStatement(@NotNull MyLineRange toMove, @NotNull Project project) {
        if (toMove == null) {
            PyStatementMover.$$$reportNull$$$0(46);
        }
        if (project == null) {
            PyStatementMover.$$$reportNull$$$0(47);
        }
        PsiElement startElement = toMove.myStartElement;
        PsiElement endElement = toMove.myEndElement;
        PyStatementList initialScope = PyStatementMover.getStatementList(startElement);
        if (!(initialScope == null || startElement == endElement && startElement instanceof PsiComment || initialScope.getStatements().length != toMove.statementsSize)) {
            PyPassStatement passStatement = PyElementGenerator.getInstance(project).createPassStatement();
            initialScope.addAfter((PsiElement)passStatement, (PsiElement)initialScope.getStatements()[initialScope.getStatements().length - 1]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 8: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToMove1";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToMove";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover";
                break;
            }
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionContainer";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove2";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentOrStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ifInsideString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveOutsideFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveToEmptyLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStatementList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "moveOut";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForComment";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moveInto";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveUpInto";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveDownInto";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCommentOrStatement";
                break;
            }
            case 27: 
            case 28: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionLenContainer";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "restoreCaretAndSelection";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "moveTheSameLevel";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "moveInOut";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndents";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addPassStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ScopeRange
    extends LineRange {
        private final PsiElement myScope;
        @NotNull
        private final PsiElement myAnchor;
        private final boolean addBefore;
        private boolean theSameLevel;

        ScopeRange(@NotNull PsiElement scope, @NotNull PsiElement anchor, boolean before) {
            if (scope == null) {
                ScopeRange.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                ScopeRange.$$$reportNull$$$0(1);
            }
            super(scope);
            this.myScope = scope;
            this.myAnchor = anchor;
            this.addBefore = before;
        }

        ScopeRange(PyElement scope, @NotNull PsiElement anchor, boolean before, boolean b) {
            if (anchor == null) {
                ScopeRange.$$$reportNull$$$0(2);
            }
            super((PsiElement)scope);
            this.myScope = scope;
            this.myAnchor = anchor;
            this.addBefore = before;
            this.theSameLevel = b;
        }

        @NotNull
        public PsiElement getAnchor() {
            PsiElement psiElement = this.myAnchor;
            if (psiElement == null) {
                ScopeRange.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        public PsiElement getScope() {
            return this.myScope;
        }

        public boolean isAddBefore() {
            return this.addBefore;
        }

        public boolean isTheSameLevel() {
            return this.theSameLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class SelectionContainer {
        private final int myLen;
        private final int myAdditional;
        private final boolean myAtTheBeginning;

        SelectionContainer(int len, int additional, boolean atTheBeginning) {
            this.myLen = len;
            this.myAdditional = additional;
            this.myAtTheBeginning = atTheBeginning;
        }
    }

    static class MyLineRange
    extends LineRange {
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;
        int size;
        int statementsSize;

        MyLineRange(@NotNull PsiElement start, PsiElement end) {
            if (start == null) {
                MyLineRange.$$$reportNull$$$0(0);
            }
            super(start, end);
            this.size = 0;
            this.statementsSize = 0;
            this.myStartElement = start;
            this.myEndElement = end;
            if (this.myStartElement == this.myEndElement) {
                this.size = 1;
                this.statementsSize = 1;
            } else {
                PsiElement counter;
                for (counter = this.myStartElement; counter != this.myEndElement && counter != null; counter = counter.getNextSibling()) {
                    ++this.size;
                    if (counter instanceof PsiWhiteSpace || counter instanceof PsiComment) continue;
                    ++this.statementsSize;
                }
                ++this.size;
                if (!(counter instanceof PsiWhiteSpace) && !(counter instanceof PsiComment)) {
                    ++this.statementsSize;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$MyLineRange", "<init>"));
        }
    }
}

