/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugSupportUtils {
    public static final String DEBUGGER_WARNING_MESSAGE = "This option may slow down the debugger";

    private PyDebugSupportUtils() {
    }

    public static boolean isExpression(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile file2 = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
            return file2.getFirstChild() instanceof PyExpressionStatement && file2.getFirstChild() == file2.getLastChild();
        });
    }

    @Nullable
    public static TextRange getExpressionRangeAtOffset(Project project, Document document, int offset) {
        return (TextRange)ReadAction.compute(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                PsiElement element = psiFile.findElementAt(offset);
                if (!(element instanceof PyExpression) || element instanceof PyLiteralExpression) {
                    element = PsiTreeUtil.getParentOfType((PsiElement)element, PyExpression.class);
                }
                if (element instanceof PyLiteralExpression) {
                    return null;
                }
                if (element != null && PyDebugSupportUtils.isSimpleEnough(element) && PyDebugSupportUtils.isExpression(project, document.getText(element.getTextRange()))) {
                    return element.getTextRange();
                }
            }
            return null;
        });
    }

    private static boolean isSimpleEnough(PsiElement element) {
        return element instanceof PyLiteralExpression || element instanceof PyQualifiedExpression || element instanceof PyBinaryExpression || element instanceof PyPrefixExpression || element instanceof PySliceExpression || element instanceof PyNamedParameter;
    }

    public static boolean canSaveToTemp(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile file2 = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
            PsiElement root = file2.getFirstChild();
            return PyDebugSupportUtils.isVariable(root) == false && root instanceof PyExpressionStatement;
        });
    }

    private static Boolean isVariable(PsiElement root) {
        return root instanceof PyExpressionStatement && root.getFirstChild() instanceof PyReferenceExpression && root.getFirstChild() == root.getLastChild() && root.getFirstChild().getFirstChild() != null && root.getFirstChild().getFirstChild().getNode().getElementType() == PyTokenTypes.IDENTIFIER && root.getFirstChild().getFirstChild() == root.getFirstChild().getLastChild() && root.getFirstChild().getFirstChild().getFirstChild() == null;
    }

    @Nullable
    private static String getLineText(@NotNull Document document, int line2) {
        if (document == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(0);
        }
        if (line2 > 0 && line2 < document.getLineCount()) {
            return document.getText(TextRange.create((int)document.getLineStartOffset(line2), (int)document.getLineEndOffset(line2)));
        }
        return null;
    }

    public static boolean isContinuationLine(@NotNull Document document, int line2) {
        String text2;
        if (document == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(1);
        }
        return (text2 = PyDebugSupportUtils.getLineText(document, line2)) != null && text2.trim().endsWith("\\");
    }

    public static boolean isCurrentPythonDebugProcess(@NotNull Project project) {
        XDebugSession session;
        if (project == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(2);
        }
        return (session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && session.getDebugProcess() instanceof PyDebugProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugSupportUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isContinuationLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrentPythonDebugProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

