/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.google.common.collect.Maps;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.debugger.dataframe.DataFrameViewStrategy;
import com.jetbrains.python.debugger.dataframe.TableValueDescriptor;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DataFrameTableModel
extends AsyncArrayTableModel {
    private final Map<Integer, ArrayChunk.ColHeader> myColHeaders = Maps.newConcurrentMap();
    private final RowHeaderModel myRowHeaderModel = new RowHeaderModel();

    public DataFrameTableModel(int rows, int columns, PyDataViewerPanel dataProvider, PyDebugValue debugValue, DataFrameViewStrategy strategy) {
        super(rows, columns, dataProvider, debugValue, strategy);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object value2 = super.getValueAt(row, col);
        if (value2 == "") {
            return value2;
        }
        TableValueDescriptor descriptor2 = this.createValueWithDescriptor(col, value2);
        return descriptor2 != null ? descriptor2 : "";
    }

    private TableValueDescriptor createValueWithDescriptor(int frameCol, Object value2) {
        ArrayChunk.ColHeader header = this.myColHeaders.get(frameCol);
        if (header == null) {
            return null;
        }
        return new TableValueDescriptor(value2.toString(), header);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return TableValueDescriptor.class;
    }

    @Override
    public String getColumnName(int col) {
        ArrayChunk.ColHeader header = this.myColHeaders.get(col);
        if (header != null && header.getLabel() != null) {
            return header.getLabel();
        }
        return super.getColumnName(col);
    }

    @Override
    protected void handleChunkAdded(Integer rowOffset, Integer colOffset, ArrayChunk chunk) {
        this.myRowHeaderModel.handleChunkAdded(rowOffset, chunk);
        boolean hasNewCols = false;
        List<ArrayChunk.ColHeader> chunkColHeaders = chunk.getColHeaders();
        if (chunkColHeaders != null) {
            for (int i = 0; i < chunkColHeaders.size(); ++i) {
                ArrayChunk.ColHeader header = chunkColHeaders.get(i);
                hasNewCols |= this.myColHeaders.put(i + colOffset, header) == null;
            }
        }
        if (hasNewCols) {
            UIUtil.invokeLaterIfNeeded(() -> super.fireTableStructureChanged());
        }
    }

    @Override
    public TableModel getRowHeaderModel() {
        return this.myRowHeaderModel;
    }

    private class RowHeaderModel
    extends AbstractTableModel {
        private final Map<Integer, String> myRowLabels = Maps.newConcurrentMap();

        private RowHeaderModel() {
        }

        @Override
        public int getRowCount() {
            return DataFrameTableModel.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "   ";
            }
            throw new IllegalArgumentException("Table only has one column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String s = this.myRowLabels.get(rowIndex);
            return s == null ? String.valueOf(rowIndex) : s;
        }

        public void handleChunkAdded(Integer rowOffset, ArrayChunk chunk) {
            List<String> chunkRowLabels = chunk.getRowLabels();
            if (chunkRowLabels != null) {
                for (int i = 0; i < chunkRowLabels.size(); ++i) {
                    String label = chunkRowLabels.get(i);
                    String oldValue = this.myRowLabels.put(i + rowOffset, label);
                    if (oldValue != null) continue;
                    int updatedRow = i + rowOffset;
                    UIUtil.invokeLaterIfNeeded(() -> super.fireTableCellUpdated(updatedRow, 0));
                }
            }
        }
    }
}

