/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyIo;
import com.jetbrains.python.debugger.PyLockEvent;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadEvent;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class ProtocolParser {
    private ProtocolParser() {
    }

    public static PySignature parseCallSignature(String payload) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(payload, true);
        reader.moveDown();
        if (!"call_signature".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <call_signature>, found " + reader.getNodeName());
        }
        String file2 = reader.getAttribute("file");
        if (file2 == null) {
            file2 = "";
        }
        String name = ProtocolParser.readString(reader, "name", "");
        PySignature signature = new PySignature(file2, name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("arg".equals(reader.getNodeName())) {
                signature.addArgument(ProtocolParser.readString(reader, "name", ""), ProtocolParser.readString(reader, "type", ""));
            } else if ("return".equals(reader.getNodeName())) {
                signature.addReturnType(ProtocolParser.readString(reader, "type", ""));
            } else {
                throw new PyDebuggerException("Expected <arg> or <return>, found " + reader.getNodeName());
            }
            reader.moveUp();
        }
        return signature;
    }

    public static PyConcurrencyEvent parseConcurrencyEvent(String payload, PyPositionConverter positionConverter) throws PyDebuggerException {
        PyConcurrencyEvent threadingEvent;
        boolean isAsyncio;
        XppReader reader = ProtocolParser.openReader(payload, true);
        reader.moveDown();
        String eventName = reader.getNodeName();
        if (eventName.equals("threading_event")) {
            isAsyncio = false;
        } else if (eventName.equals("asyncio_event")) {
            isAsyncio = true;
        } else {
            throw new PyDebuggerException("Expected <threading_event> or <asyncio_event>, found " + reader.getNodeName());
        }
        long time = Long.parseLong(ProtocolParser.readString(reader, "time", ""));
        String name = ProtocolParser.readString(reader, "name", "");
        String thread_id = ProtocolParser.readString(reader, "thread_id", "");
        String type = ProtocolParser.readString(reader, "type", "");
        if (type.equals("lock")) {
            String lock_id = ProtocolParser.readString(reader, "lock_id", "0");
            threadingEvent = new PyLockEvent(time, thread_id, name, lock_id, isAsyncio);
        } else if (type.equals("thread")) {
            String parentThread = ProtocolParser.readString(reader, "parent", "");
            threadingEvent = !parentThread.isEmpty() ? new PyThreadEvent(time, thread_id, name, parentThread, isAsyncio) : new PyThreadEvent((Long)time, thread_id, name, isAsyncio);
        } else {
            throw new PyDebuggerException("Unknown type " + type);
        }
        String eventType = ProtocolParser.readString(reader, "event", "");
        if (eventType.equals("__init__")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.CREATE);
        } else if (eventType.equals("start")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.START);
        } else if (eventType.equals("join")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.JOIN);
        } else if (eventType.equals("stop")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.STOP);
        } else if (eventType.equals("acquire_begin") || eventType.equals("__enter___begin") || eventType.equals("get_begin") || eventType.equals("put_begin")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.ACQUIRE_BEGIN);
        } else if (eventType.equals("acquire_end") || eventType.equals("__enter___end") || eventType.equals("get_end") || eventType.equals("put_end")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.ACQUIRE_END);
        } else if (eventType.startsWith("release") || eventType.startsWith("__exit__")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.RELEASE);
        } else {
            throw new PyDebuggerException("Unknown event " + eventType);
        }
        threadingEvent.setFileName(ProtocolParser.readString(reader, "file", ""));
        threadingEvent.setLine(Integer.parseInt(ProtocolParser.readString(reader, "line", "")) - 1);
        reader.moveUp();
        LinkedList<PyStackFrameInfo> frames = new LinkedList<PyStackFrameInfo>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            frames.add(ProtocolParser.parseFrame(reader, thread_id, positionConverter));
            reader.moveUp();
        }
        threadingEvent.setFrames(frames);
        return threadingEvent;
    }

    public static boolean parseInputCommand(String payload) {
        return payload.equals("True");
    }

    public static Pair<Boolean, String> parseSetNextStatementCommand(String payload) throws PyDebuggerException {
        String[] values = payload.split("\t");
        if (values.length > 0) {
            boolean success = values[0].equals("True");
            String errorMessage = "Error";
            if (values.length > 1) {
                errorMessage = errorMessage + ": " + values[1];
            }
            return new Pair((Object)success, (Object)errorMessage);
        }
        throw new PyDebuggerException("Unable to parse value: " + payload);
    }

    public static String parseSourceContent(String payload) {
        return payload;
    }

    public static String encodeExpression(String expression) {
        return StringUtil.replace((String)expression, (String)"\n", (String)"@LINE@");
    }

    public static PyIo parseIo(String text2) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, true);
        reader.moveDown();
        if (!"io".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <io>, found " + reader.getNodeName());
        }
        String s = ProtocolParser.readString(reader, "s", "");
        int ctx = ProtocolParser.readInt(reader, "ctx", 1);
        return new PyIo(s, ctx);
    }

    @NotNull
    public static PyThreadInfo parseThread(String text2, PyPositionConverter positionConverter) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, true);
        reader.moveDown();
        if (!"thread".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <thread>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name = ProtocolParser.readString(reader, "name", "");
        int stopReason = ProtocolParser.readInt(reader, "stop_reason", 0);
        String message = ProtocolParser.readString(reader, "message", "None");
        if ("None".equals(message) || message.isEmpty()) {
            message = null;
        }
        LinkedList<PyStackFrameInfo> frames = new LinkedList<PyStackFrameInfo>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            frames.add(ProtocolParser.parseFrame(reader, id, positionConverter));
            reader.moveUp();
        }
        return new PyThreadInfo(id, name, frames, stopReason, message);
    }

    @NotNull
    public static String getThreadId(@NotNull String payload) {
        if (payload == null) {
            ProtocolParser.$$$reportNull$$$0(0);
        }
        String string = payload.split("\t")[0];
        if (string == null) {
            ProtocolParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static PyStackFrameInfo parseFrame(XppReader reader, String threadId, PyPositionConverter positionConverter) throws PyDebuggerException {
        if (!"frame".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <frame>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name = ProtocolParser.readString(reader, "name", null);
        String file2 = reader.getAttribute("file");
        int line2 = ProtocolParser.readInt(reader, "line", 0);
        return new PyStackFrameInfo(threadId, id, name, positionConverter.convertPythonToFrame(file2, line2));
    }

    @NotNull
    public static PyDebugValue parseValue(String text2, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, true);
        reader.moveDown();
        PyDebugValue pyDebugValue = ProtocolParser.parseValue(reader, frameAccessor);
        if (pyDebugValue == null) {
            ProtocolParser.$$$reportNull$$$0(2);
        }
        return pyDebugValue;
    }

    @NotNull
    public static List<PyDebugValue> parseReferrers(String text2, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text2, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("var")) {
                PyDebugValue value2 = ProtocolParser.parseValue(reader, frameAccessor);
                value2.setId(ProtocolParser.readString(reader, "id", null));
                values.add(value2);
            } else if (!reader.getNodeName().equals("for")) {
                throw new PyDebuggerException("Expected <var> or <for>, found " + reader.getNodeName());
            }
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            ProtocolParser.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    @NotNull
    public static List<PyDebugValue> parseValues(String text2, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text2, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            values.add(ProtocolParser.parseValue(reader, frameAccessor));
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            ProtocolParser.$$$reportNull$$$0(4);
        }
        return linkedList;
    }

    private static PyDebugValue parseValue(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        if (!"var".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <var>, found " + reader.getNodeName());
        }
        String name = ProtocolParser.readString(reader, "name", null);
        String type = ProtocolParser.readString(reader, "type", null);
        String qualifier = ProtocolParser.readString(reader, "qualifier", "");
        String value2 = ProtocolParser.readString(reader, "value", null);
        String isContainer = ProtocolParser.readString(reader, "isContainer", "");
        String isReturnedValue = ProtocolParser.readString(reader, "isRetVal", "");
        String isIPythonHidden = ProtocolParser.readString(reader, "isIPythonHidden", "");
        String isErrorOnEval = ProtocolParser.readString(reader, "isErrorOnEval", "");
        String shape = ProtocolParser.readString(reader, "shape", "");
        if (value2.startsWith(type + ": ")) {
            value2 = value2.substring(type.length() + 2);
        }
        if (shape.isEmpty()) {
            shape = null;
        }
        return new PyDebugValue(name, type, qualifier, value2, "True".equals(isContainer), shape, "True".equals(isReturnedValue), "True".equals(isIPythonHidden), "True".equals(isErrorOnEval), frameAccessor);
    }

    public static ArrayChunk parseArrayValues(String text2, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, false);
        ArrayChunkBuilder result = new ArrayChunkBuilder();
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"array".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <array> at first node, found " + reader.getNodeName());
            }
            String slice = ProtocolParser.readString(reader, "slice", null);
            result.setSlicePresentation(slice);
            result.setRows(ProtocolParser.readInt(reader, "rows", null));
            result.setColumns(ProtocolParser.readInt(reader, "cols", null));
            result.setFormat("%" + ProtocolParser.readString(reader, "format", null));
            result.setType(ProtocolParser.readString(reader, "type", null));
            result.setMax(ProtocolParser.readString(reader, "max", null));
            result.setMin(ProtocolParser.readString(reader, "min", null));
            result.setValue(new PyDebugValue(slice, null, null, null, false, null, false, false, false, frameAccessor));
            reader.moveUp();
        }
        if ("headerdata".equals(reader.peekNextChild())) {
            ProtocolParser.parseArrayHeaderData(reader, result);
        }
        Object[][] data = ProtocolParser.parseArrayValues(reader, frameAccessor);
        result.setData(data);
        return result.createArrayChunk();
    }

    @NotNull
    public static List<Pair<String, Boolean>> parseSmartStepIntoVariants(String text2) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, false);
        ArrayList variants = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String variantName = ProtocolParser.read(reader, "name", true);
            Boolean isVisited = ProtocolParser.read(reader, "isVisited", true).equals("true");
            variants.add(Pair.create((Object)variantName, (Object)isVisited));
            reader.moveUp();
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            ProtocolParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void parseArrayHeaderData(XppReader reader, ArrayChunkBuilder result) throws PyDebuggerException {
        ArrayList rowHeaders = Lists.newArrayList();
        ArrayList colHeaders = Lists.newArrayList();
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("colheader".equals(reader.getNodeName())) {
                colHeaders.add(new ArrayChunk.ColHeader(ProtocolParser.readString(reader, "label", null), ProtocolParser.readString(reader, "type", null), ProtocolParser.readString(reader, "format", null), ProtocolParser.readString(reader, "max", null), ProtocolParser.readString(reader, "min", null)));
            } else if ("rowheader".equals(reader.getNodeName())) {
                rowHeaders.add(ProtocolParser.readString(reader, "label", null));
            } else {
                throw new PyDebuggerException("Invalid node name" + reader.getNodeName());
            }
            reader.moveUp();
        }
        result.setColHeaders(colHeaders);
        result.setRowLabels(rowHeaders);
        reader.moveUp();
    }

    public static Object[][] parseArrayValues(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        int rows = -1;
        int cols = -1;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"arraydata".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <arraydata> at second node, found " + reader.getNodeName());
            }
            rows = ProtocolParser.readInt(reader, "rows", null);
            cols = ProtocolParser.readInt(reader, "cols", null);
            reader.moveUp();
        }
        if (rows <= 0 || cols <= 0) {
            throw new PyDebuggerException("Array xml: bad rows or columns number: (" + rows + ", " + cols + ")");
        }
        Object[][] values = new Object[rows][cols];
        int currRow = 0;
        int currCol = 0;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"var".equals(reader.getNodeName()) && !"row".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <var> or <row>, found " + reader.getNodeName());
            }
            if ("row".equals(reader.getNodeName())) {
                int index = ProtocolParser.readInt(reader, "index", null);
                if (currRow != index) {
                    throw new PyDebuggerException("Array xml: expected " + currRow + " row, found " + index);
                }
                if (currRow > 0 && currCol != cols) {
                    throw new PyDebuggerException("Array xml: expected " + cols + " filled columns, got " + currCol + " instead.");
                }
                ++currRow;
                currCol = 0;
            } else {
                PyDebugValue value2 = ProtocolParser.parseValue(reader, frameAccessor);
                values[currRow - 1][currCol] = value2.getValue();
                ++currCol;
            }
            reader.moveUp();
        }
        return values;
    }

    public static String parseWarning(String text2) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text2, true);
        reader.moveDown();
        return ProtocolParser.readString(reader, "id", null);
    }

    private static XppReader openReader(String text2, boolean checkForContent) throws PyDebuggerException {
        XppReader reader = new XppReader((Reader)new StringReader(text2), (XmlPullParser)new MXParser(), (NameCoder)new NoNameCoder());
        if (checkForContent && !reader.hasMoreChildren()) {
            throw new PyDebuggerException("Empty frame: " + text2);
        }
        return reader;
    }

    private static String readString(XppReader reader, String name, String fallback) throws PyDebuggerException {
        String value2 = ProtocolParser.read(reader, name, fallback == null);
        return value2 == null ? fallback : value2;
    }

    private static int readInt(XppReader reader, String name, Integer fallback) throws PyDebuggerException {
        String value2 = ProtocolParser.read(reader, name, fallback == null);
        if (value2 == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new PyDebuggerException("Unable to decode " + value2 + ": " + e.getMessage());
        }
    }

    @Contract(value="_, _, true -> !null")
    private static String read(XppReader reader, String name, boolean isRequired) throws PyDebuggerException {
        String value2 = reader.getAttribute(name);
        if (value2 == null && isRequired) {
            throw new PyDebuggerException("Attribute not found: " + name);
        }
        return value2 == null ? null : URLUtil.decode((String)value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/ProtocolParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/ProtocolParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReferrers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSmartStepIntoVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThreadId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

