/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.python.debugger.remote.PyRemoteDebugCommandLineState;
import com.jetbrains.python.debugger.remote.PyRemoteDebugConfigurationEditor;
import com.jetbrains.python.debugger.remote.PyRemoteDebugConfigurationForm;
import com.jetbrains.python.debugger.remote.PyRemoteDebugConfigurationParams;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyRemoteDebugConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule, Element>
implements PyRemoteDebugConfigurationParams,
RunConfigurationWithSuppressedDefaultRunAction {
    @NonNls
    private static final String PORT = "PORT";
    @NonNls
    private static final String HOST = "HOST";
    @NonNls
    private static final String REDIRECT_OUTPUT = "REDIRECT_OUTPUT";
    @NonNls
    private static final String SUSPEND_AFTER_CONNECT = "SUSPEND_AFTER_CONNECT";
    @NonNls
    private static final String USE_MAPPING = "USE_MAPPING";
    @NonNls
    private static final String REMOTE_ROOT = "REMOTE_ROOT";
    @NonNls
    private static final String LOCAL_ROOT = "LOCAL_ROOT";
    private int myPort;
    private String myHost;
    private boolean myRedirectOutput;
    private boolean mySuspendAfterConnect;
    private PathMappingSettings myPathMappingSettings;

    public static PathMappingSettings createPathMapping() {
        return new PathMappingSettings();
    }

    public PyRemoteDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(1);
        }
        super(name, new RunConfigurationModule(project), factory);
        this.myRedirectOutput = true;
        this.mySuspendAfterConnect = true;
        this.myPathMappingSettings = PyRemoteDebugConfiguration.createPathMapping();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new PyRemoteDebugConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(3);
        }
        return new PyRemoteDebugCommandLineState(this.getProject(), env);
    }

    private void doValidateConfiguration() throws RuntimeConfigurationException {
        if (this.myPort < 0 || this.myPort > 65535) {
            throw new RuntimeConfigurationError("Port number is out of boundaries.");
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.doValidateConfiguration();
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    @NotNull
    public List<Module> getValidModules() {
        ArrayList arrayList = Lists.newArrayList((Object[])ModuleManager.getInstance((Project)this.getProject()).getModules());
        if (arrayList == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        this.readModule(element);
        this.setHost(JDOMExternalizerUtil.readField((Element)element, (String)HOST));
        this.setPort(JDOMExternalizerUtil.readField((Element)element, (String)PORT));
        boolean useMapping = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)USE_MAPPING, (String)"false"));
        if (useMapping) {
            PathMappingSettings settings = new PathMappingSettings((List)Lists.newArrayList((Object[])new PathMappingSettings.PathMapping[]{new PathMappingSettings.PathMapping(JDOMExternalizerUtil.readField((Element)element, (String)LOCAL_ROOT), JDOMExternalizerUtil.readField((Element)element, (String)REMOTE_ROOT))}));
            this.setMappingSettings(settings);
        } else {
            Element settingsElement = element.getChild(PathMappingSettings.class.getSimpleName());
            if (settingsElement != null) {
                this.setMappingSettings((PathMappingSettings)XmlSerializer.deserialize((Element)settingsElement, PathMappingSettings.class));
            }
        }
        this.setRedirectOutput(Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)REDIRECT_OUTPUT, (String)"true")));
        this.setSuspendAfterConnect(Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)SUSPEND_AFTER_CONNECT, (String)"true")));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PyRemoteDebugConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)PORT, (String)String.valueOf(this.getPort()));
        JDOMExternalizerUtil.writeField((Element)element, (String)HOST, (String)String.valueOf(this.myHost));
        element.addContent(XmlSerializer.serialize((Object)this.myPathMappingSettings));
        JDOMExternalizerUtil.writeField((Element)element, (String)REDIRECT_OUTPUT, (String)String.valueOf(this.isRedirectOutput()));
        JDOMExternalizerUtil.writeField((Element)element, (String)SUSPEND_AFTER_CONNECT, (String)String.valueOf(this.isSuspendAfterConnect()));
    }

    @Override
    public boolean isRedirectOutput() {
        return this.myRedirectOutput;
    }

    @Override
    public void setRedirectOutput(boolean redirectOutput) {
        this.myRedirectOutput = redirectOutput;
    }

    public static void copyParams(PyRemoteDebugConfigurationParams fromParams, PyRemoteDebugConfigurationParams toParams) {
        toParams.setHost(fromParams.getHost());
        toParams.setPort(fromParams.getPort());
        toParams.setMappingSettings(fromParams.getMappingSettings());
        toParams.setRedirectOutput(fromParams.isRedirectOutput());
        toParams.setSuspendAfterConnect(fromParams.isSuspendAfterConnect());
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    public void setPort(String port) {
        this.setPort(PyRemoteDebugConfiguration.textToPort(port));
    }

    @Override
    public void setPort(int port) {
        this.myPort = port;
    }

    @Override
    public String getHost() {
        return this.myHost;
    }

    @Override
    public void setHost(String host) {
        if (host == null) {
            host = "localhost";
        }
        this.myHost = host;
    }

    @Override
    public void setMappingSettings(PathMappingSettings mappingSettings) {
        this.myPathMappingSettings = mappingSettings != null ? mappingSettings : new PathMappingSettings();
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myPathMappingSettings;
    }

    @Override
    public boolean isSuspendAfterConnect() {
        return this.mySuspendAfterConnect;
    }

    @Override
    public void setSuspendAfterConnect(boolean suspendAfterConnect) {
        this.mySuspendAfterConnect = suspendAfterConnect;
    }

    public static int textToPort(String text2) {
        int port;
        try {
            port = Integer.parseInt(text2);
        }
        catch (Exception e) {
            port = 0;
        }
        return port;
    }

    public String getSettraceCall(int port) {
        return "import pydevd_pycharm\n" + PyRemoteDebugConfigurationForm.getSettraceCallText(this.getHost(), port, this.isRedirectOutput(), this.isSuspendAfterConnect());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/PyRemoteDebugConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/PyRemoteDebugConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

