/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.facet;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.library.PythonLibraryType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FacetLibraryConfigurator {
    private FacetLibraryConfigurator() {
    }

    public static void attachPythonLibrary(final Module module, final @Nullable ModifiableRootModel existingModel, final String libraryName, final List<String> paths) {
        final ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.SERVICE.getInstance();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Library lib;
                ModifiableRootModel model = existingModel != null ? existingModel : modelsProvider.getModuleModifiableModel(module);
                LibraryOrderEntry orderEntry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)libraryName);
                if (orderEntry != null && (lib = orderEntry.getLibrary()) != null) {
                    if (lib instanceof LibraryImpl && ((LibraryImpl)lib).getKind() == null) {
                        model.removeOrderEntry((OrderEntry)orderEntry);
                        LibraryTablesRegistrar.getInstance().getLibraryTable(model.getProject()).removeLibrary(lib);
                        this.createNewLibrary(model);
                        return;
                    }
                    FacetLibraryConfigurator.fillLibrary(module.getProject(), lib, paths);
                    if (existingModel == null) {
                        modelsProvider.commitModuleModifiableModel(model);
                    }
                    return;
                }
                this.createNewLibrary(model);
            }

            private void createNewLibrary(ModifiableRootModel model) {
                LibraryTable.ModifiableModel projectLibrariesModel = modelsProvider.getLibraryTableModifiableModel(model.getProject());
                Library lib = projectLibrariesModel.createLibrary(libraryName, PythonLibraryType.getInstance().getKind());
                FacetLibraryConfigurator.fillLibrary(module.getProject(), lib, paths);
                projectLibrariesModel.commit();
                model.addLibraryEntry(lib);
                if (existingModel == null) {
                    modelsProvider.commitModuleModifiableModel(model);
                }
            }
        });
    }

    private static void fillLibrary(Project project, Library lib, List<String> paths) {
        Library.ModifiableModel modifiableModel = lib.getModifiableModel();
        for (String root : lib.getUrls(OrderRootType.CLASSES)) {
            modifiableModel.removeRoot(root, OrderRootType.CLASSES);
        }
        HashSet roots = new HashSet();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Collections.addAll(roots, rootManager.getContentRoots());
        Collections.addAll(roots, rootManager.getContentSourceRoots());
        if (paths != null) {
            for (String dir : paths) {
                VirtualFile pathEntry = LocalFileSystem.getInstance().findFileByPath(dir);
                if (pathEntry != null && !pathEntry.isDirectory() && pathEntry.getFileType() instanceof ArchiveFileType) {
                    pathEntry = JarFileSystem.getInstance().getJarRootForLocalFile(pathEntry);
                }
                if (pathEntry != null && roots.contains(pathEntry)) continue;
                if (pathEntry != null) {
                    modifiableModel.addRoot(pathEntry, OrderRootType.CLASSES);
                    continue;
                }
                modifiableModel.addRoot("file://" + dir, OrderRootType.CLASSES);
            }
        }
        modifiableModel.commit();
    }

    public static void detachPythonLibrary(Module module, String libraryName) {
        ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.SERVICE.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = modelsProvider.getModuleModifiableModel(module);
            LibraryOrderEntry entry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)libraryName);
            if (entry == null) {
                modelsProvider.disposeModuleModifiableModel(model);
            } else {
                model.removeOrderEntry((OrderEntry)entry);
                modelsProvider.commitModuleModifiableModel(model);
            }
        });
    }
}

