/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.parametersInspection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.gherkin.PyBDDBundle;
import com.jetbrains.python.gherkin.PyBDDFramework;
import com.jetbrains.python.gherkin.PyBDDUnnamedArgumentsGenerator;
import com.jetbrains.python.gherkin.parametersInspection.AddParameterQuickFix;
import com.jetbrains.python.gherkin.parametersInspection.GetParamNamesFilter;
import com.jetbrains.python.gherkin.parametersInspection.PyBDDParametersInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PyBDDParametersVisitor
extends PyInspectionVisitor {
    @NotNull
    private final PyBDDFramework myFrameworkToLaunch;

    PyBDDParametersVisitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull PyBDDFramework frameworkToLaunch) {
        if (session == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(0);
        }
        if (frameworkToLaunch == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(1);
        }
        super(holder, session);
        this.myFrameworkToLaunch = frameworkToLaunch;
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        PyDecoratorList decoratorList;
        if (node == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(2);
        }
        if ((decoratorList = node.getDecoratorList()) == null) {
            return;
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight(node.getProject());
        for (PyDecorator decorator : decoratorList.getDecorators()) {
            if (!this.myFrameworkToLaunch.isStepDefinition(decorator, false, context)) continue;
            List<Trinity<String, String, Boolean>> requiredParams = this.getRecommendedParams(decorator, context);
            StructuredDocString docString = node.getStructuredDocString();
            for (PyParameter parameter : node.getParameterList().getParameters()) {
                PyNamedParameter namedParameter = parameter.getAsNamed();
                if (namedParameter == null || namedParameter.isPositionalContainer() || namedParameter.isKeywordContainer()) {
                    return;
                }
                if (PyBDDParametersInspectionExtension.Companion.ignoreParameter(namedParameter, this.myTypeEvalContext)) continue;
                String parameterName = namedParameter.getRepr(false);
                if (requiredParams.isEmpty()) {
                    this.registerProblem((PsiElement)parameter, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.parameters.excess_param", parameterName), new PyRemoveArgumentQuickFix());
                    break;
                }
                Trinity<String, String, Boolean> recommendedParameter = requiredParams.get(0);
                if (recommendedParameter.first != null && ((Boolean)recommendedParameter.third).booleanValue() && !parameterName.equals(recommendedParameter.first)) {
                    this.registerProblem((PsiElement)parameter, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.parameters.bad_name", parameterName, recommendedParameter.first), new RenameParameterQuickFix((String)recommendedParameter.first));
                }
                if (docString != null && recommendedParameter.second != null) {
                    String currentType = docString.getParamType(parameterName);
                    PyStringLiteralExpression docStringExpression = node.getDocStringExpression();
                    if (currentType != null && !((String)recommendedParameter.second).equals(currentType) && docStringExpression != null) {
                        this.registerProblem((PsiElement)parameter, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.parameters.bad_type", parameterName, recommendedParameter.second, currentType));
                    }
                }
                requiredParams.remove(0);
            }
            if (requiredParams.isEmpty()) continue;
            this.processLackOfArguments(node, requiredParams.stream().map(o -> Pair.create((Object)o.first, (Object)o.second)).collect(Collectors.toList()));
        }
    }

    private void processLackOfArguments(@NotNull PyFunction stepDefinitionFunction, @NotNull List<Pair<String, String>> unacceptedParameters) {
        if (stepDefinitionFunction == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(3);
        }
        if (unacceptedParameters == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(4);
        }
        List paramsLeft = Lists.transform(unacceptedParameters, (Function)GetParamNamesFilter.INSTANCE);
        ArrayList<Pair<String, String>> paramAndTypeInfo = new ArrayList<Pair<String, String>>();
        PyBDDUnnamedArgumentsGenerator argumentsGenerator = new PyBDDUnnamedArgumentsGenerator(stepDefinitionFunction.getParameterList());
        for (Pair<String, String> param : unacceptedParameters) {
            String name = param.first != null ? (String)param.first : argumentsGenerator.generateArgName();
            paramAndTypeInfo.add(Pair.create((Object)name, (Object)param.second));
        }
        this.registerProblem((PsiElement)stepDefinitionFunction.getParameterList(), PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.parameters.not_enough_arguments", paramsLeft), new AddParameterQuickFix(paramAndTypeInfo, stepDefinitionFunction));
    }

    @NotNull
    private List<Trinity<String, String, Boolean>> getRecommendedParams(@NotNull PyDecorator decorator, @NotNull TypeEvalContext context) {
        if (decorator == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(6);
        }
        List requiredParams = this.myFrameworkToLaunch.getStepDefinitionRequiredParams().stream().map(o -> Trinity.create((Object)o.first, (Object)o.second, (Object)false)).collect(Collectors.toCollection(ArrayList::new));
        for (String varName : this.myFrameworkToLaunch.createStepDefinition(decorator, context).getPlaceHolders(this.myTypeEvalContext)) {
            requiredParams.add(Trinity.create((Object)varName, (Object)"str", (Object)true));
        }
        List list = requiredParams;
        if (list == null) {
            PyBDDParametersVisitor.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkToLaunch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unacceptedParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/parametersInspection/PyBDDParametersVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/parametersInspection/PyBDDParametersVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFunction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processLackOfArguments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedParams";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

