/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.ui.PyUiUtil;
import org.jetbrains.annotations.NotNull;

public class AddMethodQuickFix
implements LocalQuickFix {
    private final String myClassName;
    private final boolean myReplaceUsage;
    private final String myIdentifier;

    public AddMethodQuickFix(String identifier, String className, boolean replaceUsage) {
        this.myIdentifier = identifier;
        this.myClassName = className;
        this.myReplaceUsage = replaceUsage;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.method.$0.to.class.$1", this.myIdentifier, this.myClassName);
        if (string == null) {
            AddMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.add.method.to.class", new Object[0]);
        if (string == null) {
            AddMethodQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddMethodQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            AddMethodQuickFix.$$$reportNull$$$0(3);
        }
        try {
            PsiElement problemElement = descriptor2.getPsiElement();
            PyClassType type = AddMethodQuickFix.getClassType(problemElement);
            if (type == null) {
                return;
            }
            PyClass cls = type.getPyClass();
            boolean callByClass = type.isDefinition();
            PyStatementList clsStmtList = cls.getStatementList();
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)clsStmtList));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier, (PsiElement)cls);
            PsiElement pe = problemElement.getParent();
            String decoratorName = null;
            PyExpression[] args2 = PyExpression.EMPTY_ARRAY;
            if (pe instanceof PyCallExpression) {
                PyArgumentList arglist = ((PyCallExpression)pe).getArgumentList();
                if (arglist == null) {
                    return;
                }
                args2 = arglist.getArguments();
            }
            boolean madeInstance = false;
            if (callByClass) {
                TypeEvalContext context;
                PyType pyType;
                if (args2.length > 0 && (pyType = (context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile())).getType(args2[0])) instanceof PyClassType && ((PyClassType)pyType).getPyClass().isSubclass(cls, context)) {
                    builder.parameter("self");
                    madeInstance = true;
                }
                if (!madeInstance) {
                    builder.parameter("cls");
                    decoratorName = "classmethod";
                }
            } else {
                builder.parameter("self");
            }
            boolean skipFirst = callByClass && madeInstance;
            for (PyExpression arg : args2) {
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                if (arg instanceof PyKeywordArgument) {
                    builder.parameter(((PyKeywordArgument)arg).getKeyword());
                    continue;
                }
                if (arg instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)arg;
                    builder.parameter(refex.getReferencedName());
                    continue;
                }
                builder.parameter("param");
            }
            PyFunction pyFunction = builder.buildFunction();
            if (decoratorName != null) {
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyDecoratorList decoratorList = generator.createFromText(LanguageLevel.getDefault(), PyDecoratorList.class, "@" + decoratorName + "\ndef foo(): pass", new int[]{0, 0});
                pyFunction.addBefore((PsiElement)decoratorList, pyFunction.getFirstChild());
            }
            PyFunction pyFunction2 = (PyFunction)PyPsiRefactoringUtil.addElementToStatementList(pyFunction, clsStmtList, "__init__".equals(pyFunction.getName()));
            if (this.myReplaceUsage) {
                AddMethodQuickFix.showTemplateBuilder(pyFunction2);
            }
        }
        catch (IncorrectOperationException ignored) {
            PyUiUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.method", new Object[0]), MessageType.ERROR);
        }
    }

    private static PyClassType getClassType(@NotNull PsiElement problemElement) {
        if (problemElement == null) {
            AddMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (problemElement instanceof PyQualifiedExpression) {
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            return type instanceof PyClassType ? (PyClassType)type : null;
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyClass.class);
        return pyClass != null ? new PyClassTypeImpl(pyClass, false) : null;
    }

    private static void showTemplateBuilder(@NotNull PyFunction method) {
        PsiFile file2;
        if (method == null) {
            AddMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((file2 = (method = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method)).getContainingFile()) == null) {
            return;
        }
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        PyStatementList statementList = method.getStatementList();
        builder.replaceElement((PsiElement)statementList, "pass");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        Editor editor2 = FileEditorManager.getInstance((Project)file2.getProject()).openTextEditor(new OpenFileDescriptor(file2.getProject(), virtualFile2), true);
        if (editor2 == null) {
            return;
        }
        builder.run(editor2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

