/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.remote.PyHelpersUpload;
import com.jetbrains.python.remote.PyRemoteInterpreterCommandLineUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessUtil {
    private PyRemoteProcessUtil() {
    }

    public static void uploadAllHelpers(@NotNull RemoteSdkCredentials data, @Nullable Project project) {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(0);
        }
        PyHelpersUpload.uploadAllHelpers(project, null, data, false);
    }

    public static void shutDownHelpersService() {
        PyHelpersUpload.shutDownService();
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NonNls String[] command, @Nullable String workingDir, boolean askForSudo, boolean checkHelpers) throws RemoteSdkException {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(2);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        if (checkHelpers) {
            PyRemoteProcessUtil.uploadAllHelpers(data, project);
        }
        return PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, workingDir, askForSudo);
    }

    public static ConnectionBuilder checkConnectionAndGetSession(@Nullable Project project, RemoteSdkCredentials data, @NotNull Set<String> helpersRoots) throws RemoteSdkException {
        if (helpersRoots == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(3);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        if (!helpersRoots.isEmpty()) {
            PyHelpersUpload.uploadHelpersSync(project, data, helpersRoots);
        }
        return connectionBuilder;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NonNls String[] command, @Nullable String workingDir, boolean askForSudo, @NotNull Set<String> checkHelpersPaths) throws RemoteSdkException {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(5);
        }
        if (checkHelpersPaths == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(6);
        }
        ConnectionBuilder connectionBuilder = PyRemoteProcessUtil.checkConnectionAndGetSession(project, data, checkHelpersPaths);
        return PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, workingDir, askForSudo);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, String @NotNull [] command) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(7);
        }
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(9);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(10);
        }
        return PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, null, false);
    }

    @NotNull
    private static ProcessOutput getProcessOutput(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, String @NotNull [] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(12);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(13);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(14);
        }
        ProcessOutput processOutput = PyRemoteProcessUtil.getProcessHandler(connectionBuilder, data, pathMapper, command, workingDir, askForSudo).runProcess();
        if (processOutput == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(15);
        }
        return processOutput;
    }

    @NotNull
    public static CapturingSshProcessHandler getProcessHandler(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, String @NotNull [] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        SshExecProcess process2;
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(16);
        }
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(17);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(18);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(19);
        }
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine(pathMapper, command, workingDir, data.getInterpreterPath());
        GeneralCommandLine commandLine = new GeneralCommandLine((String[])commandWithWorkingDir.first).withWorkDirectory((String)commandWithWorkingDir.second);
        PythonEnvUtil.setPythonUnbuffered(commandLine.getEnvironment());
        ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withSudo(askForSudo, (PasswordStringProvider)new DialogSshSudoPasswordStringProvider(data)).withAllocatePty(false);
        try {
            process2 = builder.start();
        }
        catch (SshTransportException exc) {
            throw new RemoteSdkException("Failed to connect to the SSH server: " + exc.getMessage(), (Throwable)exc);
        }
        return new CapturingSshProcessHandler((SshProcess)process2, null, commandLine.getCommandLineString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkHelpersPaths";
                break;
            }
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionBuilder";
                break;
            }
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadAllHelpers";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConnectionAndGetSession";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

